/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei.drawable;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec2;

public class ChimneySmokeAnimatedDrawable
implements IDrawableAnimated {
    private Random random = new Random();
    private float speed = 1.0f;
    private float intensity = 1.0f;
    private List<IDrawable> smokeParticles = new ArrayList<IDrawable>();
    private List<Tuple<Vec2, Integer>> currentParticles = new ArrayList<Tuple<Vec2, Integer>>();
    private int animationSpeedTicks = 1;
    private long previousGameTime = 0L;
    private int particleAddDelay = 0;

    public ChimneySmokeAnimatedDrawable(IGuiHelper helper) {
        IDrawableStatic particle11 = helper.drawableBuilder(new ResourceLocation("minecraft", "textures/particle/big_smoke_11.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.smokeParticles.add((IDrawable)particle11);
        IDrawableStatic particle10 = helper.drawableBuilder(new ResourceLocation("minecraft", "textures/particle/big_smoke_10.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.smokeParticles.add((IDrawable)particle10);
        for (int i = 0; i < 12; ++i) {
            IDrawableStatic particle = helper.drawableBuilder(new ResourceLocation("minecraft", "textures/particle/big_smoke_" + i + ".png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
            this.smokeParticles.add((IDrawable)particle);
        }
    }

    public void draw(PoseStack poseStack, int xOffset, int yOffset) {
        this.calculateAnimationTick();
        for (Tuple<Vec2, Integer> particle : this.currentParticles) {
            Vec2 pos = (Vec2)particle.m_14418_();
            int index = (Integer)particle.m_14419_();
            IDrawable particleFrame = this.smokeParticles.get(index);
            poseStack.m_85837_(0.0, 0.0, 100.0);
            particleFrame.draw(poseStack, (int)((float)xOffset + pos.f_82470_), (int)((float)yOffset + pos.f_82471_));
        }
    }

    private void update() {
        --this.particleAddDelay;
        if (this.particleAddDelay <= 0 && this.currentParticles.size() < (int)(11.0f * this.getIntensity())) {
            this.particleAddDelay = this.random.nextInt(4, (int)(11.0f - 5.0f * this.getIntensity()));
            this.currentParticles.add((Tuple<Vec2, Integer>)new Tuple((Object)new Vec2((float)this.random.nextGaussian(), (float)(-(this.random.nextDouble() * 5.0))), (Object)0));
        }
        ArrayList<Tuple<Vec2, Integer>> particlesToRemove = new ArrayList<Tuple<Vec2, Integer>>();
        for (int i = 0; i < this.currentParticles.size(); ++i) {
            Tuple<Vec2, Integer> particle = this.currentParticles.get(i);
            particle.m_145025_((Object)((Integer)particle.m_14419_() + 1));
            particle.m_145023_((Object)((Vec2)particle.m_14418_()).m_165910_(new Vec2((float)this.random.nextInt(0, 2), -2.0f * this.getSpeed())));
            if ((Integer)particle.m_14419_() < this.smokeParticles.size()) continue;
            particlesToRemove.add(particle);
        }
        particlesToRemove.forEach(particleToRemove -> this.currentParticles.remove(particleToRemove));
    }

    private void calculateAnimationTick() {
        long gameTime = Minecraft.m_91087_().f_91073_.m_46467_();
        if (Math.abs(gameTime - this.previousGameTime) > (long)this.animationSpeedTicks) {
            this.update();
            this.previousGameTime = gameTime;
        }
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }

    public int getAnimationSpeedTicks() {
        return this.animationSpeedTicks;
    }

    public void setAnimationSpeedTicks(int ticks) {
        this.animationSpeedTicks = ticks;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setIntensity(float strength) {
        this.intensity = strength;
    }
}

