/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks;

import com.ldtteam.storageracks.utils.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HighlightManager {
    @Nullable
    public static final Map<String, List<TimedBoxRenderData>> HIGHLIGHT_MAP = new HashMap<String, List<TimedBoxRenderData>>();
    public static final RenderBuffers renderBuffers = new RenderBuffers();
    private static final MultiBufferSource.BufferSource renderBuffer = renderBuffers.m_110104_();
    private static final Supplier<VertexConsumer> linesWithoutCullAndDepth = () -> renderBuffer.m_6299_(RenderUtils.LINES_GLINT);

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderWorldLastEvent(@NotNull RenderLevelLastEvent event) {
        if (!HIGHLIGHT_MAP.isEmpty()) {
            long worldTime = Minecraft.m_91087_().f_91073_.m_46467_();
            Iterator<List<TimedBoxRenderData>> categoryIterator = HIGHLIGHT_MAP.values().iterator();
            while (categoryIterator.hasNext()) {
                List<TimedBoxRenderData> boxes = categoryIterator.next();
                Iterator<TimedBoxRenderData> boxListIterator = boxes.iterator();
                while (boxListIterator.hasNext()) {
                    TimedBoxRenderData boxRenderData = boxListIterator.next();
                    if (boxRenderData.removalTimePoint <= worldTime) {
                        boxListIterator.remove();
                        continue;
                    }
                    RenderUtils.renderBox(boxRenderData.pos, boxRenderData.pos, boxRenderData.getRed(), boxRenderData.getGreen(), boxRenderData.getBlue(), 1.0f, 0.002, event.getPoseStack(), linesWithoutCullAndDepth.get());
                    if (boxRenderData.text.isEmpty()) continue;
                    MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                    RenderUtils.renderDebugText(boxRenderData.pos, boxRenderData.text, event.getPoseStack(), true, 3, (MultiBufferSource)buffer);
                    RenderSystem.m_69465_();
                    buffer.m_109911_();
                    RenderSystem.m_69482_();
                }
                if (!boxes.isEmpty()) continue;
                categoryIterator.remove();
            }
        }
        renderBuffer.m_109911_();
    }

    public static void addRenderBox(String category, TimedBoxRenderData data) {
        HIGHLIGHT_MAP.computeIfAbsent(category, k -> new ArrayList()).add(data);
    }

    public static void clearCategory(String category) {
        HIGHLIGHT_MAP.remove(category);
    }

    public static class TimedBoxRenderData {
        private List<String> text = new ArrayList<String>();
        private BlockPos pos = BlockPos.f_121853_;
        private long removalTimePoint = 0L;
        private int hexColor = 0xFFFFFF;

        public TimedBoxRenderData addText(String text) {
            this.text.add(text);
            return this;
        }

        public TimedBoxRenderData setRemovalTimePoint(long removalTimePoint) {
            this.removalTimePoint = removalTimePoint;
            return this;
        }

        public TimedBoxRenderData setPos(BlockPos pos) {
            this.pos = pos;
            return this;
        }

        public TimedBoxRenderData setColor(int hexColor) {
            this.hexColor = hexColor;
            return this;
        }

        private float getRed() {
            return (float)(this.hexColor >> 16 & 0xFF) / 255.0f;
        }

        private float getGreen() {
            return (float)(this.hexColor >> 8 & 0xFF) / 255.0f;
        }

        private float getBlue() {
            return (float)(this.hexColor & 0xFF) / 255.0f;
        }
    }
}

