/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.blocks;

import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public enum FrameType implements StringRepresentable
{
    WOOD("wood", Blocks.f_50705_, Items.f_41905_, Items.f_42647_),
    STONE("stone", Blocks.f_50069_, Items.f_42416_, Items.f_41905_),
    IRON("iron", Blocks.f_50075_, Items.f_42417_, Items.f_42416_),
    GOLD("gold", Blocks.f_50074_, Items.f_42616_, Items.f_42417_),
    EMERALD("emerald", Blocks.f_50268_, Items.f_42415_, Items.f_42616_),
    DIAMOND("diamond", Blocks.f_50090_, null, Items.f_42415_);

    private final String name;
    private final Block material;
    private final RegistryObject<Block> registeredMaterial;
    private final Item upgradeCost;
    private final Item creationCost;

    private FrameType(String nameIn, Block material, Item cost, Item creation) {
        this.name = nameIn;
        this.material = material;
        this.registeredMaterial = null;
        this.upgradeCost = cost;
        this.creationCost = creation;
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public Block getMaterial() {
        return this.material == null && this.registeredMaterial != null ? (Block)this.registeredMaterial.get() : this.material;
    }

    public Item getUpgradeCost() {
        return this.upgradeCost;
    }

    public Item getCreationCost() {
        return this.creationCost;
    }
}

