/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.blocks;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.storageracks.blocks.FrameType;
import com.ldtteam.storageracks.blocks.RackType;
import com.ldtteam.storageracks.blocks.UpgradeableBlock;
import com.ldtteam.storageracks.blocks.WoodType;
import com.ldtteam.storageracks.tileentities.TileEntityRack;
import com.ldtteam.storageracks.utils.InventoryUtils;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RackBlock
extends UpgradeableBlock
implements IMateriallyTexturedBlock {
    public static final EnumProperty<RackType> VARIANT = EnumProperty.m_61587_((String)"variant", RackType.class);
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);
    public final FrameType frameType;
    private final WoodType woodType;

    public RackBlock(WoodType wood, FrameType frame, Item upgradeMaterial) {
        super(upgradeMaterial);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(VARIANT, (Comparable)((Object)RackType.DEFAULT)));
        this.woodType = wood;
        this.frameType = frame;
    }

    @Override
    public Block getNext() {
        if (this.frameType.ordinal() >= FrameType.values().length) {
            return null;
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("storageracks", this.woodType.m_7912_() + "_" + FrameType.values()[this.frameType.ordinal() + 1].m_7912_() + "_rack"));
    }

    public boolean m_7420_(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_213646_(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack stack, boolean check) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof TileEntityRack) {
            IItemHandlerModifiable handler = ((TileEntityRack)tileentity).getInventory();
            InventoryUtils.dropItemHandler((IItemHandler)handler, (Level)worldIn, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        super.m_213646_(state, worldIn, pos, stack, check);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof TileEntityRack) {
            TileEntityRack rack = (TileEntityRack)tileEntity;
            if (!world.f_46443_) {
                rack.checkForUpgrade(state, rack.getSize());
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)rack, buf -> buf.m_130064_(rack.m_58899_()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VARIANT});
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityRack(blockPos, blockState);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        ((TileEntityRack)world.m_7702_(pos)).rotate(direction);
        return super.rotate(state, world, pos, direction);
    }

    public void m_6810_(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (tileEntity instanceof TileEntityRack) {
                TileEntityRack tileEntityRack = (TileEntityRack)tileEntity;
                InventoryUtils.dropItemHandler((IItemHandler)tileEntityRack.getInventory(), worldIn, tileEntityRack.m_58899_().m_123341_(), tileEntityRack.m_58899_().m_123342_(), tileEntityRack.m_58899_().m_123343_());
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean bool) {
        super.m_6807_(state, world, pos, newState, bool);
        if (!world.f_46443_ && state.m_60734_() instanceof RackBlock) {
            ((TileEntityRack)world.m_7702_(pos)).neighborChange();
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean rem = super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        if (!world.f_46443_ && state.m_60734_() instanceof RackBlock) {
            for (Direction direction : Direction.values()) {
                BlockEntity te = world.m_7702_(pos.m_121945_(direction));
                if (!(te instanceof TileEntityRack)) continue;
                ((TileEntityRack)te).neighborChange();
            }
        }
        return rem;
    }

    @NotNull
    public Block getBlock() {
        return this;
    }

    @NotNull
    public Collection<IMateriallyTexturedBlockComponent> getComponents() {
        return Collections.emptyList();
    }
}

