/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.client.BlueprintRenderer;
import com.ldtteam.structurize.client.RenderingCacheKey;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;

public final class BlueprintHandler {
    private static final BlueprintHandler ourInstance = new BlueprintHandler();
    public static final int CACHE_EXPIRE_SECONDS = 45;
    public static final int CACHE_EXPIRE_CHECK_SECONDS = 15;
    private final LoadingCache<RenderingCacheKey, BlueprintRenderer> rendererCache = CacheBuilder.newBuilder().expireAfterAccess(45L, TimeUnit.SECONDS).removalListener(entry -> ((BlueprintRenderer)entry.getValue()).close()).build((CacheLoader)new CacheLoader<RenderingCacheKey, BlueprintRenderer>(){

        public BlueprintRenderer load(RenderingCacheKey key) {
            return BlueprintRenderer.buildRendererForBlueprint(key.blueprint());
        }
    });

    private BlueprintHandler() {
    }

    public static BlueprintHandler getInstance() {
        return ourInstance;
    }

    public void draw(BlueprintPreviewData previewData, BlockPos pos, PoseStack stack, float partialTicks) {
        if (previewData == null || previewData.getBlueprint() == null) {
            Log.getLogger().warn("Trying to draw null blueprint!");
            return;
        }
        Minecraft.m_91087_().m_91307_().m_6180_("struct_render_cache");
        ((BlueprintRenderer)this.rendererCache.getUnchecked((Object)previewData.getRenderKey())).draw(previewData, pos, stack, partialTicks);
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public void cleanCache() {
        this.rendererCache.cleanUp();
    }

    public void clearCache() {
        this.rendererCache.invalidateAll();
    }

    public void drawAtListOfPositions(BlueprintPreviewData previewData, List<BlockPos> points, PoseStack stack, float partialTicks) {
        if (points.isEmpty() || previewData == null || previewData.getBlueprint() == null) {
            return;
        }
        Minecraft.m_91087_().m_91307_().m_6180_("struct_render_multi");
        BlueprintRenderer renderer = (BlueprintRenderer)this.rendererCache.getUnchecked((Object)previewData.getRenderKey());
        for (BlockPos coord : points) {
            renderer.draw(previewData, coord, stack, partialTicks);
        }
        Minecraft.m_91087_().m_91307_().m_7238_();
    }
}

