/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.WallLanternBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlockGeneratorBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.Structure;

public class RoadSignFeature
extends Feature<Config> {
    public static final Codec<WoodType> WOOD_CODEC = ResourceLocation.f_135803_.flatXmap(r -> {
        WoodType w = WoodTypeRegistry.getValue((ResourceLocation)r);
        if (w == null) {
            return DataResult.error((String)("No such wood type: " + r));
        }
        return DataResult.success((Object)w);
    }, t -> DataResult.success((Object)t.id));
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private static final BlockState PATH = Blocks.f_152481_.m_49966_();
    private static final BlockState SANDSTONE_PATH = Blocks.f_50471_.m_49966_();

    public RoadSignFeature(Codec<Config> codec) {
        super(codec);
    }

    public static boolean isNotSolid(LevelAccessor world, BlockPos pos) {
        return !world.m_7433_(pos, state -> state.m_60796_((BlockGetter)world, pos));
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        WorldGenLevel reader = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        Config c = (Config)context.m_159778_();
        pos = pos.m_7495_();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                for (int k = 1; k <= 4; ++k) {
                    if ((Math.abs(i) == 2 || Math.abs(j) == 2) && k == 1) continue;
                    reader.m_7731_(pos.m_7918_(i, k, j), ModRegistry.STRUCTURE_TEMP.get().m_49966_(), 2);
                }
            }
        }
        float humidity = ((Biome)reader.m_204166_(pos).m_203334_()).m_47548_();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                reader.m_7731_(pos.m_7918_(i, -1, j), c.cobble, 2);
                BlockPos pathPos = pos.m_7918_(i, 0, j);
                double dist = pos.m_203198_((double)pathPos.m_123341_(), (double)pathPos.m_123342_(), (double)pathPos.m_123343_()) / (double)5.2f;
                if ((double)rand.m_188501_() < dist - 0.15) continue;
                boolean m = (double)humidity * 0.75 > (double)rand.m_188501_();
                reader.m_7731_(pathPos, m ? c.mossyCobble : c.cobble, 2);
            }
        }
        boolean m = (double)humidity * 0.75 > (double)rand.m_188501_();
        pos = pos.m_7494_();
        reader.m_7731_(pos, m ? c.mossyWall : c.wall, 2);
        pos = pos.m_7494_();
        reader.m_7731_(pos, c.fence, 2);
        pos = pos.m_7494_();
        reader.m_7731_(pos, c.fence, 2);
        reader.m_7731_(pos.m_7494_(), ModRegistry.BLOCK_GENERATOR.get().m_49966_(), 2);
        BlockEntity blockEntity = reader.m_7702_(pos.m_7494_());
        if (blockEntity instanceof BlockGeneratorBlockTile) {
            BlockGeneratorBlockTile t = (BlockGeneratorBlockTile)blockEntity;
            t.setConfig(c);
        }
        return true;
    }

    public static void applyPostProcess(Config c, ServerLevel level, BlockPos generatorPos, List<Pair<BlockPos, Holder<Structure>>> foundVillages) {
        RandomState r = c.randomState;
        BlockState topState = c.trapdoor;
        BlockPos pos = generatorPos.m_6625_(2);
        ArrayList<Pair> villages = new ArrayList<Pair>();
        for (Pair<BlockPos, Holder<Structure>> f : foundVillages) {
            villages.add(Pair.of((Object)((int)Mth.m_14116_((float)((float)((BlockPos)f.getFirst()).m_203198_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())))), (Object)((BlockPos)f.getFirst())));
        }
        boolean inVillage = false;
        if (inVillage) {
            Holder b = level.m_204166_(pos);
            BlockState replace = b.m_203656_(BiomeTags.f_207590_) ? SANDSTONE_PATH : PATH;
            RoadSignFeature.replaceCobbleWithPath(c, (Level)level, pos, replace);
        }
        if (!villages.isEmpty()) {
            BlockPos village2;
            int dist2;
            BlockPos village1;
            int dist1;
            RandomSource rand = level.f_46441_;
            boolean twoSigns = true;
            if (villages.size() == 1 || r.doubleSignChance > rand.m_188501_() && (Integer)((Pair)villages.get(0)).getFirst() > 192) {
                dist1 = (Integer)((Pair)villages.get(0)).getFirst();
                village1 = (BlockPos)((Pair)villages.get(0)).getSecond();
                dist2 = dist1;
                village2 = village1;
                twoSigns = false;
            } else {
                boolean inv = rand.m_188499_();
                dist1 = (Integer)((Pair)villages.get(inv ? 0 : 1)).getFirst();
                village1 = (BlockPos)((Pair)villages.get(inv ? 0 : 1)).getSecond();
                dist2 = (Integer)((Pair)villages.get(inv ? 1 : 0)).getFirst();
                village2 = (BlockPos)((Pair)villages.get(inv ? 1 : 0)).getSecond();
            }
            level.m_46597_(pos, ModRegistry.SIGN_POST.get().m_49966_());
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SignPostBlockTile) {
                Direction backDir;
                float yaw;
                float diff;
                SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
                tile.setHeldBlock(c.fence);
                boolean left = rand.m_188499_();
                SignPostBlockTile.Sign up = tile.getSignUp();
                SignPostBlockTile.Sign down = tile.getSignDown();
                up.setActive(true);
                up.setLeft(left);
                up.setWoodType(c.signWood);
                tile.pointToward(village1, true);
                down.setActive(twoSigns);
                down.setLeft(left);
                down.setWoodType(c.signWood);
                tile.pointToward(village2, false);
                if (Math.abs(up.yaw() - down.yaw()) > 90.0f) {
                    down.toggleDirection();
                    tile.pointToward(village2, false);
                }
                if (CommonConfigs.Building.WAY_SIGN_DISTANCE_TEXT.get().booleanValue()) {
                    tile.getTextHolder().setLine(0, RoadSignFeature.getSignText(dist1));
                    if (twoSigns) {
                        tile.getTextHolder().setLine(1, RoadSignFeature.getSignText(dist2));
                    }
                }
                Direction sideDir = (diff = Mth.m_14118_((float)(yaw = Mth.m_14177_((float)(90.0f + 360.0f * MthUtils.averageAngles((Float[])new Float[]{Float.valueOf((180.0f - up.yaw()) / 360.0f), Float.valueOf((180.0f - down.yaw()) / 360.0f)})))), (float)(backDir = Direction.m_122364_((double)yaw)).m_122435_())) < 0.0f ? backDir.m_122427_() : backDir.m_122428_();
                ArrayList<Direction> lampDir = new ArrayList<Direction>();
                lampDir.add(backDir.m_122424_());
                lampDir.add(backDir.m_122424_());
                lampDir.add(backDir.m_122424_());
                if (Math.abs(diff) > 30.0f) {
                    lampDir.add(sideDir.m_122424_());
                }
                boolean hasGroundLantern = false;
                boolean hasFirefly = false;
                if (rand.m_188501_() < r.stoneChance && Mth.m_14145_((float)(tile.getPointingYaw(true) + 180.0f), (float)yaw) > 70.0f) {
                    BlockPos stonePos = pos.m_7495_().m_121955_(backDir.m_122436_());
                    if (rand.m_188499_()) {
                        level.m_7731_(stonePos, c.stoneSlab, 2);
                    } else {
                        level.m_7731_(stonePos, (BlockState)c.stoneStairs.m_61124_((Property)StairBlock.f_56841_, (Comparable)sideDir), 2);
                    }
                    stonePos = stonePos.m_121955_(sideDir.m_122436_());
                    level.m_7731_(stonePos, c.stone, 2);
                    if (rand.m_188501_() < r.stoneLanternChance) {
                        level.m_7731_(stonePos.m_7494_(), hasFirefly ? c.lanternDown : c.lanternDown, 3);
                        hasGroundLantern = true;
                    }
                    if (!RoadSignFeature.isNotSolid((LevelAccessor)level, (stonePos = stonePos.m_121955_(sideDir.m_122436_())).m_7495_())) {
                        if (rand.m_188499_()) {
                            level.m_7731_(stonePos, c.stoneSlab, 2);
                        } else {
                            level.m_7731_(stonePos, (BlockState)c.stoneStairs.m_61124_((Property)StairBlock.f_56841_, (Comparable)sideDir.m_122424_()), 2);
                        }
                    }
                }
                if (!hasGroundLantern) {
                    boolean doubleSided;
                    BlockState light;
                    pos = pos.m_6630_(2);
                    BlockState blockState = light = hasFirefly ? c.lanternUp : c.lanternUp;
                    if (rand.m_188501_() < r.candleHolderChance) {
                        light = (BlockState)((BlockState)c.candleHolder.m_61124_((Property)CandleHolderBlock.LIT, (Comparable)Boolean.valueOf(true))).m_61124_(CandleHolderBlock.FACE, (Comparable)AttachFace.CEILING);
                    }
                    Direction dir = (Direction)lampDir.get(rand.m_188503_(lampDir.size()));
                    boolean bl = doubleSided = r.doubleLanternChance > rand.m_188501_();
                    if (doubleSided) {
                        dir = dir.m_122427_();
                    }
                    if (rand.m_188501_() < r.wallLanternChance) {
                        topState = rand.m_188501_() < r.trapdoorChance ? c.trapdoor : AIR;
                        WallLanternBlock wl = ModRegistry.WALL_LANTERN.get();
                        wl.placeOn(c.lanternDown, pos.m_7495_(), dir, (Level)level);
                        if (doubleSided) {
                            wl.placeOn(c.lanternDown, pos.m_7495_(), dir.m_122424_(), (Level)level);
                        }
                    } else {
                        boolean isTrapdoor;
                        boolean bl2 = isTrapdoor = r.trapdoorChance > rand.m_188501_();
                        if (!isTrapdoor) {
                            topState = c.fence;
                        }
                        if (doubleSided) {
                            BlockPos backPos = pos.m_121945_(dir.m_122424_());
                            level.m_7731_(backPos, isTrapdoor ? c.trapdoor : c.fence, 2);
                            if (r.logChance > rand.m_188501_()) {
                                topState = isTrapdoor ? c.slab : c.log;
                            }
                            level.m_7731_(backPos.m_7495_(), light, 3);
                        }
                        pos = pos.m_121945_(dir);
                        BlockState frontState = isTrapdoor ? c.trapdoor : c.fence;
                        level.m_7731_(pos, frontState, 2);
                        level.m_7731_(pos.m_7495_(), light, 3);
                    }
                }
            }
        } else {
            ItemStack book = new ItemStack((ItemLike)Items.f_42614_);
            CompoundTag com = new CompoundTag();
            ListTag listTag = new ListTag();
            listTag.add((Object)StringTag.m_129297_((String)"nothing here but monsters\n\n\n"));
            com.m_128365_("pages", (Tag)listTag);
            book.m_41751_(com);
            BlockPos belowPos = generatorPos.m_6625_(2);
            level.m_46597_(belowPos, (BlockState)((BlockState)ModRegistry.NOTICE_BOARD.get().m_49966_().m_61124_((Property)NoticeBoardBlock.HAS_BOOK, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NoticeBoardBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(level.f_46441_)));
            BlockEntity blockEntity = level.m_7702_(belowPos);
            if (blockEntity instanceof NoticeBoardBlockTile) {
                NoticeBoardBlockTile board = (NoticeBoardBlockTile)blockEntity;
                board.setDisplayedItem(book);
            }
        }
        level.m_7731_(generatorPos, topState, 3);
    }

    private static Component getSignText(int d) {
        int s = d < 100 ? 10 : (d < 2000 ? 100 : 1000);
        return Component.m_237110_((String)"message.supplementaries.road_sign", (Object[])new Object[]{(d + s / 2) / s * s});
    }

    private static void replaceCobbleWithPath(Config c, Level world, BlockPos pos, BlockState path) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                BlockPos pathPos;
                BlockState state;
                if (Math.abs(i) == 2 && Math.abs(j) == 2 || i == 0 && j == 0 || !(state = world.m_8055_(pathPos = pos.m_7918_(i, -2, j))).m_60713_(c.cobble.m_60734_()) && !state.m_60713_(c.mossyCobble.m_60734_())) continue;
                world.m_7731_(pathPos, path, 2);
            }
        }
    }

    public record Config(RandomState randomState, WoodType postWood, WoodType signWood, BlockState fence, BlockState trapdoor, BlockState slab, BlockState log, BlockState cobble, BlockState mossyCobble, BlockState wall, BlockState mossyWall, BlockState lanternUp, BlockState lanternDown, BlockState candleHolder, BlockState stone, BlockState stoneSlab, BlockState stoneStairs, String invalidMessage) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RandomState.CODEC.fieldOf("random_state").forGetter(Config::randomState), (App)WOOD_CODEC.fieldOf("post_wood").forGetter(Config::postWood), (App)WOOD_CODEC.fieldOf("sign_wood").forGetter(Config::signWood), (App)BlockState.f_61039_.fieldOf("cobble").forGetter(Config::cobble), (App)BlockState.f_61039_.fieldOf("mossy_cobble").forGetter(Config::mossyCobble), (App)BlockState.f_61039_.fieldOf("wall").forGetter(Config::wall), (App)BlockState.f_61039_.fieldOf("mossy_wall").forGetter(Config::mossyWall), (App)BlockState.f_61039_.fieldOf("lantern_up").forGetter(Config::lanternUp), (App)BlockState.f_61039_.fieldOf("lantern_down").forGetter(Config::lanternDown), (App)BlockState.f_61039_.fieldOf("candle_holder").forGetter(Config::candleHolder), (App)BlockState.f_61039_.fieldOf("stone").forGetter(Config::stone), (App)BlockState.f_61039_.fieldOf("stone_slab").forGetter(Config::stoneSlab), (App)BlockState.f_61039_.fieldOf("stone_stairs").forGetter(Config::stoneStairs)).apply((Applicative)instance, Config::of)).comapFlatMap(s -> {
            if (s.invalidMessage != null) {
                return DataResult.error((String)s.invalidMessage);
            }
            return DataResult.success((Object)s);
        }, Function.identity());

        private static Config of(RandomState randomState, WoodType postWood, WoodType signWood, BlockState cobble, BlockState mossyCobble, BlockState wall, BlockState mossyWall, BlockState lanternUp, BlockState lanternDown, BlockState candleHolder, BlockState stone, BlockState stoneSlab, BlockState stoneStairs) {
            Block log;
            Block slab;
            Block trapdoor;
            Object message = null;
            Block fence = postWood.getBlockOfThis("fence");
            if (fence == null) {
                message = "Post wood type does not have a fence";
                fence = Blocks.f_50016_;
            }
            if ((trapdoor = postWood.getBlockOfThis("trapdoor")) == null) {
                message = "Post wood type does not have a trapdoor";
                trapdoor = Blocks.f_50016_;
            }
            if ((slab = postWood.getBlockOfThis("slab")) == null) {
                message = "Post wood type does not have a slab";
                slab = Blocks.f_50016_;
            }
            if ((log = postWood.getBlockOfThis("stripped_log")) == null) {
                message = "Post wood type does not have a valid stripped log";
                log = Blocks.f_50016_;
            }
            if (!(stoneSlab.m_60734_() instanceof SlabBlock)) {
                message = "Stone slab must be a SlabBlock, was " + stoneSlab;
            }
            if (!(stoneStairs.m_60734_() instanceof StairBlock)) {
                message = "Stone slab must be a StairBlock, was " + stoneStairs;
            }
            if (!candleHolder.m_61138_(CandleHolderBlock.FACE) || !candleHolder.m_61138_((Property)CandleHolderBlock.LIT)) {
                message = "Candle holder block has to have a face and lit property";
            }
            return new Config(randomState, postWood, signWood, fence.m_49966_(), trapdoor.m_49966_(), slab.m_49966_(), log.m_49966_(), cobble, mossyCobble, wall, mossyWall, lanternUp, lanternDown, candleHolder, stone, stoneSlab, stoneStairs, (String)message);
        }
    }

    private record RandomState(float doubleSignChance, float stoneChance, float stoneLanternChance, float candleHolderChance, float wallLanternChance, float doubleLanternChance, float trapdoorChance, float logChance) {
        public static final Codec<RandomState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("double_sign_chance").forGetter(RandomState::doubleSignChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stone_chance").forGetter(RandomState::stoneChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stone_lantern_chance").forGetter(RandomState::stoneLanternChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("candle_holder_chance").forGetter(RandomState::candleHolderChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("wall_lantern_chance").forGetter(RandomState::wallLanternChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("double_lantern_chance").forGetter(RandomState::doubleLanternChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trapdoor_chance").forGetter(RandomState::trapdoorChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("log_chance").forGetter(RandomState::logChance)).apply((Applicative)instance, RandomState::new));
    }
}

