/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import se.mickelus.mutil.util.RotationHelper;
import se.mickelus.tetra.blocks.rack.RackBlock;
import se.mickelus.tetra.blocks.scroll.QuadRenderer;
import se.mickelus.tetra.blocks.scroll.ScrollBlock;
import se.mickelus.tetra.blocks.scroll.ScrollData;
import se.mickelus.tetra.blocks.scroll.ScrollTile;

@ParametersAreNonnullByDefault
public class ScrollRenderer
implements BlockEntityRenderer<ScrollTile> {
    public static final Material material = new Material(TextureAtlas.f_118259_, new ResourceLocation("tetra", "blocks/scroll"));
    private static final int availableGlyphs = 16;
    private static final int availableMaterials = 3;
    public static ModelLayerLocation layer = new ModelLayerLocation(new ResourceLocation("tetra", "blocks/scroll"), "main");
    private final ModelPart[] rolledModel;
    private final ModelPart ribbonModel;
    private final ModelPart[] wallModel;
    private final QuadRenderer[][] wallGlyphs;
    private final ModelPart[] openModel;
    private final QuadRenderer[][] openGlyphs;
    private final BlockEntityRendererProvider.Context context;

    public ScrollRenderer(BlockEntityRendererProvider.Context context) {
        int i;
        this.context = context;
        ModelPart model = context.m_173582_(layer);
        this.rolledModel = new ModelPart[3];
        this.wallModel = new ModelPart[3];
        this.openModel = new ModelPart[3];
        for (i = 0; i < 3; ++i) {
            this.rolledModel[i] = model.m_171324_("rolled" + i);
            this.wallModel[i] = model.m_171324_("wall" + i);
            this.openModel[i] = model.m_171324_("open" + i);
        }
        this.ribbonModel = model.m_171324_("ribbon");
        this.wallGlyphs = new QuadRenderer[2][];
        for (i = 0; i < this.wallGlyphs.length; ++i) {
            this.wallGlyphs[i] = new QuadRenderer[16];
        }
        for (i = 0; i < 16; ++i) {
            this.wallGlyphs[0][i] = new QuadRenderer(8.0f, 1.0f, 0.075f, 7.0f, 13.0f, i * 7, 51.0f, 128.0f, 64.0f, true, Direction.SOUTH);
            this.wallGlyphs[1][i] = new QuadRenderer(1.0f, 1.0f, 0.075f, 7.0f, 13.0f, i * 7, 51.0f, 128.0f, 64.0f, false, Direction.SOUTH);
        }
        this.openGlyphs = new QuadRenderer[4][];
        for (i = 0; i < this.openGlyphs.length; ++i) {
            this.openGlyphs[i] = new QuadRenderer[16];
        }
        for (i = 0; i < 16; ++i) {
            this.openGlyphs[0][i] = new QuadRenderer(1.0f, 0.075f, 2.0f, 7.0f, 6.0f, i * 7, 58.0f, 128.0f, 64.0f, true, Direction.UP);
            this.openGlyphs[1][i] = new QuadRenderer(8.0f, 0.075f, 2.0f, 7.0f, 6.0f, i * 7, 58.0f, 128.0f, 64.0f, false, Direction.UP);
            this.openGlyphs[2][i] = new QuadRenderer(1.0f, 0.075f, 2.0f, 7.0f, 6.0f, i * 7, 58.0f, 128.0f, 64.0f, true, Direction.UP);
            this.openGlyphs[3][i] = new QuadRenderer(8.0f, 0.075f, 2.0f, 7.0f, 6.0f, i * 7, 58.0f, 128.0f, 64.0f, false, Direction.UP);
        }
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        for (int i = 0; i < 3; ++i) {
            parts.m_171599_("rolled" + i, CubeListBuilder.m_171558_().m_171514_(34 * i, 4).m_171481_(1.0f, 0.0f, 7.0f, 14.0f, 3.0f, 3.0f), PartPose.f_171404_);
            parts.m_171599_("wall" + i, CubeListBuilder.m_171558_().m_171514_(34 * i, 0).m_171481_(1.0f, 14.0f, 0.0f, 14.0f, 2.0f, 2.0f).m_171514_(34 * i, 10).m_171481_(1.0f, 1.0f, 0.05f, 14.0f, 13.0f, 0.0f), PartPose.f_171404_);
            parts.m_171599_("open" + i, CubeListBuilder.m_171558_().m_171514_(34 * i, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 2.0f, 2.0f).m_171481_(1.0f, 0.0f, 14.0f, 14.0f, 2.0f, 2.0f).m_171514_(34 * i - 12, 10).m_171481_(1.0f, 0.05f, 2.0f, 14.0f, 0.0f, 12.0f), PartPose.f_171404_);
        }
        parts.m_171599_("ribbon", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(7.0f, 0.0f, 7.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.001f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void render(ScrollTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        VertexConsumer vertexBuilder = material.m_119194_(buffer, rl -> RenderType.m_110452_((ResourceLocation)rl));
        ScrollData[] scrolls = tile.getScrolls();
        ScrollBlock.Arrangement arrangement = ((ScrollBlock)tile.m_58900_().m_60734_()).getArrangement();
        Direction direction = (Direction)tile.m_58900_().m_61143_((Property)RackBlock.facingProp);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        matrixStack.m_85845_(direction.m_122406_());
        matrixStack.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
        matrixStack.m_85837_(-0.5, 0.0, -0.5);
        switch (arrangement) {
            case rolled: {
                this.renderRolled(scrolls, matrixStack, combinedLight, combinedOverlay, vertexBuilder);
                break;
            }
            case wall: {
                this.renderWall(scrolls, matrixStack, combinedLight, combinedOverlay, vertexBuilder);
                break;
            }
            case open: {
                this.renderOpen(scrolls, matrixStack, combinedLight, combinedOverlay, vertexBuilder);
            }
        }
        matrixStack.m_85849_();
        if (this.shouldDrawLabel(scrolls, tile.m_58899_())) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.0, 0.5);
            if (arrangement == ScrollBlock.Arrangement.wall) {
                matrixStack.m_85845_(direction.m_122424_().m_122406_());
                matrixStack.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
                matrixStack.m_85837_(0.0, 0.55, 0.4);
                this.drawLabel(scrolls[0], matrixStack, buffer, combinedLight);
            } else if (arrangement == ScrollBlock.Arrangement.open) {
                double angle = RotationHelper.getHorizontalAngle((Vec3)Minecraft.m_91087_().m_91288_().m_20299_(partialTicks), (Vec3)Vec3.m_82512_((Vec3i)tile.m_58899_()));
                Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
                rotation.m_80148_(Vector3f.f_122225_.m_122240_((float)(angle / Math.PI * 180.0 + 180.0)));
                matrixStack.m_85845_(rotation);
                matrixStack.m_85837_(0.0, (double)0.4f, 0.4);
                this.drawLabel(scrolls[0], matrixStack, buffer, combinedLight);
            }
            matrixStack.m_85849_();
        }
    }

    private void renderRolled(ScrollData[] scrolls, PoseStack matrixStack, int combinedLight, int combinedOverlay, VertexConsumer vertexBuilder) {
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(90.0f));
        matrixStack.m_85837_(-0.5, 0.0, -0.5);
        int offset = Math.min(scrolls.length, 3) - 1;
        if (offset > 0) {
            matrixStack.m_85837_(0.0, 0.0, (double)offset * -0.125);
        }
        for (int i = 0; i < scrolls.length; ++i) {
            int mat = this.getMaterial(scrolls, i);
            float red = (float)FastColor.ARGB32.m_13665_((int)scrolls[i].ribbon) / 255.0f;
            float green = (float)FastColor.ARGB32.m_13667_((int)scrolls[i].ribbon) / 255.0f;
            float blue = (float)FastColor.ARGB32.m_13669_((int)scrolls[i].ribbon) / 255.0f;
            this.rolledModel[mat].m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
            this.ribbonModel.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, red, green, blue, 1.0f);
            matrixStack.m_85837_(0.0, 0.0, 0.25);
            if (i == 2) {
                matrixStack.m_85837_(0.0, 0.1875, -0.625);
                continue;
            }
            if (i != 4) continue;
            matrixStack.m_85837_(0.0, 0.1875, -0.375);
        }
    }

    private void renderWall(ScrollData[] scrolls, PoseStack matrixStack, int combinedLight, int combinedOverlay, VertexConsumer vertexBuilder) {
        int mat = this.getMaterial(scrolls, 0);
        int color = this.getGlyphColor(mat);
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        this.wallModel[mat].m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        for (int i = 0; i < this.wallGlyphs.length; ++i) {
            int glyph = this.getGlyph(scrolls, i);
            this.wallGlyphs[i][glyph].render(matrixStack, vertexBuilder, combinedLight, combinedOverlay, red, green, blue, 1.0f);
        }
    }

    private void renderOpen(ScrollData[] scrolls, PoseStack matrixStack, int combinedLight, int combinedOverlay, VertexConsumer vertexBuilder) {
        int mat = this.getMaterial(scrolls, 0);
        int color = this.getGlyphColor(mat);
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(90.0f));
        matrixStack.m_85837_(-0.5, 0.0, -0.5);
        this.openModel[mat].m_104301_(matrixStack, vertexBuilder, combinedLight, combinedOverlay);
        for (int i = 0; i < this.openGlyphs.length; ++i) {
            if (i == 2) {
                matrixStack.m_85837_(0.5, 0.0, 0.5);
                matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
                matrixStack.m_85837_(-0.5, 0.0, -0.5);
            }
            int glyph = this.getGlyph(scrolls, i);
            this.openGlyphs[i][glyph].render(matrixStack, vertexBuilder, combinedLight, combinedOverlay, red, green, blue, 1.0f);
        }
    }

    private int getGlyphColor(int material) {
        switch (material) {
            case 2: {
                return 12558634;
            }
            case 1: {
                return 9411532;
            }
        }
        return 6709063;
    }

    private int getGlyph(ScrollData[] data, int index) {
        if (data.length > 0) {
            if (data[0].glyphs.size() > index) {
                return Mth.m_14045_((int)data[0].glyphs.get(index), (int)0, (int)16);
            }
            if (data[0].glyphs.size() > 0) {
                return Mth.m_14045_((int)data[0].glyphs.get(0), (int)0, (int)16);
            }
        }
        return 0;
    }

    private int getMaterial(ScrollData[] data, int index) {
        if (data.length > index) {
            return Mth.m_14045_((int)data[index].material, (int)0, (int)2);
        }
        return 0;
    }

    private boolean shouldDrawLabel(ScrollData[] scrolls, BlockPos pos) {
        HitResult mouseover = Minecraft.m_91087_().f_91077_;
        return scrolls != null && scrolls.length > 0 && mouseover != null && mouseover.m_6662_() == HitResult.Type.BLOCK && pos.equals((Object)((BlockHitResult)mouseover).m_82425_());
    }

    private void drawLabel(ScrollData scroll, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        String label = I18n.m_118938_((String)("item.tetra.scroll." + scroll.key + ".name"), (Object[])new Object[0]);
        matrixStack.m_85841_(-0.0125f, -0.0125f, 0.0125f);
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        Font fontrenderer = this.context.m_173586_();
        float x = (float)(-fontrenderer.m_92895_(label)) / 2.0f;
        fontrenderer.m_92822_(label, x + 1.0f, 0.0f, 0, false, matrix4f, buffer, false, 0, packedLight, false);
        fontrenderer.m_92822_(label, x - 1.0f, 0.0f, 0, false, matrix4f, buffer, false, 0, packedLight, false);
        fontrenderer.m_92822_(label, x, -1.0f, 0, false, matrix4f, buffer, false, 0, packedLight, false);
        fontrenderer.m_92822_(label, x, 1.0f, 0, false, matrix4f, buffer, false, 0, packedLight, false);
        matrixStack.m_85837_(0.0, 0.0, (double)-0.0125f);
        fontrenderer.m_92822_(label, x, 0.0f, -1, false, matrix4f, buffer, false, 0, packedLight, false);
    }
}

