/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.EchoHelper;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.potion.SmallAbsorbPotionEffect;
import se.mickelus.tetra.effect.potion.SmallHealthPotionEffect;
import se.mickelus.tetra.effect.potion.SmallStrengthPotionEffect;
import se.mickelus.tetra.effect.potion.SteeledPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.potion.UnwaveringPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@ParametersAreNonnullByDefault
public class ReapEffect
extends ChargedAbilityEffect {
    public static final ReapEffect instance = new ReapEffect();

    ReapEffect() {
        super(20, 0.7f, 40, 8.0, ItemEffect.reap, ChargedAbilityEffect.TargetRequirement.none, UseAnim.SPEAR, "raised");
    }

    @Override
    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, @Nullable LivingEntity target, @Nullable BlockPos targetPos, @Nullable Vec3 hitVec, int chargedTicks) {
        if (!attacker.f_19853_.f_46443_) {
            int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
            double momentumEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum);
            int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
            int overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend);
            boolean overextend = overextendLevel > 0 && !attacker.m_36324_().m_38721_();
            ServerPlayer serverPlayer = (ServerPlayer)attacker;
            int cooldown = this.getCooldown(item, itemStack);
            double damageMultiplier = (double)EffectHelper.getEffectLevel(itemStack, ItemEffect.reap) / 100.0;
            double range = EffectHelper.getEffectEfficiency(itemStack, ItemEffect.reap);
            if (overchargeBonus > 0) {
                damageMultiplier += (double)(overchargeBonus * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0;
                range += (double)overchargeBonus * 0.5;
            }
            int comboLevel = item.getEffectLevel(itemStack, ItemEffect.abilityCombo);
            int comboPoints = ComboPoints.get((Entity)attacker);
            if (comboLevel > 0) {
                damageMultiplier += (double)(comboLevel * comboPoints) / 100.0;
            }
            AtomicInteger kills = new AtomicInteger();
            AtomicInteger revengeKills = new AtomicInteger();
            AtomicInteger hits = new AtomicInteger();
            Vec3 targetVec = target != null ? hitVec : Vec3.m_82498_((float)attacker.m_146909_(), (float)attacker.m_146908_()).m_82541_().m_82490_(range).m_82549_(attacker.m_20299_(0.0f));
            AABB aoe = new AABB(targetVec, targetVec).m_82377_(range, 1.0, range);
            this.hitEntities(serverPlayer, item, itemStack, aoe, damageMultiplier, revengeLevel, overextend, overextendLevel, momentumEfficiency, kills, revengeKills, hits);
            this.applyBuff(attacker, kills.get(), hits.get(), hand, item, itemStack, chargedTicks, comboPoints, revengeKills.get());
            attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12317_, attacker.m_5720_(), 1.0f, 1.0f);
            item.tickProgression((LivingEntity)attacker, itemStack, 1 + kills.get());
            attacker.m_36346_();
            attacker.m_36399_(overextendLevel > 0 ? 6.0f : 1.0f);
            double exhilarationEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityExhilaration);
            if (exhilarationEfficiency > 0.0 && kills.get() > 0) {
                cooldown = (int)((double)cooldown * (1.0 - exhilarationEfficiency / 100.0));
            }
            attacker.m_36335_().m_41524_((Item)item, cooldown);
            int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
            if (echoLevel > 0) {
                this.echoReap(serverPlayer, hand, item, itemStack, chargedTicks, aoe, damageMultiplier, revengeLevel, overextend, overextendLevel, momentumEfficiency, comboPoints);
            }
        }
        attacker.m_21011_(hand, false);
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    private void hitEntities(ServerPlayer player, ItemModularHandheld item, ItemStack itemStack, AABB aoe, double damageMultiplier, int revengeLevel, boolean overextend, int overextendLevel, double momentumEfficiency, AtomicInteger kills, AtomicInteger revengeKills, AtomicInteger hits) {
        LinkedList momentumTargets = new LinkedList();
        player.f_19853_.m_45976_(LivingEntity.class, aoe).stream().filter(entity -> entity != player).filter(entity -> !player.m_7307_((Entity)entity)).forEach(entity -> {
            AbilityUseResult result;
            boolean canRevenge;
            double individualDamageMultiplier = damageMultiplier;
            boolean bl = canRevenge = revengeLevel > 0 && RevengeTracker.canRevenge((Entity)player, (Entity)entity);
            if (canRevenge) {
                individualDamageMultiplier += (double)revengeLevel / 100.0;
            }
            if (overextend && entity.m_21223_() / entity.m_21233_() >= (float)overextendLevel / 100.0f) {
                individualDamageMultiplier *= 2.0;
            }
            if ((result = item.hitEntity(itemStack, (Player)player, (LivingEntity)entity, individualDamageMultiplier, 0.5f, 0.2f)) != AbilityUseResult.fail) {
                if (!entity.m_6084_()) {
                    kills.incrementAndGet();
                    if (canRevenge) {
                        revengeKills.incrementAndGet();
                        RevengeTracker.removeEnemySynced(player, (Entity)entity);
                    }
                } else if (momentumEfficiency > 0.0) {
                    momentumTargets.add(entity);
                }
                hits.incrementAndGet();
            }
            if (result == AbilityUseResult.crit) {
                player.m_20193_().m_5594_((Player)player, entity.m_20183_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.3f);
            }
        });
        if (momentumEfficiency > 0.0 && kills.get() > 0) {
            int stunDuration = (int)(momentumEfficiency * (double)kills.get() * 20.0);
            momentumTargets.forEach(entity -> entity.m_7292_(new MobEffectInstance((MobEffect)StunPotionEffect.instance, stunDuration, 0, false, false)));
        }
    }

    private void applyBuff(Player attacker, int kills, int hits, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, int chargedTicks, int comboPoints, int revengeKills) {
        int overextendLevel;
        int defensiveLevel = item.getEffectLevel(itemStack, ItemEffect.abilityDefensive);
        if (defensiveLevel > 0) {
            if (hand == InteractionHand.OFF_HAND) {
                if (hits > 0) {
                    duration = defensiveLevel * (1 + kills * 2);
                    attacker.m_7292_(new MobEffectInstance((MobEffect)SteeledPotionEffect.instance, duration, hits - 1, false, true));
                }
            } else if (kills > 0) {
                duration = (int)(item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) * 20.0f);
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, kills - 1, false, true));
            }
        }
        if (kills > 0) {
            int echoLevel;
            int amp;
            int exhilarationLevel;
            double duration;
            double comboEfficiency;
            int momentumLevel;
            int speedLevel;
            int overchargeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge);
            if (overchargeLevel > 0) {
                double duration2 = 600.0;
                attacker.m_7292_(new MobEffectInstance((MobEffect)SmallStrengthPotionEffect.instance, (int)(duration2 *= (double)(1.0f + (float)this.getOverchargeBonus(item, itemStack, chargedTicks) * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge))), kills - 1, false, true));
            }
            if ((speedLevel = item.getEffectLevel(itemStack, ItemEffect.abilitySpeed)) > 0) {
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19598_, (int)(item.getEffectEfficiency(itemStack, ItemEffect.abilitySpeed) * 20.0f), kills - 1, false, true));
            }
            if ((momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0) {
                attacker.m_7292_(new MobEffectInstance((MobEffect)UnwaveringPotionEffect.instance, momentumLevel * kills * 20, 0, false, true));
            }
            if ((comboEfficiency = (double)item.getEffectEfficiency(itemStack, ItemEffect.abilityCombo)) > 0.0) {
                duration = 300.0;
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19598_, (int)(duration += comboEfficiency * (double)comboPoints * 20.0), kills - 1, false, true));
            }
            if (revengeKills > 0) {
                duration = 400.0;
                attacker.m_7292_(new MobEffectInstance((MobEffect)SmallStrengthPotionEffect.instance, (int)(duration += (double)(item.getEffectEfficiency(itemStack, ItemEffect.abilityRevenge) * (float)revengeKills * 20.0f)), kills - 1, false, true));
            }
            if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0) {
                int currentAmplifier = Optional.ofNullable(attacker.m_21124_((MobEffect)SmallAbsorbPotionEffect.instance)).map(MobEffectInstance::m_19564_).orElse(-1);
                amp = Math.max(currentAmplifier, kills - 1);
                attacker.m_7292_(new MobEffectInstance((MobEffect)SmallAbsorbPotionEffect.instance, 600, amp, false, true));
            }
            if ((echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho)) > 0) {
                amp = Optional.ofNullable(attacker.m_21124_((MobEffect)SmallStrengthPotionEffect.instance)).map(MobEffectInstance::m_19564_).orElse(-1);
                amp = Math.min(echoLevel, amp + kills);
                attacker.m_7292_(new MobEffectInstance((MobEffect)SmallStrengthPotionEffect.instance, 600, amp, false, true));
            }
        }
        if ((overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0) {
            if (kills > 0) {
                attacker.m_7292_(new MobEffectInstance((MobEffect)SmallHealthPotionEffect.instance, 900, kills - 1, false, true));
            } else if (!attacker.m_36324_().m_38721_()) {
                attacker.m_7292_(new MobEffectInstance((MobEffect)ExhaustedPotionEffect.instance, 400, 4, false, true));
                attacker.m_36399_(12.0f);
            }
        }
    }

    private void echoReap(ServerPlayer player, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, int chargedTicks, AABB aoe, double damageMultiplier, int revengeLevel, boolean overextend, int overextendLevel, double momentumEfficiency, int comboPoints) {
        EchoHelper.echo((Player)player, 60, () -> {
            AtomicInteger kills = new AtomicInteger();
            AtomicInteger revengeKills = new AtomicInteger();
            AtomicInteger hits = new AtomicInteger();
            this.hitEntities(player, item, itemStack, aoe, damageMultiplier, revengeLevel, overextend, overextendLevel, momentumEfficiency, kills, revengeKills, hits);
            this.applyBuff((Player)player, kills.get(), hits.get(), hand, item, itemStack, chargedTicks, comboPoints, revengeKills.get());
            player.m_36346_();
        });
    }
}

