/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.tetra.data.deserializer.ItemPredicateDeserializer;

@ParametersAreNonnullByDefault
public class OutcomeMaterial {
    private static final JsonArray emptyArray = new JsonArray();
    public int count = 1;
    protected Collection<ItemStack> itemStacks = Collections.emptyList();
    protected TagKey<Item> tagLocation;
    private ItemPredicate predicate;

    public OutcomeMaterial offsetCount(float multiplier, int offset) {
        OutcomeMaterial result = new OutcomeMaterial();
        result.count = Math.round((float)this.count * multiplier) + offset;
        result.itemStacks = this.itemStacks.stream().map(ItemStack::m_41777_).peek(result::setCount).collect(Collectors.toList());
        result.tagLocation = this.tagLocation;
        result.predicate = this.predicate;
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component[] getDisplayNames() {
        if (this.getPredicate() == null) {
            return new Component[]{Component.m_237113_((String)"Unknown material")};
        }
        if (this.itemStacks != null) {
            return (Component[])this.itemStacks.stream().map(ItemStack::m_41786_).toArray(Component[]::new);
        }
        if (this.tagLocation != null) {
            return (Component[])ForgeRegistries.ITEMS.tags().getTag(this.tagLocation).stream().map(item -> item.m_7626_(item.m_7968_())).toArray(Component[]::new);
        }
        return new Component[]{Component.m_237113_((String)"Unknown material")};
    }

    public ItemStack[] getApplicableItemStacks() {
        if (this.getPredicate() == null) {
            return new ItemStack[0];
        }
        if (this.itemStacks != null && !this.itemStacks.isEmpty()) {
            return (ItemStack[])this.itemStacks.toArray(ItemStack[]::new);
        }
        if (this.tagLocation != null) {
            return (ItemStack[])ForgeRegistries.ITEMS.tags().getTag(this.tagLocation).stream().map(Item::m_7968_).map(this::setCount).toArray(ItemStack[]::new);
        }
        return new ItemStack[0];
    }

    @Nullable
    public ItemPredicate getPredicate() {
        return this.predicate;
    }

    private ItemStack setCount(ItemStack itemStack) {
        itemStack.m_41764_(this.count);
        return itemStack;
    }

    public boolean isTagged() {
        return this.tagLocation != null;
    }

    public boolean isValid() {
        return this.predicate != null;
    }

    public static class Deserializer
    implements JsonDeserializer<OutcomeMaterial> {
        public OutcomeMaterial deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) {
            OutcomeMaterial material = new OutcomeMaterial();
            if (element != null && !element.isJsonNull()) {
                JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)element, (String)"material");
                material.count = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"count", (int)1);
                if (jsonObject.has("items")) {
                    try {
                        material.itemStacks = StreamSupport.stream(GsonHelper.m_13832_((JsonObject)jsonObject, (String)"items", (JsonArray)emptyArray).spliterator(), false).map(jsonElement -> GsonHelper.m_13805_((JsonElement)jsonElement, (String)"item")).map(ResourceLocation::new).map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_6612_(arg_0)).filter(Optional::isPresent).map(Optional::get).map(item -> new ItemStack((ItemLike)item, material.count)).collect(Collectors.toList());
                    }
                    catch (JsonSyntaxException e) {
                        material.itemStacks = Collections.emptyList();
                    }
                    if (!material.itemStacks.isEmpty() && jsonObject.has("nbt")) {
                        try {
                            CompoundTag compoundnbt = TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)jsonObject.get("nbt"), (String)"nbt"));
                            material.itemStacks.forEach(itemStack -> itemStack.m_41751_(compoundnbt));
                        }
                        catch (CommandSyntaxException exception) {
                            throw new JsonSyntaxException("Encountered invalid nbt tag when parsing material: " + exception.getMessage());
                        }
                    }
                } else if (jsonObject.has("tag")) {
                    material.tagLocation = ItemTags.create((ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag")));
                }
                if (!jsonObject.has("type") && jsonObject.has("tag")) {
                    material.predicate = this.deserializeTagPredicate(jsonObject);
                } else {
                    JsonObject copy = jsonObject.deepCopy();
                    copy.remove("count");
                    material.predicate = ItemPredicateDeserializer.deserialize((JsonElement)copy);
                }
            }
            return material;
        }

        private ItemPredicate deserializeTagPredicate(JsonObject jsonObject) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
            TagKey tagKey = ItemTags.create((ResourceLocation)resourceLocation);
            MinMaxBounds.Ints durability = MinMaxBounds.Ints.m_55373_((JsonElement)jsonObject.get("durability"));
            EnchantmentPredicate[] enchantments = EnchantmentPredicate.m_30480_((JsonElement)jsonObject.get("enchantments"));
            EnchantmentPredicate[] storedEnchantments = EnchantmentPredicate.m_30480_((JsonElement)jsonObject.get("stored_enchantments"));
            NbtPredicate nbt = NbtPredicate.m_57481_((JsonElement)jsonObject.get("nbt"));
            return new ItemPredicate(tagKey, null, MinMaxBounds.Ints.f_55364_, durability, enchantments, storedEnchantments, null, nbt);
        }
    }
}

