/*
 * Decompiled with CFR 0.152.
 */
package smartin.tetraticcombat.ItemResolver;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Iterator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import smartin.tetraticcombat.ItemResolver.JSONFormat;
import smartin.tetraticcombat.ItemResolver.Resolver;

public class ReloadListener
extends SimplePreparableReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();

    protected Object m_5944_(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        String dataFolder = "configs";
        Iterator iterator = resourceManager.m_214159_(dataFolder, fileName -> fileName.toString().endsWith(".json")).keySet().iterator();
        JSONFormat mergedConfig = new JSONFormat();
        mergedConfig.Version = 1.0;
        resourceManager.m_7536_().forEach(packResources -> {
            for (ResourceLocation identifier : resourceManager.m_214159_(dataFolder, fileName -> fileName.toString().endsWith(".json")).keySet()) {
                if (!identifier.m_135827_().equals("tetratic")) continue;
                LOGGER.warn("Tetratic " + identifier.toString());
                resourceManager.m_213713_(identifier).ifPresent(resource -> {
                    try {
                        BufferedReader reader = resource.m_215508_();
                        JSONFormat currentFile = (JSONFormat)new Gson().fromJson((Reader)reader, JSONFormat.class);
                        mergedConfig.merge(currentFile);
                    }
                    catch (Exception JsonParsing) {
                        LOGGER.warn("Exception loading tetratic Configuration from Datapack");
                        LOGGER.warn(JsonParsing.getMessage());
                        LOGGER.warn(identifier.toString());
                    }
                });
            }
        });
        LOGGER.info(mergedConfig.toString());
        return mergedConfig;
    }

    protected void m_5787_(Object mergedConfig, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Resolver.reload((JSONFormat)mergedConfig);
    }
}

