/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.Tags;

public enum PikeType {
    AMUR(1, PikeSize.SMALL, PikeRarity.UNCOMMON, null, (TagKey<Biome>)Tags.Biomes.IS_SWAMP),
    REDFIN(2, PikeSize.SMALL, PikeRarity.COMMON, null, null),
    BROWN_NORTHERN(3, PikeSize.LARGE, PikeRarity.COMMON, 8, null),
    MAHOGANY_NORTHERN(4, PikeSize.LARGE, PikeRarity.UNCOMMON, 9, null),
    JADE_NORTHERN(5, PikeSize.LARGE, PikeRarity.RARE, 10, null),
    OLIVE_NORTHERN(6, PikeSize.LARGE, PikeRarity.SUPER_RARE, 11, null),
    SPECTRAL(7, PikeSize.LARGE, PikeRarity.LEGENDARY, null, null),
    SPOTTED_BROWN_NORTHERN(8, PikeSize.LARGE, PikeRarity.COMMON, null, null),
    SPOTTED_MAHOGANY_NORTHERN(9, PikeSize.LARGE, PikeRarity.UNCOMMON, null, null),
    SPOTTED_JADE_NORTHERN(10, PikeSize.LARGE, PikeRarity.RARE, null, null),
    SPOTTED_OLIVE_NORTHERN(11, PikeSize.LARGE, PikeRarity.SUPER_RARE, null, null),
    SUPERCHARGED(12, PikeSize.LARGE, PikeRarity.LEGENDARY, null, null),
    OBSIDIAN(13, PikeSize.LARGE, PikeRarity.LEGENDARY, null, null),
    MUSKELLUNGE(14, PikeSize.HUGE, PikeRarity.SUPER_RARE, null, (TagKey<Biome>)BiomeTags.f_207605_),
    CHAIN_PICKEREL(15, PikeSize.SMALL, PikeRarity.COMMON, null, (TagKey<Biome>)BiomeTags.f_207605_),
    GRASS_PICKEREL(16, PikeSize.SMALL, PikeRarity.COMMON, null, (TagKey<Biome>)Tags.Biomes.IS_SWAMP),
    BLACK_SOUTHERN(17, PikeSize.MEDIUM, PikeRarity.COMMON, null, null),
    EBONY_SOUTHERN(18, PikeSize.MEDIUM, PikeRarity.UNCOMMON, null, null),
    MUSTARD_SOUTHERN(19, PikeSize.MEDIUM, PikeRarity.RARE, null, null),
    LEMON_SOUTHERN(20, PikeSize.MEDIUM, PikeRarity.RARE, null, null),
    GOLDEN_SOUTHERN(21, PikeSize.MEDIUM, PikeRarity.SUPER_RARE, null, null);

    public final int id;
    public final PikeSize pikeSize;
    public final PikeRarity rarity;
    @Nullable
    private final Integer spottedVariant;
    @Nullable
    private final TagKey<Biome> biomeCategory;

    private PikeType(int id, @Nullable PikeSize pikeSize, @Nullable PikeRarity rarity, Integer spottedVariant, TagKey<Biome> biomeCategory) {
        this.id = id;
        this.pikeSize = pikeSize;
        this.rarity = rarity;
        this.spottedVariant = spottedVariant;
        this.biomeCategory = biomeCategory;
    }

    public static PikeType getTypeById(int id) {
        for (PikeType type : PikeType.values()) {
            if (type.id != id) continue;
            return type;
        }
        return AMUR;
    }

    public static PikeType getRandom(RandomSource rand, Holder<Biome> category, boolean fromBucket) {
        List<PikeType> possibleTypes = PikeType.getPossibleTypes(category, (PikeRarity)((Object)WeightedRandomList.m_146330_((WeightedEntry[])PikeRarity.values()).m_216829_(rand).orElseThrow()), fromBucket);
        PikeType type = possibleTypes.get(rand.m_188503_(possibleTypes.size()));
        Integer spottedVariant = type.spottedVariant;
        return spottedVariant != null && rand.m_188501_() < 0.2f ? PikeType.getTypeById(spottedVariant) : type;
    }

    private static List<PikeType> getPossibleTypes(Holder<Biome> category, PikeRarity rarity, boolean fromBucket) {
        ArrayList pikeTypes = Lists.newArrayList();
        HashSet<PikeType> spotted = new HashSet<PikeType>();
        for (PikeType type : PikeType.values()) {
            if (!fromBucket && type.biomeCategory != null && !category.m_203656_(type.biomeCategory) || type.rarity != rarity || spotted.contains((Object)type)) continue;
            Integer spottedVariant = type.spottedVariant;
            if (spottedVariant != null) {
                spotted.add(PikeType.getTypeById(spottedVariant));
            }
            pikeTypes.add(type);
        }
        return pikeTypes;
    }

    public static enum PikeSize {
        SMALL(1.2f, 1.4f),
        MEDIUM(1.5f, 1.7f),
        LARGE(1.7f, 1.9f),
        HUGE(2.3f, 2.5f);

        public final float renderSize;
        public final float boxSize;

        private PikeSize(float renderSize, float boxSize) {
            this.renderSize = renderSize;
            this.boxSize = boxSize;
        }
    }

    public static enum PikeRarity implements WeightedEntry
    {
        COMMON(ChatFormatting.GRAY, 55),
        UNCOMMON(ChatFormatting.GREEN, 25),
        RARE(ChatFormatting.BLUE, 15),
        SUPER_RARE(ChatFormatting.GOLD, 5),
        LEGENDARY(ChatFormatting.LIGHT_PURPLE, 1);

        public final ChatFormatting formatting;
        private final Weight weight;

        private PikeRarity(ChatFormatting formatting, int weight) {
            this.formatting = formatting;
            this.weight = Weight.m_146282_((int)weight);
        }

        public Weight m_142631_() {
            return this.weight;
        }
    }
}

