/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish;

import com.teamabnormals.blueprint.common.entity.BucketableWaterAnimal;
import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.upgrade_aquatic.common.block.JellyTorchBlock;
import com.teamabnormals.upgrade_aquatic.core.other.JellyfishRegistry;
import com.teamabnormals.upgrade_aquatic.core.other.UADamageSources;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.core.registry.UASoundEvents;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractJellyfish
extends BucketableWaterAnimal
implements Endimatable {
    protected static final EntityDataAccessor<Integer> COOLDOWN = SynchedEntityData.m_135353_(AbstractJellyfish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Predicate<LivingEntity> CAN_STING = entity -> {
        if (entity instanceof Player && ((Player)entity).m_7500_()) {
            return false;
        }
        return !entity.m_5833_() && !(entity instanceof AbstractJellyfish) && !(entity instanceof Turtle);
    };

    public AbstractJellyfish(EntityType<? extends AbstractJellyfish> type, Level world) {
        super(type, world);
        this.f_21365_ = new JellyfishLookControl((Mob)this);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 45, 10, 1.0f, 0.0f, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 1.25).m_22268_(Attributes.f_22281_, 2.0);
    }

    public static <J extends AbstractJellyfish> boolean defaultSpawnCondition(EntityType<J> entity, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() > 45 && pos.m_123342_() < world.m_5736_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COOLDOWN, (Object)0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readAdditionalSaveDataSharedWithBucket(compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.addAdditionalSaveDataSharedWithBucket(compound);
    }

    protected void readAdditionalSaveDataSharedWithBucket(CompoundTag compoundTag) {
        this.setCooldown(compoundTag.m_128451_("CooldownTicks"));
    }

    protected void addAdditionalSaveDataSharedWithBucket(CompoundTag compoundTag) {
        compoundTag.m_128405_("CooldownTicks", this.getCooldown());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6142_()) {
            if (this.m_20159_()) {
                this.m_146922_(0.0f);
                this.m_146926_(0.0f);
                this.m_20301_(this.m_6062_());
            } else if (this.m_20069_() && this.m_21573_().m_26571_()) {
                float yaw = this.m_146908_();
                float pitch = this.m_146909_();
                float pitchFactor = Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                float x = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * pitchFactor;
                float y = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
                float z = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * pitchFactor;
                Vec3 motion = new Vec3((double)x, (double)y, (double)z).m_82541_().m_82490_(0.01666666753590107);
                this.m_5997_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
            if (!this.f_19853_.f_46443_ && (Mth.m_14154_((float)(this.f_19860_ - this.m_146909_())) >= 1.0f || Mth.m_14154_((float)(this.f_19859_ - this.m_146908_())) >= 1.0f)) {
                this.f_19812_ = true;
            }
        }
        if (this.hasCooldown()) {
            if (this.m_6142_()) {
                this.setCooldown(this.getCooldown() - 1);
                if (!this.hasCooldown()) {
                    this.m_5496_((SoundEvent)UASoundEvents.ENTITY_JELLYFISH_COOLDOWN_END.get(), 1.0f, this.f_19796_.m_188501_() * 0.15f + 1.0f);
                }
            }
            if (this.f_19853_.f_46443_ && this.f_19853_.m_46467_() % 4L == 0L) {
                for (int i = 0; i < 2; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)JellyTorchBlock.JellyTorchType.getBlobParticleType(this.getJellyTorchType()), this.m_20208_(0.5), this.m_20186_() + (double)this.m_20192_(), this.m_20262_(0.5), AbstractJellyfish.makeNegativeRandomly(this.f_19796_.m_188500_() * (double)0.05f, this.m_217043_()), -this.f_19796_.m_188500_() * (double)0.05f, AbstractJellyfish.makeNegativeRandomly(this.f_19796_.m_188500_() * (double)0.05f, this.m_217043_()));
                }
            }
        }
        if (this.m_6084_()) {
            for (LivingEntity entities : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(0.15), CAN_STING)) {
                if (!entities.m_6084_()) continue;
                this.stingEntity(entities);
            }
            if (this.m_20069_() && this.isNoEndimationPlaying()) {
                this.m_20256_(this.m_20184_().m_82492_(0.0, (double)0.005f, 0.0));
            }
        }
    }

    public static double makeNegativeRandomly(double value, RandomSource rand) {
        return rand.m_188499_() ? -value : value;
    }

    public void m_7023_(Vec3 Vector3d) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.01f, Vector3d);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.75));
        } else {
            super.m_7023_(Vector3d);
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == Items.f_42447_ && this.m_6084_()) {
            this.m_5496_((SoundEvent)UASoundEvents.ITEM_BUCKET_FILL_JELLYFISH.get(), 1.0f, 1.0f);
            itemstack.m_41774_(1);
            ItemStack bucket = this.m_28282_();
            this.m_6872_(bucket);
            if (!this.f_19853_.f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucket);
            }
            if (itemstack.m_41619_()) {
                player.m_21008_(hand, bucket);
            } else if (!player.m_150109_().m_36054_(bucket)) {
                player.m_36176_(bucket, false);
            }
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41619_() && this.m_7755_().getString().toLowerCase().trim().equals("jellysox345")) {
            this.m_20329_((Entity)player);
            return InteractionResult.SUCCESS;
        }
        if (item == UAItems.PRISMARINE_ROD.get() && !this.hasCooldown()) {
            Random rand = new Random();
            if (this.m_6142_() && rand.nextFloat() < this.getCooldownChance()) {
                this.setCooldown(20 * (rand.nextInt(16) + 15));
                this.m_5496_((SoundEvent)UASoundEvents.ENTITY_JELLYFISH_COOLDOWN_START.get(), 1.0f, this.f_19796_.m_188501_() * 0.15f + 1.0f);
            }
            itemstack.m_41774_(1);
            player.m_36356_(this.getTorchByType(this.getJellyTorchType()));
            this.m_5496_((SoundEvent)UASoundEvents.ENTITY_JELLYFISH_HARVEST.get(), 1.0f, this.f_19796_.m_188501_() * 0.15f + 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected SoundEvent m_7515_() {
        return this.m_20069_() ? (SoundEvent)UASoundEvents.ENTITY_JELLYFISH_AMBIENT.get() : null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UASoundEvents.ENTITY_JELLYFISH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UASoundEvents.ENTITY_JELLYFISH_DEATH.get();
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, 0.25f, this.m_6100_());
        }
    }

    public int m_8100_() {
        return this.f_19796_.m_188503_(200) + 200;
    }

    public void m_6872_(ItemStack bucket) {
        super.m_6872_(bucket);
        CompoundTag compoundTag = bucket.m_41784_();
        compoundTag.m_128359_("EntityType", Registry.f_122826_.m_7981_((Object)this.m_6095_()).toString());
        compoundTag.m_128365_("JellyfishDisplayTag", (Tag)this.getBucketDisplayInfo().write());
        this.addAdditionalSaveDataSharedWithBucket(compoundTag);
    }

    public void m_142278_(CompoundTag compoundTag) {
        super.m_142278_(compoundTag);
        this.readAdditionalSaveDataSharedWithBucket(compoundTag);
    }

    public int getCooldown() {
        return (Integer)this.f_19804_.m_135370_(COOLDOWN);
    }

    public void setCooldown(int ticks) {
        this.f_19804_.m_135381_(COOLDOWN, (Object)ticks);
    }

    public boolean hasCooldown() {
        return this.getCooldown() > 0;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)UAItems.JELLYFISH_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return (SoundEvent)UASoundEvents.ITEM_BUCKET_FILL_JELLYFISH.get();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.JELLYFISH_SPAWN_EGG.get());
    }

    public void m_21043_(LivingEntity entity, boolean p_233629_2_) {
        super.m_21043_(entity, true);
    }

    public abstract BucketDisplayInfo getBucketDisplayInfo();

    public abstract JellyTorchBlock.JellyTorchType getJellyTorchType();

    public abstract float getCooldownChance();

    protected final BucketDisplayInfo bucketDisplayInfo(String name, int subId, JellyTorchBlock.JellyTorchType ... yieldingTorchTypes) {
        return new BucketDisplayInfo(name, JellyfishRegistry.IDS.get(((Object)((Object)this)).getClass()), subId, yieldingTorchTypes);
    }

    protected boolean stingEntity(LivingEntity livingEntity) {
        if (livingEntity.m_6469_(UADamageSources.causeJellyfishDamage(this), (float)this.m_21051_(Attributes.f_22281_).m_22135_())) {
            this.m_5496_((SoundEvent)UASoundEvents.ENTITY_JELLYFISH_STING.get(), 0.5f, this.f_19796_.m_188501_() * 0.2f + 1.0f);
            return true;
        }
        return false;
    }

    protected ItemStack getTorchByType(JellyTorchBlock.JellyTorchType type) {
        return new ItemStack((ItemLike)type.torch.get());
    }

    public static class JellyfishLookControl
    extends LookControl {
        public JellyfishLookControl(Mob mob) {
            super(mob);
        }

        protected boolean m_8106_() {
            return false;
        }
    }

    public record BucketDisplayInfo(String name, int id, int subId, JellyTorchBlock.JellyTorchType[] yieldingTorchTypes) {
        public static float readVariant(CompoundTag compoundTag) {
            return (float)compoundTag.m_128451_("Id") + 0.1f * (float)compoundTag.m_128451_("SubId");
        }

        public static void appendHoverText(List<Component> tooltip, CompoundTag compoundTag) {
            String name = compoundTag.m_128461_("Name");
            if (!name.isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)("tooltip.upgrade_aquatic." + name + "_jellyfish")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            if (!compoundTag.m_128425_("YieldingTorchTypes", 11)) {
                return;
            }
            int[] yieldingTorchTypes = ((IntArrayTag)compoundTag.m_128423_("YieldingTorchTypes")).m_128648_();
            int length = yieldingTorchTypes.length;
            if (length <= 0) {
                return;
            }
            MutableComponent component = Component.m_237115_((String)"tooltip.upgrade_aquatic.yielding_jelly_torch").m_130940_(ChatFormatting.GRAY);
            while (true) {
                JellyTorchBlock.JellyTorchType torchType = JellyTorchBlock.JellyTorchType.getByOrdinal(yieldingTorchTypes[length - 1]);
                component = component.m_7220_((Component)Component.m_237115_((String)("tooltip.upgrade_aquatic." + torchType.toString().toLowerCase() + "_jelly_torch")).m_130940_(torchType.color));
                if (--length <= 0) break;
                component = component.m_7220_((Component)Component.m_237115_((String)"tooltip.upgrade_aquatic.yielding_jelly_torch.or").m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)component);
        }

        public CompoundTag write() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("Name", this.name);
            compoundTag.m_128405_("Id", this.id);
            compoundTag.m_128405_("SubId", this.subId);
            IntArrayTag yieldingTorchTypesTag = new IntArrayTag(new int[0]);
            for (JellyTorchBlock.JellyTorchType jellyTorchType : this.yieldingTorchTypes) {
                yieldingTorchTypesTag.add((Object)IntTag.m_128679_((int)jellyTorchType.ordinal()));
            }
            compoundTag.m_128365_("YieldingTorchTypes", (Tag)yieldingTorchTypesTag);
            return compoundTag;
        }
    }
}

