/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.mixin.client;

import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DrownedModel.class})
public class DrownedModelMixin<T extends Zombie>
extends ZombieModel<T> {
    public DrownedModelMixin(ModelPart p_171090_) {
        super(p_171090_);
    }

    @Inject(at={@At(value="TAIL")}, method={"setupAnim(Lnet/minecraft/world/entity/monster/Zombie;FFFFF)V"})
    private void setRotationAngles(T drowned, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo info) {
        if (drowned.m_6067_() && drowned.m_20069_() && drowned.m_20202_() == null && this.getHorizontalMotion(drowned.m_20184_()) >= 0.025f && drowned.m_20193_().m_6425_(drowned.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_)) {
            float leftArmSwimAnimTicks;
            float limbSwingRemainder = limbSwing % 26.0f;
            HumanoidArm handside = this.m_102856_((LivingEntity)drowned);
            float rightArmSwimAnimTicks = handside == HumanoidArm.RIGHT && this.f_102608_ > 0.0f ? 0.0f : this.f_102818_;
            float f = leftArmSwimAnimTicks = handside == HumanoidArm.LEFT && this.f_102608_ > 0.0f ? 0.0f : this.f_102818_;
            if (limbSwingRemainder < 14.0f) {
                this.f_102812_.f_104203_ = this.m_102835_(leftArmSwimAnimTicks, this.f_102812_.f_104203_, 0.0f);
                this.f_102811_.f_104203_ = Mth.m_14179_((float)rightArmSwimAnimTicks, (float)this.f_102811_.f_104203_, (float)0.0f);
                this.f_102812_.f_104204_ = this.m_102835_(leftArmSwimAnimTicks, this.f_102812_.f_104204_, (float)Math.PI);
                this.f_102811_.f_104204_ = Mth.m_14179_((float)rightArmSwimAnimTicks, (float)this.f_102811_.f_104204_, (float)((float)Math.PI));
                this.f_102812_.f_104205_ = this.m_102835_(leftArmSwimAnimTicks, this.f_102812_.f_104205_, (float)Math.PI + 1.8707964f * this.getArmAngleSq(limbSwingRemainder) / this.getArmAngleSq(14.0f));
                this.f_102811_.f_104205_ = Mth.m_14179_((float)rightArmSwimAnimTicks, (float)this.f_102811_.f_104205_, (float)((float)Math.PI - 1.8707964f * this.getArmAngleSq(limbSwingRemainder) / this.getArmAngleSq(14.0f)));
            } else if (limbSwingRemainder >= 14.0f && limbSwingRemainder < 22.0f) {
                float multiplier1 = (limbSwingRemainder - 14.0f) / 8.0f;
                this.f_102812_.f_104203_ = this.m_102835_(leftArmSwimAnimTicks, this.f_102812_.f_104203_, 1.5707964f * multiplier1);
                this.f_102811_.f_104203_ = Mth.m_14179_((float)rightArmSwimAnimTicks, (float)this.f_102811_.f_104203_, (float)(1.5707964f * multiplier1));
                this.f_102812_.f_104204_ = this.m_102835_(leftArmSwimAnimTicks, this.f_102812_.f_104204_, (float)Math.PI);
                this.f_102811_.f_104204_ = Mth.m_14179_((float)rightArmSwimAnimTicks, (float)this.f_102811_.f_104204_, (float)((float)Math.PI));
                this.f_102812_.f_104205_ = this.m_102835_(leftArmSwimAnimTicks, this.f_102812_.f_104205_, 5.012389f - 1.8707964f * multiplier1);
                this.f_102811_.f_104205_ = Mth.m_14179_((float)rightArmSwimAnimTicks, (float)this.f_102811_.f_104205_, (float)(1.2707963f + 1.8707964f * multiplier1));
            } else if (limbSwingRemainder >= 22.0f && limbSwingRemainder < 26.0f) {
                float multiplier2 = (limbSwingRemainder - 22.0f) / 4.0f;
                this.f_102812_.f_104203_ = this.m_102835_(leftArmSwimAnimTicks, this.f_102812_.f_104203_, 1.5707964f - 1.5707964f * multiplier2);
                this.f_102811_.f_104203_ = Mth.m_14179_((float)rightArmSwimAnimTicks, (float)this.f_102811_.f_104203_, (float)(1.5707964f - 1.5707964f * multiplier2));
                this.f_102812_.f_104204_ = this.m_102835_(leftArmSwimAnimTicks, this.f_102812_.f_104204_, (float)Math.PI);
                this.f_102811_.f_104204_ = Mth.m_14179_((float)rightArmSwimAnimTicks, (float)this.f_102811_.f_104204_, (float)((float)Math.PI));
                this.f_102812_.f_104205_ = this.m_102835_(leftArmSwimAnimTicks, this.f_102812_.f_104205_, (float)Math.PI);
                this.f_102811_.f_104205_ = Mth.m_14179_((float)rightArmSwimAnimTicks, (float)this.f_102811_.f_104205_, (float)((float)Math.PI));
            }
            this.f_102808_.f_104203_ = drowned.m_6067_() ? this.m_102835_(this.f_102818_, this.f_102808_.f_104203_, -0.7853982f) : this.m_102835_(this.f_102818_, this.f_102808_.f_104203_, headPitch * ((float)Math.PI / 180));
            this.f_102814_.f_104203_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102814_.f_104203_, (float)(0.3f * Mth.m_14089_((float)(limbSwing * 0.33333334f + (float)Math.PI))));
            this.f_102813_.f_104203_ = Mth.m_14179_((float)this.f_102818_, (float)this.f_102813_.f_104203_, (float)(0.3f * Mth.m_14089_((float)(limbSwing * 0.33333334f))));
        }
    }

    private float getArmAngleSq(float limbSwing) {
        return -65.0f * limbSwing + limbSwing * limbSwing;
    }

    private float getHorizontalMotion(Vec3 motion) {
        double x = motion.m_7096_();
        double z = motion.m_7094_();
        return Mth.m_14116_((float)((float)(x * x + z * z)));
    }
}

