/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.BeachgrassDunesFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.DriftwoodFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.FloweringRushFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.PickerelweedFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.PrismarineCoralFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.RiverTreeFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.SearocketFeature;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CarvingMaskPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="upgrade_aquatic")
public class UAFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"upgrade_aquatic");
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> PRISMARINE_CORAL = FEATURES.register("prismarine_coral", () -> new PrismarineCoralFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> PICKERELWEED = FEATURES.register("pickerelweed", () -> new PickerelweedFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SEAROCKET = FEATURES.register("searocket", () -> new SearocketFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> FLOWERING_RUSH = FEATURES.register("flowering_rush", () -> new FloweringRushFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> DRIFTWOOD = FEATURES.register("driftwood", () -> new DriftwoodFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> DUNES = FEATURES.register("dunes", () -> new BeachgrassDunesFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<TreeConfiguration>> RIVER_TREE = FEATURES.register("river_tree", () -> new RiverTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));

    public static final class UAPlacedFeatures {
        public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"upgrade_aquatic");
        public static final RegistryObject<PlacedFeature> ORE_AMMONITE = UAPlacedFeatures.register("ore_ammonite", UAConfiguredFeatures.ORE_AMMONITE, UAPlacedFeatures.commonOrePlacement(30, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)73))));
        public static final RegistryObject<PlacedFeature> BEACHGRASS_DUNES = UAPlacedFeatures.register("beachgrass_dunes", UAConfiguredFeatures.BEACHGRASS_DUNES, VegetationPlacements.m_195474_((int)14));
        public static final RegistryObject<PlacedFeature> RIVER_TREE = UAPlacedFeatures.register("trees_river", UAConfiguredFeatures.RIVER_TREE, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.5f, (int)2)));
        public static final RegistryObject<PlacedFeature> PRISMARINE_CORAL = UAPlacedFeatures.register("prismarine_coral", UAConfiguredFeatures.PRISMARINE_CORAL, new PlacementModifier[]{CarvingMaskPlacement.m_191590_((GenerationStep.Carving)GenerationStep.Carving.AIR), RarityFilter.m_191900_((int)256), BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_SEAROCKET = UAPlacedFeatures.register("patch_searocket", UAConfiguredFeatures.PATCH_SEAROCKET, new PlacementModifier[]{RarityFilter.m_191900_((int)15), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_PICKERELWEED = UAPlacedFeatures.register("patch_pickerelweed", UAConfiguredFeatures.PATCH_PICKERELWEED, new PlacementModifier[]{RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_PICKERELWEED_EXTRA = UAPlacedFeatures.register("patch_pickerelweed_extra", UAConfiguredFeatures.PATCH_PICKERELWEED, new PlacementModifier[]{InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> PATCH_FLOWERING_RUSH = UAPlacedFeatures.register("patch_flowering_rush", UAConfiguredFeatures.PATCH_FLOWERING_RUSH, new PlacementModifier[]{RarityFilter.m_191900_((int)6), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> DRIFTWOOD_OCEAN = UAPlacedFeatures.register("driftwood_ocean", UAConfiguredFeatures.DRIFTWOOD, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> DRIFTWOOD_BEACH = UAPlacedFeatures.register("driftwood_beach", UAConfiguredFeatures.DRIFTWOOD, new PlacementModifier[]{RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        public static final RegistryObject<PlacedFeature> DRIFTWOOD_RIVER = UAPlacedFeatures.register("driftwood_river", UAConfiguredFeatures.DRIFTWOOD, VegetationPlacements.m_195474_((int)3));
        public static final RegistryObject<PlacedFeature> DRIFTWOOD_SWAMP = UAPlacedFeatures.register("driftwood_swamp", UAConfiguredFeatures.DRIFTWOOD, VegetationPlacements.m_195474_((int)4));
        public static final RegistryObject<PlacedFeature> DRIFTWOOD_EXTRA = UAPlacedFeatures.register("driftwood_extra", UAConfiguredFeatures.DRIFTWOOD, VegetationPlacements.m_195474_((int)5));

        private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
            return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
        }

        private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
            return UAPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), modifier);
        }

        public static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> configuredFeature, PlacementModifier ... placementModifiers) {
            return UAPlacedFeatures.register(name, configuredFeature, List.of(placementModifiers));
        }

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placementModifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature((Holder)feature.getHolder().get(), (List)ImmutableList.copyOf((Collection)placementModifiers)));
        }
    }

    public static final class UAConfiguredFeatures {
        public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"upgrade_aquatic");
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> RIVER_TREE = UAConfiguredFeatures.register("river_tree", () -> new ConfiguredFeature((Feature)RIVER_TREE.get(), (FeatureConfiguration)Configs.RIVER_TREE_CONFIG));
        public static final RegistryObject<ConfiguredFeature<OreConfiguration, ?>> ORE_AMMONITE = UAConfiguredFeatures.register("ore_ammonite", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(OreFeatures.f_195071_, ((Block)UABlocks.EMBEDDED_AMMONITE.get()).m_49966_(), 3)));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> BEACHGRASS_DUNES = UAConfiguredFeatures.register("beachgrass_dunes", () -> new ConfiguredFeature((Feature)DUNES.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PRISMARINE_CORAL = UAConfiguredFeatures.register("prismarine_coral", () -> new ConfiguredFeature((Feature)PRISMARINE_CORAL.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PATCH_SEAROCKET = UAConfiguredFeatures.register("patch_searocket", () -> new ConfiguredFeature((Feature)SEAROCKET.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PATCH_PICKERELWEED = UAConfiguredFeatures.register("patch_pickerelweed", () -> new ConfiguredFeature((Feature)PICKERELWEED.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> PATCH_FLOWERING_RUSH = UAConfiguredFeatures.register("patch_flowering_rush", () -> new ConfiguredFeature((Feature)FLOWERING_RUSH.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        public static final RegistryObject<ConfiguredFeature<NoneFeatureConfiguration, ?>> DRIFTWOOD = UAConfiguredFeatures.register("driftwood", () -> new ConfiguredFeature((Feature)DRIFTWOOD.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> RegistryObject<ConfiguredFeature<FC, ?>> register(String name, Supplier<ConfiguredFeature<FC, F>> feature) {
            return CONFIGURED_FEATURES.register(name, feature);
        }
    }

    public static final class Configs {
        public static final TreeConfiguration RIVER_TREE_CONFIG = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)UABlocks.RIVER_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(3, 1, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)UABlocks.RIVER_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0), 0), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).m_68244_().m_68251_();
    }
}

