/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradedcore.base;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.rolfmao.upgradedcore.init.ModTags;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class HammerItem
extends DiggerItem {
    protected static final Map<Block, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>> TILLABLES = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.f_50440_, (Object)Pair.of(HoeItem::m_150856_, HammerItem.changeIntoState(Blocks.f_50093_.m_49966_())), (Object)Blocks.f_152481_, (Object)Pair.of(HoeItem::m_150856_, HammerItem.changeIntoState(Blocks.f_50093_.m_49966_())), (Object)Blocks.f_50493_, (Object)Pair.of(HoeItem::m_150856_, HammerItem.changeIntoState(Blocks.f_50093_.m_49966_())), (Object)Blocks.f_50546_, (Object)Pair.of(HoeItem::m_150856_, HammerItem.changeIntoState(Blocks.f_50493_.m_49966_())), (Object)Blocks.f_152549_, (Object)Pair.of(p_150861_ -> true, HammerItem.changeIntoStateAndDropItem(Blocks.f_50493_.m_49966_(), (ItemLike)Items.f_151017_))));

    public HammerItem(Tier tier, float attack, float speed, Item.Properties properties) {
        super(attack, speed, tier, ModTags.MINEABLE_WITH_HAMMER, properties);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_.equals((Object)EnchantmentCategory.WEAPON) || enchantment.f_44672_.equals((Object)EnchantmentCategory.DIGGER) || enchantment.f_44672_.equals((Object)EnchantmentCategory.BREAKABLE);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(action) || ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(action) || ToolActions.DEFAULT_AXE_ACTIONS.contains(action) || ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(action) || ToolActions.DEFAULT_HOE_ACTIONS.contains(action);
    }

    public float m_8102_(ItemStack stack, BlockState blockState) {
        if (blockState.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return super.m_8102_(stack, blockState);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult iResult = HammerItem.axeUseOn(context);
        if (iResult == InteractionResult.PASS) {
            iResult = HammerItem.shovelUseOn(context);
        }
        if (iResult == InteractionResult.PASS) {
            iResult = HammerItem.hoeUseOn(context);
        }
        return iResult;
    }

    private static InteractionResult axeUseOn(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(context, ToolActions.AXE_STRIP, false));
        Optional<BlockState> optional1 = Optional.ofNullable(blockstate.getToolModifiedState(context, ToolActions.AXE_SCRAPE, false));
        Optional<BlockState> optional2 = Optional.ofNullable(blockstate.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false));
        ItemStack itemstack = context.m_43722_();
        Optional<Object> optional3 = Optional.empty();
        if (optional.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional3 = optional;
        } else if (optional1.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockpos, 0);
            optional3 = optional1;
        } else if (optional2.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockpos, 0);
            optional3 = optional2;
        }
        if (optional3.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_7731_(blockpos, (BlockState)optional3.get(), 11);
            if (player != null) {
                itemstack.m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult hoeUseOn(UseOnContext context) {
        Pair pair;
        BlockPos blockpos;
        Level level = context.m_43725_();
        BlockState toolModifiedState = level.m_8055_(blockpos = context.m_8083_()).getToolModifiedState(context, ToolActions.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, HammerItem.changeIntoState(toolModifiedState));
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Player player = context.m_43723_();
            level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                consumer.accept(context);
                if (player != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)player, p_150845_ -> p_150845_.m_21190_(context.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static Consumer<UseOnContext> changeIntoState(BlockState blockState) {
        return context -> context.m_43725_().m_7731_(context.m_8083_(), blockState, 11);
    }

    public static Consumer<UseOnContext> changeIntoStateAndDropItem(BlockState blockState, ItemLike itemLike) {
        return context -> {
            context.m_43725_().m_7731_(context.m_8083_(), blockState, 11);
            Block.m_152435_((Level)context.m_43725_(), (BlockPos)context.m_8083_(), (Direction)context.m_43719_(), (ItemStack)new ItemStack(itemLike));
        };
    }

    private static InteractionResult shovelUseOn(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (context.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        BlockState blockstate1 = blockstate.getToolModifiedState(context, ToolActions.SHOVEL_FLATTEN, false);
        BlockState blockstate2 = null;
        if (player.m_6047_() && blockstate1 != null && level.m_46859_(blockpos.m_7494_())) {
            level.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.m_60734_() instanceof CampfireBlock && ((Boolean)blockstate.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_5898_((Player)null, 1009, blockpos, 0);
            }
            CampfireBlock.m_152749_((Entity)context.m_43723_(), (LevelAccessor)level, (BlockPos)blockpos, (BlockState)blockstate);
            blockstate2 = (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate2 != null) {
            if (!level.f_46443_) {
                level.m_7731_(blockpos, blockstate2, 11);
                if (player != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)player, p_43122_ -> p_43122_.m_21190_(context.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return true;
        }
        return super.isCorrectToolForDrops(stack, state);
    }
}

