/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.config.ServerConfig;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MushroomHatItem
extends AbstractHatItem
implements IUsefulHatModelOwner {
    public MushroomHatItem() {
        super(HatArmorMaterial.MUSHROOM, MushroomHatItem.rawColorFromRGB(197, 35, 35), ServerConfig.MUSHROOM_HAT_DAMAGE_ENABLED);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"item.usefulhats.mushroom_hat.desc.feeding").m_130940_(ChatFormatting.BLUE));
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.f_46443_) {
            if (!UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player).contains(stack)) {
                return;
            }
            FoodData foodStats = player.m_36324_();
            if (foodStats.m_38721_() && player.f_19797_ % (Integer)ServerConfig.MUSHROOM_HAT_EAT_INTERVAL.get() == 0) {
                foodStats.m_38707_(1, 0.5f);
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
                this.damageHatItemByOne(stack, player);
            }
        }
    }
}

