/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.config.ServerConfig;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IEquipmentChangeListener;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WingHelmetItem
extends AbstractHatItem
implements IEquipmentChangeListener {
    private static final int SLOW_FALLING_AMPLIFIER = 0;
    private static final int SLOW_FALLING_DURATION = 219;
    private static final int LEVITATION_AMPLIFIER = 2;
    private static final int LEVITATION_DURATION = 200;

    public WingHelmetItem() {
        super(HatArmorMaterial.WING, WingHelmetItem.rawColorFromRGB(255, 255, 255), ServerConfig.WING_HELMET_DAMAGE_ENABLED);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"item.usefulhats.wing_helmet.desc.slow_falling").m_130940_(ChatFormatting.BLUE));
        if (((Boolean)ServerConfig.WING_HELMET_LEVITATION_ENABLED.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"item.usefulhats.wing_helmet.desc.scared").m_130940_(ChatFormatting.RED));
        }
    }

    private boolean isPlayerFalling(Player player) {
        return !player.m_20096_() && player.m_20184_().m_7098_() < 0.0 && !player.m_150110_().f_35935_ && !player.m_21255_() && !player.m_20069_() && !player.m_20077_();
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_) {
            boolean isSlowFallingEffectActive;
            boolean isLevitationEffectActive;
            if (!UsefulHatsUtils.getEquippedHatItemStacks((LivingEntity)player).contains(stack)) {
                return;
            }
            boolean isLevitationFromOtherSource = this.isEffectCausedByOtherSource((LivingEntity)player, MobEffects.f_19620_, 200, 2);
            boolean bl = isLevitationEffectActive = player.m_21124_(MobEffects.f_19620_) != null;
            if (!isLevitationEffectActive && ((Boolean)ServerConfig.WING_HELMET_LEVITATION_ENABLED.get()).booleanValue() && player.m_21225_() != null && player.m_21225_().m_7639_() instanceof LivingEntity && level.f_46441_.m_188503_(100) == 0) {
                this.removeEffect((LivingEntity)player, MobEffects.f_19591_, 219, 0);
                this.addEffect((LivingEntity)player, MobEffects.f_19620_, 200, 2, true);
                isLevitationEffectActive = true;
            }
            boolean isSlowFallingFromOtherSource = this.isEffectCausedByOtherSource((LivingEntity)player, MobEffects.f_19591_, 219, 0);
            boolean bl2 = isSlowFallingEffectActive = player.m_21124_(MobEffects.f_19591_) != null;
            if (this.isPlayerFalling(player)) {
                if (!(isLevitationEffectActive || isSlowFallingFromOtherSource || isSlowFallingEffectActive && player.f_19797_ % 19 != 0)) {
                    this.addEffect((LivingEntity)player, MobEffects.f_19591_, 219, 0);
                    isSlowFallingEffectActive = true;
                }
            } else {
                this.removeEffect((LivingEntity)player, MobEffects.f_19591_, 219, 0);
            }
            if ((isSlowFallingEffectActive && !isSlowFallingFromOtherSource || isLevitationEffectActive && !isLevitationFromOtherSource && ((Boolean)ServerConfig.WING_HELMET_LEVITATION_ENABLED.get()).booleanValue()) && level.f_46441_.m_188503_(20) == 0) {
                this.damageHatItemByOne(stack, player);
            }
        }
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        this.removeEffect(entity, MobEffects.f_19591_, 219, 0);
        if (((Boolean)ServerConfig.WING_HELMET_LEVITATION_ENABLED.get()).booleanValue()) {
            this.removeEffect(entity, MobEffects.f_19620_, 200, 2);
        }
    }
}

