/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.entities.machines;

import com.vies.viescraftmachines.VCMCommonConfig;
import com.vies.viescraftmachines.common.entities.machines.EntityMachineBase;
import com.vies.viescraftmachines.common.items.ItemMachineBattery;
import com.vies.viescraftmachines.util.enums.MachineType;
import com.vies.viescraftmachines.util.init.common.InitItemsVCM;
import com.vies.viescraftmachines.util.init.common.InitParticlesVCM;
import com.vies.viescraftmachines.util.init.common.InitSoundsVCM;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class EntityMachineFuel
extends EntityMachineBase {
    private static final EntityDataAccessor<Integer> DATA_ID_CURRENTACTIVEFUEL = SynchedEntityData.m_135353_(EntityMachineFuel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_OVERALLACTIVEFUEL = SynchedEntityData.m_135353_(EntityMachineFuel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_BROKEN = SynchedEntityData.m_135353_(EntityMachineFuel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_POWERED = SynchedEntityData.m_135353_(EntityMachineFuel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_AUTORUN = SynchedEntityData.m_135353_(EntityMachineFuel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_VERYBROKENCOUNTER = SynchedEntityData.m_135353_(EntityMachineFuel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_TURBOACTIVATED = SynchedEntityData.m_135353_(EntityMachineFuel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int applyfuel = 0;
    protected int baseTickFuel = 1;
    protected int tickingVariableSound = 0;
    protected int tickingVariableFlameParticle;

    public EntityMachineFuel(EntityType<? extends EntityMachineFuel> entitytypeIn, Level levelIn) {
        super((EntityType<? extends EntityMachineBase>)entitytypeIn, levelIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_CURRENTACTIVEFUEL, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_OVERALLACTIVEFUEL, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_BROKEN, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_POWERED, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_AUTORUN, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_VERYBROKENCOUNTER, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TURBOACTIVATED, (Object)false);
    }

    @Override
    protected void m_7380_(CompoundTag tagIn) {
        super.m_7380_(tagIn);
        tagIn.m_128379_("tag-machine-broken_vcm", this.getStatusBroken());
        tagIn.m_128379_("tag-machine-powered_vcm", this.getStatusPowered());
        tagIn.m_128379_("tag-machine-autorun_vcm", this.getStatusAutorun());
        tagIn.m_128405_("tag-machine-verybrokencounter_vcm", this.getStatusVeryBrokenCounter());
        tagIn.m_128405_("tag-machine-currentactivefuel_vcm", this.getStatusCurrentActiveFuel());
        tagIn.m_128405_("tag-machine-currenttotalfuel_vcm", this.currentTotalFuel);
        tagIn.m_128405_("tag-machine-overallactivefuel_vcm", this.getStatusOverallActiveFuel());
        tagIn.m_128405_("tag-machine-overallactivefuel_vcm", this.overallTotalFuel);
    }

    @Override
    protected void m_7378_(CompoundTag tagIn) {
        super.m_7378_(tagIn);
        this.setStatusBroken(tagIn.m_128471_("tag-machine-broken_vcm"));
        this.setStatusPowered(tagIn.m_128471_("tag-machine-powered_vcm"));
        this.setStatusAutorun(tagIn.m_128471_("tag-machine-autorun_vcm"));
        this.setStatusVeryBrokenCounter(tagIn.m_128451_("tag-machine-verybrokencounter_vcm"));
        this.setStatusCurrentActiveFuel(tagIn.m_128451_("tag-machine-currentactivefuel_vcm"));
        this.currentTotalFuel = tagIn.m_128451_("tag-machine-currenttotalfuel_vcm");
        this.setStatusOverallActiveFuel(tagIn.m_128451_("tag-machine-overallactivefuel_vcm"));
        this.overallTotalFuel = tagIn.m_128451_("tag-machine-overallactivefuel_vcm");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.getStatusBroken()) {
            if (this.IsFuelNeeded()) {
                this.ActiveFuelSystem();
            }
            this.OverallFuelSystem();
        } else {
            if (this.getStatusCurrentActiveFuel() > 0) {
                this.setStatusCurrentActiveFuel(0);
            }
            if (this.currentTotalFuel > 0) {
                this.currentTotalFuel = 0;
            }
            if (this.getStatusOverallActiveFuel() > 0) {
                this.setStatusOverallActiveFuel(0);
            }
            if (this.overallTotalFuel > 0) {
                this.overallTotalFuel = 0;
            }
            if (this.getStatusPowered()) {
                this.setStatusPowered(false);
            }
        }
        if (((Boolean)VCMCommonConfig.SOUNDS_ENGINE_ON.get()).booleanValue() && this.IsBurningFuel() && !this.getStatusBroken() && this.getStatusPowered() && this.tickingVariableSound >= 8) {
            this.tickingVariableSound = 0;
            this.f_19853_.m_6269_((Player)null, (Entity)this, (SoundEvent)InitSoundsVCM.SOUND_ENGINEON.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (this.f_19853_.m_213780_().m_188501_() * 0.4f + 0.8f));
        }
        if (this.PoweredAndHasFuel()) {
            if (this.getStatusMachineType() == MachineType.FLYING.ordinal()) {
                InitParticlesVCM.doSmokeStackEffect(this, this.f_19796_, this.f_19815_);
                if (this.getStatusTurboActivated()) {
                    if (this.tickingVariableFlameParticle >= 2) {
                        InitParticlesVCM.doTurboThrusterParticlesEffectFlying(this, this.f_19796_);
                        this.tickingVariableFlameParticle = 0;
                    }
                } else if (this.tickingVariableFlameParticle >= 3) {
                    InitParticlesVCM.doThrusterParticlesEffectFlying(this);
                    this.tickingVariableFlameParticle = 0;
                }
            }
            if (this.getStatusMachineType() == MachineType.GROUND.ordinal()) {
                InitParticlesVCM.doSmokeStackEffect(this, this.f_19796_, this.f_19815_);
                if (this.getStatusTurboActivated()) {
                    if (this.tickingVariableFlameParticle >= 2) {
                        InitParticlesVCM.doTurboThrusterParticlesEffectGround(this, this.f_19796_);
                        InitParticlesVCM.doBottomThrusterParticlesEffectGround(this);
                        this.tickingVariableFlameParticle = 0;
                    }
                } else if (this.tickingVariableFlameParticle >= 3) {
                    InitParticlesVCM.doThrusterParticlesEffectGround(this);
                    InitParticlesVCM.doBottomThrusterParticlesEffectGround(this);
                    this.tickingVariableFlameParticle = 0;
                }
            }
            if (this.getStatusMachineType() == MachineType.SEA.ordinal()) {
                InitParticlesVCM.doSmokeStackEffectSea(this, this.f_19796_, this.f_19815_);
                if (this.getStatusTurboActivated()) {
                    if (this.tickingVariableFlameParticle >= 2) {
                        InitParticlesVCM.doTurboThrusterParticlesEffectSea(this, this.f_19796_);
                        this.tickingVariableFlameParticle = 0;
                    }
                } else if (this.tickingVariableFlameParticle >= 3) {
                    InitParticlesVCM.doThrusterParticlesEffectSea(this);
                    this.tickingVariableFlameParticle = 0;
                }
            }
            if (this.getStatusMachineType() == MachineType.HAULER.ordinal()) {
                InitParticlesVCM.doSmokeStackEffectHauler(this, this.f_19796_, this.f_19815_);
                if (this.getStatusTurboActivated()) {
                    if (this.tickingVariableFlameParticle >= 2) {
                        InitParticlesVCM.doTurboThrusterParticlesEffectHauler(this, this.f_19796_);
                        InitParticlesVCM.doBottomThrusterParticlesEffectHauler(this);
                        this.tickingVariableFlameParticle = 0;
                    }
                } else if (this.tickingVariableFlameParticle >= 3) {
                    InitParticlesVCM.doThrusterParticlesEffectHauler(this);
                    InitParticlesVCM.doBottomThrusterParticlesEffectHauler(this);
                    this.tickingVariableFlameParticle = 0;
                }
            }
        }
        ++this.tickingVariableSound;
        ++this.tickingVariableFlameParticle;
    }

    @Override
    public InteractionResult m_6096_(Player playerIn, InteractionHand interactionhandIn) {
        return super.m_6096_(playerIn, interactionhandIn);
    }

    public boolean IsFuelNeeded() {
        if (this.m_6688_() instanceof Player) {
            Player ridingplayer = (Player)this.m_6688_();
            return !ridingplayer.m_7500_();
        }
        return true;
    }

    public int GetBaseTickFuel() {
        return this.baseTickFuel;
    }

    public void ActiveFuelSystem() {
        if (this.getStatusCurrentActiveFuel() < this.GetBaseTickFuel()) {
            this.setStatusCurrentActiveFuel(0);
        }
        if (this.getStatusPowered()) {
            if (this.getStatusCurrentActiveFuel() > 0) {
                int turbomodifier = 20;
                if (this.getStatusTurboActivated()) {
                    turbomodifier = 10;
                }
                if (this.applyfuel >= turbomodifier) {
                    this.applyfuel = 0;
                    this.setStatusCurrentActiveFuel(this.getStatusCurrentActiveFuel() - this.GetBaseTickFuel());
                }
                ++this.applyfuel;
            }
            if (!this.IsBurningFuel() && this.m_6688_() != null && this.m_6688_() instanceof Player && !this.inventory.getStackInSlot(this.ItemslotFuel).m_41619_()) {
                ItemStack fuelSlotStack = this.inventory.getStackInSlot(this.ItemslotFuel);
                if (fuelSlotStack.m_41720_() instanceof ItemMachineBattery) {
                    if (fuelSlotStack.m_41773_() < fuelSlotStack.m_41776_()) {
                        this.setStatusCurrentActiveFuel(this.GetItemBurnTime(fuelSlotStack));
                        this.currentTotalFuel = this.GetItemBurnTime(fuelSlotStack);
                        if (!this.f_19853_.m_5776_()) {
                            fuelSlotStack.m_41721_(fuelSlotStack.m_41773_() + 1);
                        }
                    }
                } else {
                    this.setStatusCurrentActiveFuel(this.GetItemBurnTime(fuelSlotStack));
                    this.currentTotalFuel = this.GetItemBurnTime(fuelSlotStack);
                    if (!this.f_19853_.m_5776_()) {
                        this.inventory.extractItem(this.ItemslotFuel, 1, false);
                    }
                }
            }
        }
    }

    public void OverallFuelSystem() {
        if (!this.inventory.getStackInSlot(this.ItemslotFuel).m_41619_()) {
            if (this.inventory.getStackInSlot(this.ItemslotFuel).m_41720_() instanceof ItemMachineBattery) {
                ItemStack battery = this.inventory.getStackInSlot(this.ItemslotFuel);
                this.setStatusOverallActiveFuel(this.getStatusCurrentActiveFuel() + (battery.m_41776_() - battery.m_41773_()) * this.GetItemBurnTime(this.inventory.getStackInSlot(this.ItemslotFuel)));
                this.overallTotalFuel = this.currentTotalFuel + battery.m_41776_() * this.GetItemBurnTime(this.inventory.getStackInSlot(this.ItemslotFuel));
                this.stacksizeOfFuelSlot = battery.m_41773_();
            } else {
                this.setStatusOverallActiveFuel(this.getStatusCurrentActiveFuel() + this.inventory.getStackInSlot(this.ItemslotFuel).m_41613_() * this.GetItemBurnTime(this.inventory.getStackInSlot(this.ItemslotFuel)));
                this.overallTotalFuel = this.currentTotalFuel + 64 * this.GetItemBurnTime(this.inventory.getStackInSlot(this.ItemslotFuel));
                this.stacksizeOfFuelSlot = this.inventory.getStackInSlot(this.ItemslotFuel).m_41613_();
            }
        } else {
            this.setStatusOverallActiveFuel(this.getStatusCurrentActiveFuel());
            this.overallTotalFuel = this.currentTotalFuel;
            this.stacksizeOfFuelSlot = 0;
        }
    }

    public int GetItemBurnTime(ItemStack stack) {
        int fuelamount = 0;
        if (!this.inventory.getStackInSlot(this.ItemslotFuel).m_41619_()) {
            Item item = this.inventory.getStackInSlot(this.ItemslotFuel).m_41720_();
            if (item == Items.f_42413_) {
                fuelamount = (Integer)VCMCommonConfig.FUEL_BURNTIME_COAL.get();
            }
            if (item == Items.f_42414_) {
                fuelamount = (Integer)VCMCommonConfig.FUEL_BURNTIME_CHARCOAL.get();
            }
            if (item == InitItemsVCM.FUEL_MACHINE_PELLET.get()) {
                fuelamount = (Integer)VCMCommonConfig.FUEL_BURNTIME_MACHINEPELLET.get();
            }
            if (item == InitItemsVCM.FUEL_MACHINE_BATTERY.get()) {
                fuelamount = (Integer)VCMCommonConfig.CHARGE_BURNTIME_MACHINEBATTERY.get();
            }
        }
        return fuelamount;
    }

    public boolean IsBurningFuel() {
        if (this.getStatusPowered() && this.getStatusCurrentActiveFuel() > 0) {
            return true;
        }
        return !this.IsFuelNeeded();
    }

    public boolean IsItemFuel(ItemStack stack) {
        return this.GetItemBurnTime(stack) > 0;
    }

    public boolean PoweredAndHasFuel() {
        return this.IsBurningFuel() && this.getStatusPowered();
    }

    @Override
    public void setStatusCurrentActiveFuel(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_CURRENTACTIVEFUEL, (Object)valueIn);
    }

    @Override
    public int getStatusCurrentActiveFuel() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_CURRENTACTIVEFUEL);
    }

    @Override
    public void setStatusOverallActiveFuel(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_OVERALLACTIVEFUEL, (Object)valueIn);
    }

    @Override
    public int getStatusOverallActiveFuel() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_OVERALLACTIVEFUEL);
    }

    @Override
    public void setStatusBroken(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_BROKEN, (Object)valueIn);
    }

    @Override
    public boolean getStatusBroken() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_BROKEN);
    }

    @Override
    public void setStatusPowered(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_POWERED, (Object)valueIn);
    }

    @Override
    public boolean getStatusPowered() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_POWERED);
    }

    @Override
    public void setStatusAutorun(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_AUTORUN, (Object)valueIn);
    }

    @Override
    public boolean getStatusAutorun() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_AUTORUN);
    }

    public void setStatusVeryBrokenCounter(int valueIn) {
        this.f_19804_.m_135381_(DATA_ID_VERYBROKENCOUNTER, (Object)valueIn);
    }

    public int getStatusVeryBrokenCounter() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_VERYBROKENCOUNTER);
    }

    @Override
    public void setStatusTurboActivated(boolean valueIn) {
        this.f_19804_.m_135381_(DATA_ID_TURBOACTIVATED, (Object)valueIn);
    }

    @Override
    public boolean getStatusTurboActivated() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_TURBOACTIVATED);
    }
}

