/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.culllessleaves.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLPaths;

public class CullLessLeavesConfig {
    public static final CullLessLeavesConfig INSTANCE = new CullLessLeavesConfig();
    public final Path configFile = FMLPaths.CONFIGDIR.get().resolve("cull-less-leaves.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public boolean enabled = true;
    public int depth = 2;

    public void save() {
        try {
            Files.deleteIfExists(this.configFile);
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("depth", (Number)this.depth);
            Files.writeString(this.configFile, (CharSequence)this.gson.toJson((JsonElement)json), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            if (Files.notExists(this.configFile, new LinkOption[0])) {
                this.save();
                return;
            }
            JsonObject json = (JsonObject)this.gson.fromJson(Files.readString(this.configFile), JsonObject.class);
            if (json.has("enabled")) {
                this.enabled = json.getAsJsonPrimitive("enabled").getAsBoolean();
            }
            if (json.has("depth")) {
                this.depth = json.getAsJsonPrimitive("depth").getAsInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

