/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server.handler.plugins;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.level.ServerPlayer;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.server.handler.HandlerPlugin;
import top.seraphjack.simplelogin.server.handler.Login;
import top.seraphjack.simplelogin.server.storage.SLStorage;

public final class AutoSave
implements HandlerPlugin {
    private ScheduledFuture<?> future;

    @Override
    public void enable(ScheduledExecutorService executor) {
        this.future = executor.scheduleAtFixedRate(() -> {
            if (SLStorage.instance().storageProvider.dirty()) {
                SimpleLogin.logger.info("Auto saving entries");
                long start = System.currentTimeMillis();
                try {
                    SLStorage.instance().storageProvider.save();
                }
                catch (IOException e) {
                    SimpleLogin.logger.error("Failed saving simple login entries", (Throwable)e);
                }
                SimpleLogin.logger.info("Done! Took " + (System.currentTimeMillis() - start) + "ms.");
            }
        }, 0L, 5L, TimeUnit.MINUTES);
    }

    @Override
    public void preLogin(ServerPlayer player, Login login) {
    }

    @Override
    public void postLogin(ServerPlayer player, Login login) {
    }

    @Override
    public void preLogout(ServerPlayer player) {
    }

    @Override
    public void disable() {
        this.future.cancel(true);
    }
}

