/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils;

import fuzs.easyanvils.config.ClientConfig;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.handler.ItemInteractionHandler;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.network.S2CAnvilRepairMessage;
import fuzs.easyanvils.network.S2COpenNameTagEditorMessage;
import fuzs.easyanvils.network.client.C2SNameTagUpdateMessage;
import fuzs.easyanvils.network.client.C2SRenameItemMessage;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.ModLifecycleContext;
import fuzs.puzzleslib.api.event.v1.entity.player.AnvilRepairCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyAnvils
implements ModConstructor {
    public static final String MOD_ID = "easyanvils";
    public static final String MOD_NAME = "Easy Anvils";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Easy Anvils");
    public static final NetworkHandlerV2 NETWORK = NetworkHandlerV2.build((String)"easyanvils");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"easyanvils").client(ClientConfig.class).server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        EasyAnvils.registerMessages();
        EasyAnvils.registerHandlers();
    }

    private static void registerHandlers() {
        PlayerInteractEvents.USE_ITEM.register(ItemInteractionHandler::onUseItem);
        PlayerInteractEvents.USE_BLOCK.register(ItemInteractionHandler::onUseBlock);
        AnvilRepairCallback.EVENT.register(ItemInteractionHandler::onAnvilRepair);
    }

    private static void registerMessages() {
        NETWORK.register(S2COpenNameTagEditorMessage.class, S2COpenNameTagEditorMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(C2SNameTagUpdateMessage.class, C2SNameTagUpdateMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(S2CAnvilRepairMessage.class, S2CAnvilRepairMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(C2SRenameItemMessage.class, C2SRenameItemMessage::new, MessageDirection.TO_SERVER);
    }

    public void onCommonSetup(ModLifecycleContext context) {
        context.enqueueWork(() -> DispenserBlock.m_52672_((ItemLike)Items.f_41913_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).anvilRepairing) {
                    return super.m_7498_(source, stack);
                }
                Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos pos = source.m_7961_().m_121945_(direction);
                ServerLevel level = source.m_7727_();
                BlockState state = level.m_8055_(pos);
                this.m_123573_(true);
                if (state.m_204336_(BlockTags.f_13033_)) {
                    if (ItemInteractionHandler.tryRepairAnvil((Level)level, pos, state)) {
                        stack.m_41774_(1);
                    } else {
                        this.m_123573_(false);
                    }
                    return stack;
                }
                return super.m_7498_(source, stack);
            }
        }));
    }
}

