/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.rendering.model;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;

public class ModelRenderUtil {
    public static Vec3[] createQuadVerts(Direction face, double leftEdge, double rightEdge, double elevation) {
        Vec3[] vec3Array;
        switch (face) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DOWN: {
                Vec3[] vec3Array2 = new Vec3[4];
                vec3Array2[0] = new Vec3(leftEdge, 1.0 - elevation, leftEdge);
                vec3Array2[1] = new Vec3(rightEdge, 1.0 - elevation, leftEdge);
                vec3Array2[2] = new Vec3(rightEdge, 1.0 - elevation, rightEdge);
                vec3Array = vec3Array2;
                vec3Array2[3] = new Vec3(leftEdge, 1.0 - elevation, rightEdge);
                break;
            }
            case UP: {
                Vec3[] vec3Array3 = new Vec3[4];
                vec3Array3[0] = new Vec3(leftEdge, elevation, leftEdge);
                vec3Array3[1] = new Vec3(leftEdge, elevation, rightEdge);
                vec3Array3[2] = new Vec3(rightEdge, elevation, rightEdge);
                vec3Array = vec3Array3;
                vec3Array3[3] = new Vec3(rightEdge, elevation, leftEdge);
                break;
            }
            case NORTH: {
                Vec3[] vec3Array4 = new Vec3[4];
                vec3Array4[0] = new Vec3(rightEdge, rightEdge, 1.0 - elevation);
                vec3Array4[1] = new Vec3(rightEdge, leftEdge, 1.0 - elevation);
                vec3Array4[2] = new Vec3(leftEdge, leftEdge, 1.0 - elevation);
                vec3Array = vec3Array4;
                vec3Array4[3] = new Vec3(leftEdge, rightEdge, 1.0 - elevation);
                break;
            }
            case SOUTH: {
                Vec3[] vec3Array5 = new Vec3[4];
                vec3Array5[0] = new Vec3(leftEdge, rightEdge, elevation);
                vec3Array5[1] = new Vec3(leftEdge, leftEdge, elevation);
                vec3Array5[2] = new Vec3(rightEdge, leftEdge, elevation);
                vec3Array = vec3Array5;
                vec3Array5[3] = new Vec3(rightEdge, rightEdge, elevation);
                break;
            }
            case WEST: {
                Vec3[] vec3Array6 = new Vec3[4];
                vec3Array6[0] = new Vec3(1.0 - elevation, rightEdge, leftEdge);
                vec3Array6[1] = new Vec3(1.0 - elevation, leftEdge, leftEdge);
                vec3Array6[2] = new Vec3(1.0 - elevation, leftEdge, rightEdge);
                vec3Array = vec3Array6;
                vec3Array6[3] = new Vec3(1.0 - elevation, rightEdge, rightEdge);
                break;
            }
            case EAST: {
                Vec3[] vec3Array7 = new Vec3[4];
                vec3Array7[0] = new Vec3(elevation, rightEdge, rightEdge);
                vec3Array7[1] = new Vec3(elevation, leftEdge, rightEdge);
                vec3Array7[2] = new Vec3(elevation, leftEdge, leftEdge);
                vec3Array = vec3Array7;
                vec3Array7[3] = new Vec3(elevation, rightEdge, leftEdge);
            }
        }
        return vec3Array;
    }

    public static BakedQuad createQuad(Vec3[] verts, TextureAtlasSprite sprite) {
        return ModelRenderUtil.createQuad(verts[0], verts[1], verts[2], verts[3], sprite);
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite) {
        return ModelRenderUtil.createQuad(v1, v2, v3, v4, sprite, 0xFFFFFF, 1.0f);
    }

    public static BakedQuad createQuad(Vec3[] verts, TextureAtlasSprite sprite, int color) {
        return ModelRenderUtil.createQuad(verts[0], verts[1], verts[2], verts[3], sprite, color, 1.0f);
    }

    public static BakedQuad createQuad(Vec3[] verts, TextureAtlasSprite sprite, int color, float alpha) {
        return ModelRenderUtil.createQuad(verts[0], verts[1], verts[2], verts[3], sprite, color, alpha);
    }

    public static BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite, int color, float alpha) {
        Vec3 normal = v3.m_82546_(v2).m_82537_(v1.m_82546_(v2)).m_82541_();
        float nx = (float)normal.f_82479_;
        float ny = (float)normal.f_82480_;
        float nz = (float)normal.f_82481_;
        int tw = sprite.m_245424_().m_246492_();
        int th = sprite.m_245424_().m_245330_();
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        BakedQuad[] quad = new BakedQuad[1];
        QuadBakingVertexConsumer baker = new QuadBakingVertexConsumer(q -> {
            quad[0] = q;
        });
        baker.setSprite(sprite);
        baker.setDirection(Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_));
        baker.m_5601_(nx, ny, nz).m_5483_(v1.f_82479_, v1.f_82480_, v1.f_82481_).m_7421_(sprite.m_118367_(0.0), sprite.m_118393_(0.0)).m_85950_(r, g, b, alpha).m_5752_();
        baker.m_5601_(nx, ny, nz).m_5483_(v2.f_82479_, v2.f_82480_, v2.f_82481_).m_7421_(sprite.m_118367_(0.0), sprite.m_118393_((double)th)).m_85950_(r, g, b, alpha).m_5752_();
        baker.m_5601_(nx, ny, nz).m_5483_(v3.f_82479_, v3.f_82480_, v3.f_82481_).m_7421_(sprite.m_118367_((double)tw), sprite.m_118393_((double)th)).m_85950_(r, g, b, alpha).m_5752_();
        baker.m_5601_(nx, ny, nz).m_5483_(v4.f_82479_, v4.f_82480_, v4.f_82481_).m_7421_(sprite.m_118367_((double)tw), sprite.m_118393_(0.0)).m_85950_(r, g, b, alpha).m_5752_();
        return quad[0];
    }
}

