/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.base.common.util.ExperienceUtil;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.io.fluid.MachineFluidHandler;
import com.enderio.machines.common.io.fluid.MachineFluidTank;
import com.enderio.machines.common.io.fluid.MachineTankLayout;
import com.enderio.machines.common.io.fluid.TankAccess;
import com.enderio.machines.common.menu.XPObeliskMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class XPObeliskBlockEntity
extends MachineBlockEntity {
    IntegerNetworkDataSlot xpTankDataSlot = new IntegerNetworkDataSlot(() -> TANK.getFluidAmount(this), amount -> TANK.setFluid(this, new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), amount.intValue())));
    private static final TankAccess TANK = new TankAccess();

    public XPObeliskBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.addDataSlot(this.xpTankDataSlot);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new XPObeliskMenu(this, playerInventory, containerId);
    }

    @Override
    @Nullable
    public MachineTankLayout getTankLayout() {
        return new MachineTankLayout.Builder().tank(TANK, Integer.MAX_VALUE, fluidStack -> fluidStack.getFluid().m_205067_(EIOTags.Fluids.EXPERIENCE)).build();
    }

    @Override
    @Nullable
    protected MachineFluidHandler createFluidHandler(MachineTankLayout layout) {
        return new MachineFluidHandler(this.getIOConfig(), this.getTankLayout()){

            @Override
            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                XPObeliskBlockEntity.this.m_6596_();
            }

            @Override
            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (TANK.isFluidValid(this, resource)) {
                    Fluid currentFluid = TANK.getFluid(this).getFluid();
                    if (currentFluid == Fluids.f_76191_ || resource.getFluid().m_6212_(currentFluid)) {
                        return super.fill(resource, action);
                    }
                    return super.fill(new FluidStack(currentFluid, resource.getAmount()), action);
                }
                return 0;
            }
        };
    }

    public MachineFluidTank getFluidTank() {
        return TANK.getTank(this);
    }

    public void addLevelToPlayer(int levelDiff, Player player) {
        int requestedLevel = player.f_36078_ + levelDiff;
        requestedLevel = Math.max(requestedLevel, 0);
        long playerXP = ExperienceUtil.getPlayerTotalXp(player);
        long requestedXP = ExperienceUtil.getTotalXpFromLevel(requestedLevel) - playerXP;
        int storedXP = TANK.getFluidAmount(this) / ExperienceUtil.EXP_TO_FLUID;
        long awardXP = levelDiff > 0 ? Math.min((long)storedXP, requestedXP) : requestedXP;
        this.awardXP(awardXP, player);
    }

    public void addAllLevelToPlayer(boolean give, Player player) {
        long awardXP = 0L;
        awardXP = give ? (long)(TANK.getFluidAmount(this) / ExperienceUtil.EXP_TO_FLUID) : -ExperienceUtil.getPlayerTotalXp(player);
        this.awardXP(awardXP, player);
    }

    public void awardXP(long exp, Player player) {
        long volumeToRemove = exp * (long)ExperienceUtil.EXP_TO_FLUID;
        if (volumeToRemove > 0L) {
            int cappedVolume = (int)Math.min(Integer.MAX_VALUE, volumeToRemove);
            FluidStack drained = TANK.drain((MachineBlockEntity)this, cappedVolume, IFluidHandler.FluidAction.EXECUTE);
            player.m_6756_(drained.getAmount() / ExperienceUtil.EXP_TO_FLUID);
        } else {
            int cappedVolume = (int)Math.min(Integer.MAX_VALUE, -volumeToRemove);
            int filled = TANK.fill(this, new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), cappedVolume), IFluidHandler.FluidAction.EXECUTE);
            player.m_6756_(-1 * filled / ExperienceUtil.EXP_TO_FLUID);
        }
    }
}

