/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui.widget;

import appeng.client.gui.AEBaseScreen;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.scene.CameraSettings;
import appeng.client.guidebook.scene.GuidebookLevelRenderer;
import appeng.client.guidebook.scene.GuidebookScene;
import appeng.client.guidebook.scene.level.GuidebookLevel;
import com.glodblock.github.extendedae.util.Ae2ReflectClient;
import com.glodblock.github.glodium.util.GlodUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class WorldDisplay
extends AbstractWidget {
    private final AEBaseScreen<?> addedOn;
    private float zoom = 2.0f;
    private GuidebookScene scene;
    private boolean ready;
    @NotNull
    private static final Level clientWorld;
    private static final GuidebookLevelRenderer worldRender;
    private LytRect bounds;

    public WorldDisplay(AEBaseScreen<?> addedOn, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.addedOn = addedOn;
        this.ready = false;
    }

    public void unload() {
        this.ready = false;
    }

    public void locate(BlockPos blockPos) {
        this.zoom = 2.0f;
        this.ready = false;
        BlockState block = clientWorld.m_8055_(blockPos);
        BlockEntity te = clientWorld.m_7702_(blockPos);
        if (block.m_60795_() || te == null) {
            return;
        }
        this.scene = new GuidebookScene(new GuidebookLevel(), new CameraSettings());
        ServerLevelAccessor wrap = Ae2ReflectClient.getFakeServerWorld((LevelAccessor)this.scene.getLevel());
        assert (wrap != null);
        Vec3i sizeX = new Vec3i(3, 1, 1);
        Vec3i sizeY = new Vec3i(1, 3, 1);
        Vec3i sizeZ = new Vec3i(1, 1, 3);
        BlockPos startX = BlockPos.f_121853_.m_7918_(0, 1, 1);
        BlockPos startY = BlockPos.f_121853_.m_7918_(1, 0, 1);
        BlockPos startZ = BlockPos.f_121853_.m_7918_(1, 1, 0);
        StructureTemplate tmp = new StructureTemplate();
        StructurePlaceSettings settings = new StructurePlaceSettings();
        SingleThreadedRandomSource random = new SingleThreadedRandomSource(0L);
        settings.m_74392_(true);
        tmp.m_163802_(clientWorld, blockPos.m_7918_(-1, 0, 0), sizeX, false, Blocks.f_50016_);
        tmp.m_230328_(wrap, startX, BlockPos.f_121853_, settings, (RandomSource)random, 0);
        tmp = new StructureTemplate();
        tmp.m_163802_(clientWorld, blockPos.m_7918_(0, -1, 0), sizeY, false, Blocks.f_50016_);
        tmp.m_230328_(wrap, startY, BlockPos.f_121853_, settings, (RandomSource)random, 0);
        tmp = new StructureTemplate();
        tmp.m_163802_(clientWorld, blockPos.m_7918_(0, 0, -1), sizeZ, false, Blocks.f_50016_);
        tmp.m_230328_(wrap, startZ, BlockPos.f_121853_, settings, (RandomSource)random, 0);
        this.scene.getCameraSettings().setRotationCenter(this.scene.getWorldCenter());
        this.scene.getCameraSettings().setZoom(this.zoom);
        this.bounds = new LytRect(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        this.scene.getCameraSettings().setViewportSize(this.bounds.size());
        this.scene.centerScene();
        this.ready = true;
    }

    public void refreshBounds() {
        this.bounds = new LytRect(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
    }

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.ready) {
            if (this.m_5953_(mouseX, mouseY)) {
                this.addedOn.m_7522_((GuiEventListener)this);
            }
            Window window = Minecraft.m_91087_().m_91268_();
            LytRect viewport = this.bounds.transform(guiGraphics.m_280168_().m_85850_().m_252922_());
            RenderSystem.viewport((int)((int)((double)viewport.x() * window.m_85449_())), (int)((int)((double)window.m_85442_() - (double)viewport.bottom() * window.m_85449_())), (int)((int)((double)viewport.width() * window.m_85449_())), (int)((int)((double)viewport.height() * window.m_85449_())));
            guiGraphics.m_280588_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_);
            worldRender.render(this.scene.getLevel(), this.scene.getCameraSettings(), Collections.emptyList());
            guiGraphics.m_280618_();
            RenderSystem.viewport((int)0, (int)0, (int)window.m_85441_(), (int)window.m_85442_());
        }
    }

    protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.f_93624_ && this.ready && this.m_5953_(pMouseX, pMouseY)) {
            float dx = (float)pDragX;
            float dy = (float)pDragY;
            CameraSettings camera = this.scene.getCameraSettings();
            if (pButton == 0) {
                camera.setRotationY(camera.getRotationY() + dx);
                camera.setRotationX(camera.getRotationX() + dy);
            } else if (pButton == 1) {
                camera.setOffsetX(camera.getOffsetX() + dx);
                camera.setOffsetY(camera.getOffsetY() - dy);
            }
        }
        return false;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.f_93624_ && this.ready && this.m_5953_(pMouseX, pMouseY)) {
            this.zoom = (float)GlodUtil.clamp((double)((double)this.zoom + pDelta / 5.0), (double)0.5, (double)10.0);
            this.scene.getCameraSettings().setZoom(this.zoom);
            return true;
        }
        return false;
    }

    static {
        worldRender = GuidebookLevelRenderer.getInstance();
        assert (Minecraft.m_91087_().f_91073_ != null);
        clientWorld = Minecraft.m_91087_().f_91073_;
    }
}

