/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Reflection {
    public static Object getPrivateField(Object targetObj, String fieldName) throws Exception {
        Field fld = null;
        for (Class<?> cls = targetObj.getClass(); cls != null; cls = cls.getSuperclass()) {
            try {
                fld = cls.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (fld == null) {
            throw new NoSuchFieldException();
        }
        fld.setAccessible(true);
        return fld.get(targetObj);
    }

    public static void setPrivateField(Object targetObj, String fieldName, Object value) throws Exception {
        Field fld = null;
        for (Class<?> cls = targetObj.getClass(); cls != null; cls = cls.getSuperclass()) {
            try {
                fld = cls.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (fld == null) {
            throw new NoSuchFieldException();
        }
        fld.setAccessible(true);
        fld.set(targetObj, value);
    }

    public static Object getField(Object targetObj, String fieldName) throws Exception {
        Class<?> cls = targetObj.getClass();
        Field fld = cls.getField(fieldName);
        fld.setAccessible(true);
        return fld.get(targetObj);
    }

    public static void setField(Object targetObj, String fieldName, Object value) throws Exception {
        Class<?> cls = targetObj.getClass();
        Field fld = cls.getField(fieldName);
        fld.setAccessible(true);
        fld.set(targetObj, value);
    }

    public static boolean hasClassMethod(String classPath, String methodName, Class<?> ... paramTypes) {
        Class<?> cls;
        try {
            cls = Class.forName(classPath);
        }
        catch (Exception e) {
            return false;
        }
        try {
            Method e = cls.getDeclaredMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean hasClassField(String classPath, String fieldName) {
        Class<?> cls;
        try {
            cls = Class.forName(classPath);
        }
        catch (Exception e) {
            return false;
        }
        try {
            Field e = cls.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

