/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.data;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class FramedBlockData {
    public static final ModelProperty<FramedBlockData> PROPERTY = new ModelProperty();
    public static final ModelProperty<ModelData> CAMO_DATA = new ModelProperty();
    protected final boolean[] hidden = new boolean[6];
    protected BlockState camoState = Blocks.f_50016_.m_49966_();
    protected boolean altModel = false;
    protected boolean reinforced = false;

    public void setCamoState(BlockState camoState) {
        this.camoState = camoState;
    }

    public void setSideHidden(Direction side, boolean hide) {
        this.hidden[side.ordinal()] = hide;
    }

    public void setUseAltModel(boolean altModel) {
        this.altModel = altModel;
    }

    public void setReinforced(boolean reinforced) {
        this.reinforced = reinforced;
    }

    public BlockState getCamoState() {
        return this.camoState;
    }

    public boolean isSideHidden(Direction side) {
        return this.hidden[side.ordinal()];
    }

    public boolean useAltModel() {
        return this.altModel;
    }

    public boolean isReinforced() {
        return this.reinforced;
    }

    public static final class Immutable
    extends FramedBlockData {
        public Immutable(BlockState camoState, boolean[] hidden, boolean altModel) {
            this.camoState = camoState;
            System.arraycopy(hidden, 0, this.hidden, 0, this.hidden.length);
            this.altModel = altModel;
        }

        @Override
        public void setCamoState(BlockState camoState) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public void setSideHidden(Direction side, boolean hide) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public void setUseAltModel(boolean altModel) {
            throw new UnsupportedOperationException("Immutable");
        }

        @Override
        public void setReinforced(boolean reinforced) {
            throw new UnsupportedOperationException("Immutable");
        }
    }
}

