/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.loader.overlay;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.joml.Vector3f;
import xfacthd.framedblocks.client.loader.overlay.OverlayLoader;

public final class OverlayLoaderBuilder
extends CustomLoaderBuilder<BlockModelBuilder> {
    private BlockModelBuilder model;
    private Vector3f center;

    public OverlayLoaderBuilder(BlockModelBuilder parent, ExistingFileHelper fileHelper) {
        super(OverlayLoader.ID, (ModelBuilder)parent, fileHelper);
    }

    public OverlayLoaderBuilder model(BlockModelBuilder model) {
        Preconditions.checkState((this.model == null ? 1 : 0) != 0, (Object)"Model already set");
        this.model = model;
        return this;
    }

    public OverlayLoaderBuilder center(Vector3f center) {
        Preconditions.checkState((this.center == null ? 1 : 0) != 0, (Object)"Center vector already set");
        this.center = center;
        return this;
    }

    public JsonObject toJson(JsonObject json) {
        Preconditions.checkState((this.model != null ? 1 : 0) != 0, (Object)"Model not set");
        json.add("model", (JsonElement)this.model.toJson());
        if (this.center != null) {
            JsonArray centerArr = new JsonArray(3);
            centerArr.add((Number)Float.valueOf(this.center.x()));
            centerArr.add((Number)Float.valueOf(this.center.y()));
            centerArr.add((Number)Float.valueOf(this.center.z()));
            json.add("center", (JsonElement)centerArr);
        }
        return super.toJson(json);
    }
}

