/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public class FramedLatticeModel
extends FramedBlockModel {
    private static final float MIN_COORD = 0.375f;
    private static final float MAX_COORD = 0.625f;
    private static final float MIN_COORD_THICK = 0.25f;
    private static final float MAX_COORD_THICK = 0.75f;
    private final boolean xAxis;
    private final boolean yAxis;
    private final boolean zAxis;
    private final float minCoord;
    private final float maxCoord;

    public FramedLatticeModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.xAxis = (Boolean)state.m_61143_((Property)FramedProperties.X_AXIS);
        this.yAxis = (Boolean)state.m_61143_((Property)FramedProperties.Y_AXIS);
        this.zAxis = (Boolean)state.m_61143_((Property)FramedProperties.Z_AXIS);
        boolean thick = state.m_60734_() == FBContent.BLOCK_FRAMED_THICK_LATTICE.get();
        this.minCoord = thick ? 0.25f : 0.375f;
        this.maxCoord = thick ? 0.75f : 0.625f;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quadDir)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.minCoord, this.minCoord, this.maxCoord, this.maxCoord)).applyIf(Modifiers.setPosition(this.maxCoord), !this.yAxis).export(quadMap.get(this.yAxis ? quadDir : null));
            if (this.xAxis) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.0f, this.minCoord, this.minCoord, this.maxCoord)).apply(Modifiers.setPosition(this.maxCoord)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.maxCoord, this.minCoord, 1.0f, this.maxCoord)).apply(Modifiers.setPosition(this.maxCoord)).export(quadMap.get(null));
            }
            if (this.zAxis) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.minCoord, 0.0f, this.maxCoord, this.minCoord)).apply(Modifiers.setPosition(this.maxCoord)).export(quadMap.get(null));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.minCoord, this.maxCoord, this.maxCoord, 1.0f)).apply(Modifiers.setPosition(this.maxCoord)).export(quadMap.get(null));
            }
        } else if (Utils.isX(quadDir)) {
            this.createHorizontalStrutSideQuads(quadMap, quad, this.xAxis, this.zAxis);
        } else if (Utils.isZ(quadDir)) {
            this.createHorizontalStrutSideQuads(quadMap, quad, this.zAxis, this.xAxis);
        }
        if (!Utils.isY(quadDir) && this.yAxis) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(this.minCoord, 0.0f, this.maxCoord, this.minCoord)).apply(Modifiers.setPosition(this.maxCoord)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(this.minCoord, this.maxCoord, this.maxCoord, 1.0f)).apply(Modifiers.setPosition(this.maxCoord)).export(quadMap.get(null));
        }
    }

    private void createHorizontalStrutSideQuads(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, boolean frontAxis, boolean sideAxis) {
        QuadModifier.geometry(quad).apply(Modifiers.cutSide(this.minCoord, this.minCoord, this.maxCoord, this.maxCoord)).applyIf(Modifiers.setPosition(this.maxCoord), !frontAxis).export(quadMap.get(frontAxis ? quad.m_111306_() : null));
        if (sideAxis) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.0f, this.minCoord, this.minCoord, this.maxCoord)).apply(Modifiers.setPosition(this.maxCoord)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(this.maxCoord, this.minCoord, 1.0f, this.maxCoord)).apply(Modifiers.setPosition(this.maxCoord)).export(quadMap.get(null));
        }
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }
}

