/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc;

import igentuman.nc.handler.command.CommandNcPlayerRadiation;
import igentuman.nc.handler.command.CommandNcVeinCheck;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.handler.config.FusionConfig;
import igentuman.nc.handler.config.MaterialsConfig;
import igentuman.nc.handler.config.ProcessorsConfig;
import igentuman.nc.handler.config.RadiationConfig;
import igentuman.nc.handler.config.TurbineConfig;
import igentuman.nc.handler.config.WorldConfig;
import igentuman.nc.handler.event.server.WorldEvents;
import igentuman.nc.network.PacketHandler;
import igentuman.nc.radiation.data.PlayerRadiation;
import igentuman.nc.radiation.data.RadiationEvents;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.radiation.data.WorldRadiation;
import igentuman.nc.setup.ClientSetup;
import igentuman.nc.setup.ModSetup;
import igentuman.nc.setup.Registration;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.GameShuttingDownEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="nuclearcraft")
public class NuclearCraft {
    public static final Logger LOGGER = LogManager.getLogger();
    public boolean isNcBeStopped = false;
    public static final WorldEvents worldTickHandler = new WorldEvents();
    public static final String MODID = "nuclearcraft";
    public static NuclearCraft instance;
    private final PacketHandler packetHandler;

    private void forceLoadConfig() {
        try {
            Method openConfig = ConfigTracker.INSTANCE.getClass().getDeclaredMethod("openConfig", ModConfig.class, Path.class);
            openConfig.setAccessible(true);
            Field configSets = ConfigTracker.INSTANCE.getClass().getDeclaredField("configSets");
            configSets.setAccessible(true);
            EnumMap configSetsValue = (EnumMap)configSets.get(ConfigTracker.INSTANCE);
            ModConfig ncConfig = null;
            for (ModConfig config : (Set)configSetsValue.get(ModConfig.Type.COMMON)) {
                if (!config.getModId().equals(MODID)) continue;
                ncConfig = config;
                break;
            }
            openConfig.invoke((Object)ConfigTracker.INSTANCE, ncConfig, FMLPaths.CONFIGDIR.get());
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Unable to force load NC config. And this is why:");
            LOGGER.error((Object)e);
        }
    }

    public static void registerConfigs() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MaterialsConfig.spec, "NuclearCraft/materials.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.spec, "NuclearCraft/common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ProcessorsConfig.spec, "NuclearCraft/processors.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FissionConfig.spec, "NuclearCraft/fission.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FusionConfig.spec, "NuclearCraft/fusion.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TurbineConfig.spec, "NuclearCraft/turbine.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RadiationConfig.spec, "NuclearCraft/radiation.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WorldConfig.spec, "NuclearCraft/world.toml");
    }

    public NuclearCraft() {
        instance = this;
        NuclearCraft.registerConfigs();
        this.packetHandler = new PacketHandler();
        this.forceLoadConfig();
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::gameShuttingDownEvent);
        ModSetup.setup();
        Registration.init();
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        modbus.addListener(ModSetup::init);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modbus.addListener(ClientSetup::init));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modbus.addListener(this::registerClientEventHandlers));
    }

    public static PacketHandler packetHandler() {
        return NuclearCraft.instance.packetHandler;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            CommonConfig.setLoaded();
        }
    }

    private void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(CommandNcPlayerRadiation.register());
        event.getDispatcher().register(CommandNcVeinCheck.register());
    }

    private void registerClientEventHandlers(FMLClientSetupEvent event) {
        ClientSetup.registerEventHandlers(event);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void serverStopped(ServerStoppedEvent event) {
        NuclearCraft.instance.isNcBeStopped = true;
        RadiationEvents.stopTracking();
        for (ServerLevel level : event.getServer().m_129785_()) {
            RadiationManager.clear((Level)level);
        }
    }

    private void gameShuttingDownEvent(GameShuttingDownEvent event) {
        NuclearCraft.instance.isNcBeStopped = true;
    }

    private void serverStarted(ServerStartedEvent event) {
        NuclearCraft.instance.isNcBeStopped = false;
        RadiationEvents.startTracking();
    }

    @SubscribeEvent
    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(WorldRadiation.class);
        event.register(PlayerRadiation.class);
    }
}

