/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.energy.BatteryBE;
import igentuman.nc.block.entity.energy.NCEnergy;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.network.toServer.PacketBatterySideConfig;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.util.TextUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BatteryBlock
extends Block
implements EntityBlock {
    public BatteryBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity be;
        if (!level.m_5776_() && (be = level.m_7702_(pos)) instanceof BatteryBE) {
            BatteryBE batteryBE = (BatteryBE)be;
            if (player.m_21120_(hand).m_41720_().equals(NCItems.MULTITOOL.get())) {
                Direction dirToChange = result.m_82434_();
                if (player.m_6144_()) {
                    dirToChange = dirToChange.m_122424_();
                }
                NuclearCraft.packetHandler().sendToServer(new PacketBatterySideConfig(pos, dirToChange.ordinal()));
            } else {
                player.m_213846_((Component)Component.m_237110_((String)"tooltip.nc.energy_stored", (Object[])new Object[]{this.formatEnergy(batteryBE.energyStorage.getEnergyStored()), this.formatEnergy(batteryBE.energyStorage.getMaxEnergyStored())}).m_130940_(ChatFormatting.BLUE));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.m_60734_() == pNewState.m_60734_() || (blockEntity = pLevel.m_7702_(pPos)) instanceof BatteryBE) {
            // empty if block
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)NCEnergyBlocks.ENERGY_BE.get(this.code()).get()).m_155264_(pPos, pState);
    }

    public String code() {
        return this.m_5456_().toString();
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof NCEnergy) {
                    NCEnergy tile = (NCEnergy)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof NCEnergy) {
                NCEnergy tile = (NCEnergy)t;
                tile.tickServer();
            }
        };
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        if (stack.m_41782_()) {
            BatteryBE tileEntity = (BatteryBE)world.m_7702_(pos);
            CompoundTag nbtData = stack.m_41783_();
            tileEntity.m_142466_(nbtData);
        }
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @javax.annotation.Nullable BlockEntity pBlockEntity, ItemStack pTool) {
        pPlayer.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        pPlayer.m_36399_(0.005f);
        BatteryBE batteryBE = (BatteryBE)pBlockEntity;
        CompoundTag data = batteryBE.m_5995_();
        ItemStack drop = new ItemStack((ItemLike)this);
        drop.m_41751_(data);
        if (!pLevel.m_5776_()) {
            ItemEntity itemEntity = new ItemEntity(pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), drop);
            itemEntity.m_32060_();
            pLevel.m_7967_((Entity)itemEntity);
        }
    }

    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter world, List<Component> list, TooltipFlag flag) {
        int storage = CommonConfig.ENERGY_STORAGE.getCapacityFor(this.m_5456_().toString());
        list.add((Component)Component.m_237110_((String)"tooltip.nc.energy_capacity", (Object[])new Object[]{this.formatEnergy(storage)}).m_130940_(ChatFormatting.BLUE));
        list.add((Component)Component.m_237115_((String)"tooltip.nc.use_multitool").m_130940_(ChatFormatting.YELLOW));
    }

    public String formatEnergy(int energy) {
        if (energy >= 1000000000) {
            return TextUtils.numberFormat(energy / 1000000000) + " GFE";
        }
        if (energy >= 1000000) {
            return TextUtils.numberFormat(energy / 1000000) + " MFE";
        }
        if (energy >= 1000) {
            return TextUtils.numberFormat(energy / 1000) + " kFE";
        }
        return TextUtils.numberFormat(energy) + " FE";
    }
}

