/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity;

import igentuman.nc.block.ISizeToggable;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.content.storage.ContainerBlocks;
import igentuman.nc.handler.ItemStorageCapabilityHandler;
import igentuman.nc.setup.registration.NCStorageBlocks;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class ContainerBE
extends NuclearCraftBE
implements ISizeToggable {
    public final ItemStorageCapabilityHandler inventory;
    protected final LazyOptional<ItemStorageCapabilityHandler> itemHandler;
    public static final ModelProperty<HashMap<Integer, ISizeToggable.SideMode>> SIDE_CONFIG = new ModelProperty();

    private ItemStorageCapabilityHandler createInventory() {
        return new ItemStorageCapabilityHandler(ContainerBlocks.all().get(this.getName()).getCapacity(), 64);
    }

    public LazyOptional<ItemStorageCapabilityHandler> getItemHandler() {
        return this.itemHandler;
    }

    public ContainerBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)NCStorageBlocks.STORAGE_BE.get(ContainerBE.getName(pBlockState)).get(), pPos, pBlockState);
        for (Direction direction : Direction.values()) {
            this.sideConfig.put(direction.ordinal(), ISizeToggable.SideMode.DEFAULT);
        }
        this.inventory = this.createInventory();
        this.itemHandler = LazyOptional.of(() -> this.inventory);
    }

    @Nonnull
    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(SIDE_CONFIG, (Object)this.sideConfig).build();
    }

    public void tickClient() {
    }

    public void tickServer() {
        this.transferItems();
    }

    private void transferItems() {
        for (Direction direction : Direction.values()) {
            BlockEntity be;
            if (this.sideConfig.get(direction.ordinal()) == ISizeToggable.SideMode.DISABLED || this.f_58857_ == null || (be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction))) == null || !be.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).isPresent()) continue;
            be.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).ifPresent(cap -> {
                boolean transactionDone = false;
                block0 : switch ((ISizeToggable.SideMode)((Object)((Object)this.sideConfig.get(direction.ordinal())))) {
                    case OUT: {
                        for (int i = 0; i < this.inventory.getSlots(); ++i) {
                            ItemStack stack = this.inventory.getStackInSlot(i);
                            if (stack.m_41619_()) continue;
                            ItemStack copy = stack.m_41777_();
                            for (int j = 0; j < cap.getSlots(); ++j) {
                                ItemStack left = cap.insertItem(j, copy, true);
                                if (left.m_41613_() >= copy.m_41613_()) continue;
                                cap.insertItem(j, copy, false);
                                this.inventory.extractItem(i, copy.m_41613_() - left.m_41613_(), false);
                                transactionDone = true;
                                break;
                            }
                            if (transactionDone) break block0;
                        }
                        break;
                    }
                    case IN: {
                        for (int i = 0; i < cap.getSlots(); ++i) {
                            ItemStack stack = cap.getStackInSlot(i);
                            if (stack.m_41619_()) continue;
                            ItemStack copy = stack.m_41777_();
                            for (int j = 0; j < this.inventory.getSlots(); ++j) {
                                ItemStack left = this.inventory.insertItem(j, copy, true);
                                if (left.m_41613_() >= copy.m_41613_()) continue;
                                this.inventory.insertItem(j, copy, false);
                                cap.extractItem(i, copy.m_41613_() - left.m_41613_(), false);
                                transactionDone = true;
                                break;
                            }
                            if (transactionDone) break block0;
                        }
                        break;
                    }
                }
            });
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && side != null && this.sideConfig.get(side.ordinal()) != ISizeToggable.SideMode.DISABLED) {
            return this.getItemHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        CompoundTag tank = new CompoundTag();
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128385_("sideConfig", this.sideConfig.values().stream().mapToInt(Enum::ordinal).toArray());
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        if (!tag.m_128441_("sideConfig")) {
            return;
        }
        this.loadSideConfig(tag.m_128465_("sideConfig"));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        if (!tag.m_128441_("sideConfig")) {
            return;
        }
        this.loadSideConfig(tag.m_128465_("sideConfig"));
    }

    private void loadSideConfig(int[] tagData) {
        boolean changed = false;
        for (int i = 0; i < this.sideConfig.size(); ++i) {
            ISizeToggable.SideMode newMode = ISizeToggable.SideMode.values()[tagData[i]];
            if (this.sideConfig.get(i) == newMode) continue;
            changed = true;
            this.sideConfig.remove(i);
            this.sideConfig.put(i, newMode);
        }
        if (changed) {
            this.requestModelDataUpdate();
            if (this.f_58857_ == null) {
                return;
            }
            this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128385_("sideConfig", this.sideConfig.values().stream().mapToInt(Enum::ordinal).toArray());
    }

    @Override
    public ISizeToggable.SideMode toggleSideConfig(int direction) {
        this.sideConfig.put(direction, ISizeToggable.SideMode.values()[(((ISizeToggable.SideMode)((Object)this.sideConfig.get(direction))).ordinal() + 1) % 4]);
        this.m_6596_();
        this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return (ISizeToggable.SideMode)((Object)this.sideConfig.get(direction));
    }

    public String getTier() {
        return this.getName();
    }

    public int getRows() {
        return ContainerBlocks.all().get(this.getName()).getRows();
    }

    public int getColls() {
        return ContainerBlocks.all().get(this.getName()).getColls();
    }
}

