/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.energy;

import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.util.CustomEnergyStorage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class NCEnergy
extends NuclearCraftBE {
    protected String name;
    public static String NAME;
    public final CustomEnergyStorage energyStorage = this.createEnergy();
    protected final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    protected int counter;

    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    protected void sendOutPower() {
        AtomicInteger capacity = new AtomicInteger(this.energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            for (Direction direction : Direction.values()) {
                boolean doContinue;
                BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
                if (be == null || (doContinue = be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).map(handler -> {
                    if (handler.canReceive()) {
                        int received = handler.receiveEnergy(Math.min(capacity.get(), this.getEnergyTransferPerTick()), false);
                        capacity.addAndGet(-received);
                        this.energyStorage.consumeEnergy(received);
                        this.m_6596_();
                        return capacity.get() > 0;
                    }
                    return true;
                }).orElse(true).booleanValue())) continue;
                return;
            }
        }
    }

    protected int getEnergyMaxStorage() {
        return 100;
    }

    protected int getEnergyTransferPerTick() {
        return Math.min(100, this.energyStorage.getEnergyStored());
    }

    private CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(this.getEnergyMaxStorage(), this.getMaxTransfer(), this.getEnergyMaxStorage()){

            @Override
            protected void onEnergyChanged() {
                NCEnergy.this.m_6596_();
            }
        };
    }

    public int getMaxTransfer() {
        return 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public NCEnergy(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, String name) {
        super(pType, pPos, pBlockState);
    }

    public NCEnergy(BlockPos pPos, BlockState pBlockState, String name) {
        super((BlockEntityType)NCEnergyBlocks.ENERGY_BE.get(name).get(), pPos, pBlockState);
        this.name = name;
    }

    public void tickClient() {
    }

    public void tickServer() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.energy.invalidate();
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        this.saveTagData(infoTag);
        tag.m_128365_("Info", (Tag)infoTag);
        tag.m_128365_("energy_storage", this.energyStorage.serializeNBT());
        tag.m_128405_("energy", this.energyStorage.getEnergyStored());
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        if (tag.m_128441_("energy_storage")) {
            this.energyStorage.deserializeNBT(tag.m_128423_("energy_storage"));
        }
        if (tag.m_128441_("energy")) {
            this.energyStorage.setEnergy(tag.m_128451_("energy"));
        }
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        int oldEnergy = this.energyStorage.getEnergyStored();
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
        if (oldEnergy != this.energyStorage.getEnergyStored()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("energy_storage")) {
            this.energyStorage.deserializeNBT(tag.m_128423_("energy_storage"));
        }
        if (tag.m_128441_("energy")) {
            this.energyStorage.setEnergy(tag.m_128451_("energy"));
        }
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("energy_storage", this.energyStorage.serializeNBT());
        tag.m_128405_("energy", this.energyStorage.getEnergyStored());
    }
}

