/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.processor;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.ProcessorBlock;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.compat.cc.NCProcessorPeripheral;
import igentuman.nc.compat.gt.NCGTEnergyHandler;
import igentuman.nc.content.processors.ProcessorPrefab;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.handler.CatalystHandler;
import igentuman.nc.handler.UpgradesHandler;
import igentuman.nc.handler.config.ProcessorsConfig;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.recipes.AbstractRecipe;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.RecipeInfo;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.util.CustomEnergyStorage;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;

public class NCProcessorBE<RECIPE extends AbstractRecipe>
extends NuclearCraftBE {
    public static String NAME;
    public final SidedContentHandler contentHandler;
    protected final CustomEnergyStorage energyStorage;
    public HashMap<String, RECIPE> cachedRecipes = new HashMap();
    public final UpgradesHandler upgradesHandler = this.createUpgradesHandler();
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.upgradesHandler);
    public final CatalystHandler catalystHandler = this.createCatalystHandler();
    protected boolean saveSideMapFlag = true;
    public boolean wasUpdated = true;
    protected RECIPE recipe;
    @NBTField
    public int speedMultiplier = 1;
    @NBTField
    public int energyPerTick = 0;
    @NBTField
    public int energyMultiplier = 1;
    @NBTField
    public int redstoneMode = 0;
    @NBTField
    public boolean isActive = false;
    public int manualUpdateCounter = 40;
    private List<ItemStack> allowedInputs;
    private List<FluidStack> allowedFluids;
    private LazyOptional<NCGTEnergyHandler> gtEnergyCap;
    private ParticleOptions particle1 = ParticleTypes.f_123762_;
    protected final LazyOptional<IEnergyStorage> energy;
    protected ProcessorPrefab prefab;
    protected int skippedTicks = 1;
    public RecipeInfo<RECIPE> recipeInfo = new RecipeInfo();
    private LazyOptional<NCProcessorPeripheral> peripheralCap;

    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    public ProcessorPrefab prefab() {
        if (this.prefab == null) {
            this.prefab = Processors.all().get(this.getName());
        }
        return this.prefab;
    }

    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new NCProcessorPeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    @Override
    public ItemCapabilityHandler getItemInventory() {
        return this.contentHandler.itemHandler;
    }

    protected void updateRecipe() {
        this.recipe = this.getRecipe();
        if (this.recipe != null) {
            this.recipeInfo.setRecipe(this.recipe);
            this.recipeInfo.ticks = (int)((double)this.getBaseProcessTime() * ((AbstractRecipe)this.recipe).getTimeModifier());
            this.recipeInfo.energy = (double)this.getBasePower() * ((AbstractRecipe)this.recipe).getEnergy();
            this.recipeInfo.radiation = ((AbstractRecipe)this.recipeInfo.recipe).getRadiation();
            this.recipeInfo.be = this;
            ((AbstractRecipe)this.recipe).consumeInputs(this.contentHandler);
        }
    }

    protected void addToCache(RECIPE recipe) {
        String key = this.contentHandler.getCacheKey();
        if (this.cachedRecipes.containsKey(key)) {
            this.cachedRecipes.replace(key, recipe);
        } else {
            this.cachedRecipes.put(key, recipe);
        }
    }

    public RECIPE getRecipe() {
        if (this.isInputEmpty()) {
            return null;
        }
        RECIPE cachedRecipe = this.getCachedRecipe();
        if (cachedRecipe != null) {
            return cachedRecipe;
        }
        if (!NcRecipeType.ALL_RECIPES.containsKey(this.getName())) {
            return null;
        }
        for (AbstractRecipe abstractRecipe : NcRecipeType.ALL_RECIPES.get(this.getName()).getRecipeType().getRecipes(this.m_58904_())) {
            if (!abstractRecipe.test(this.contentHandler)) continue;
            this.addToCache(abstractRecipe);
            return (RECIPE)abstractRecipe;
        }
        return null;
    }

    private boolean isInputEmpty() {
        return this.contentHandler.isInputEmpty();
    }

    public RECIPE getCachedRecipe() {
        String key = this.contentHandler.getCacheKey();
        if (this.cachedRecipes.containsKey(key) && ((AbstractRecipe)this.cachedRecipes.get(key)).test(this.contentHandler)) {
            return (RECIPE)((AbstractRecipe)this.cachedRecipes.get(key));
        }
        return null;
    }

    protected int getBaseProcessTime() {
        return this.prefab().config().getTime();
    }

    protected int getBasePower() {
        return this.prefab().config().getPower();
    }

    protected void handleRecipeOutput() {
        if (this.hasRecipe() && this.recipeInfo.isCompleted()) {
            if (((AbstractRecipe)this.recipe).handleOutputs(this.contentHandler)) {
                this.recipeInfo.clear();
            } else {
                this.recipeInfo.stuck = true;
            }
        }
    }

    public double speedMultiplier() {
        if (!this.prefab().supportSpeedUpgrade) {
            return 1.0;
        }
        int id = this.prefab().supportEnergyUpgrade ? 1 : 0;
        this.speedMultiplier = this.upgradesHandler.getStackInSlot(id).m_41613_() + 1;
        return this.speedMultiplier;
    }

    public int energyPerTick() {
        double energy = this.recipe == null ? (double)this.prefab().config().getPower() : ((AbstractRecipe)this.recipe).getEnergy();
        this.energyPerTick = (int)(energy * (double)this.energyMultiplier() * (double)this.prefab().config().getPower());
        return this.energyPerTick;
    }

    public boolean recipeIsStuck() {
        if (this.recipeInfo.isCompleted() || this.recipeInfo.recipe == null) {
            this.handleRecipeOutput();
        }
        return false;
    }

    public boolean hasRecipe() {
        return this.recipeInfo.recipe != null;
    }

    public int getEnergyCapacity() {
        return this.prefab().config().getPower() * 5000;
    }

    protected CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(this.getEnergyCapacity(), 100000, 0){

            @Override
            protected void onEnergyChanged() {
                NCProcessorBE.this.m_6596_();
            }
        };
    }

    protected CatalystHandler createCatalystHandler() {
        return new CatalystHandler(this);
    }

    protected UpgradesHandler createUpgradesHandler() {
        return new UpgradesHandler(this);
    }

    protected boolean gtEUSupported() {
        return (Integer)ProcessorsConfig.PROCESSOR_CONFIG.GT_SUPPORT.get() == 2 || (Integer)ProcessorsConfig.PROCESSOR_CONFIG.GT_SUPPORT.get() == 1;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.contentHandler.getItemCapability(side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.contentHandler.getFluidCapability(side);
        }
        if (cap == ForgeCapabilities.ENERGY && (Integer)ProcessorsConfig.PROCESSOR_CONFIG.GT_SUPPORT.get() != 2) {
            if (this.prefab().config().getPower() > 0) {
                return this.energy.cast();
            }
            return LazyOptional.empty();
        }
        if (ModUtil.isGtLoaded() && this.gtEUSupported() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER) {
            return this.getGTEnergyHandler(cap, side);
        }
        if (ModUtil.isCcLoaded() && cap == dan200.computercraft.shared.Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        if (ModUtil.isMekanismLoadeed()) {
            if (cap == Capabilities.GAS_HANDLER) {
                if (this.contentHandler.hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.contentHandler.gasConverter(side));
                }
                return LazyOptional.empty();
            }
            if (cap == Capabilities.SLURRY_HANDLER) {
                if (this.contentHandler.hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.contentHandler.getSlurryConverter(side));
                }
                return LazyOptional.empty();
            }
        }
        return super.getCapability(cap, side);
    }

    protected <T> LazyOptional<T> getGTEnergyHandler(Capability<T> cap, Direction side) {
        if (this.gtEnergyCap == null) {
            NCGTEnergyHandler handler = new NCGTEnergyHandler(this.energyStorage, (Integer)ProcessorsConfig.PROCESSOR_CONFIG.BASE_POWER.get() / 4, ((Integer)ProcessorsConfig.PROCESSOR_CONFIG.GT_AMPERAGE.get()).intValue());
            this.gtEnergyCap = LazyOptional.of(() -> handler);
        }
        return this.gtEnergyCap.cast();
    }

    public NCProcessorBE(BlockPos pPos, BlockState pBlockState, String name) {
        super((BlockEntityType)NCProcessors.PROCESSORS_BE.get(name).get(), pPos, pBlockState);
        this.prefab = Processors.all().get(name);
        this.contentHandler = new SidedContentHandler(this.prefab().getSlotsConfig().getInputItems(), this.prefab().getSlotsConfig().getOutputItems(), this.prefab().getSlotsConfig().getInputFluids(), this.prefab().getSlotsConfig().getOutputFluids(), new int[0]);
        this.contentHandler.setBlockEntity(this);
        this.energyStorage = this.createEnergy();
        this.energy = LazyOptional.of(() -> this.energyStorage);
    }

    public void tickClient() {
        if (this.isActive && this.f_58857_.m_213780_().m_188503_(50) < 5) {
            BlockPos pos = this.f_58858_;
            Direction direction = this.getFacing();
            Direction.Axis direction$axis = direction.m_122434_();
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = pos.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5;
            double d3 = 0.52;
            double d4 = this.f_58857_.m_213780_().m_188500_() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
            double d6 = this.f_58857_.m_213780_().m_188500_() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
            this.f_58857_.m_7106_(this.particle1, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            this.f_58857_.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public List<ItemStack> getAllowedInputItems() {
        if (this.allowedInputs == null) {
            this.allowedInputs = new ArrayList<ItemStack>();
            for (AbstractRecipe abstractRecipe : NcRecipeType.ALL_RECIPES.get(this.getName()).getRecipeType().getRecipes(this.m_58904_())) {
                for (Ingredient ingredient : abstractRecipe.getItemIngredients()) {
                    this.allowedInputs.addAll(List.of(ingredient.m_43908_()));
                }
            }
        }
        return this.allowedInputs;
    }

    protected int howMuchICanSkip() {
        if (this.energyPerTick() == 0) {
            return (Integer)ProcessorsConfig.PROCESSOR_CONFIG.SKIP_TICKS.get();
        }
        return Math.min(this.energyStorage.getEnergyStored() / this.energyPerTick(), (Integer)ProcessorsConfig.PROCESSOR_CONFIG.SKIP_TICKS.get());
    }

    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        if (this.redstoneMode == 1 && !this.hasRedstoneSignal()) {
            return;
        }
        if (this.howMuchICanSkip() >= this.skippedTicks) {
            ++this.skippedTicks;
            return;
        }
        boolean updated = this.manualUpdate();
        this.contentHandler.setAllowedInputItems(this.getAllowedInputItems());
        for (int i = 0; i < this.prefab().getSlotsConfig().getInputFluids(); ++i) {
            this.contentHandler.setAllowedInputFluids(i, this.getAllowedInputFluids());
        }
        this.processRecipe();
        this.handleRecipeOutput();
        boolean bl = updated = updated || this.contentHandler.tick();
        if (updated || this.wasUpdated) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ProcessorBlock.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)));
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)ProcessorBlock.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)), 3);
        }
        this.skippedTicks = 1;
    }

    public List<FluidStack> getAllowedInputFluids() {
        if (this.allowedFluids == null) {
            this.allowedFluids = new ArrayList<FluidStack>();
            for (NcRecipe ncRecipe : NcRecipeType.ALL_RECIPES.get(this.getName()).getRecipeType().getRecipes(this.m_58904_())) {
                for (FluidStackIngredient ingredient : ncRecipe.getInputFluids()) {
                    this.allowedFluids.addAll(ingredient.getRepresentations());
                }
            }
        }
        return this.allowedFluids;
    }

    private boolean manualUpdate() {
        if (this.manualUpdateCounter > 0) {
            --this.manualUpdateCounter;
            return false;
        }
        this.manualUpdateCounter = 40;
        this.saveSideMapFlag = true;
        this.energyStorage.wasUpdated = true;
        this.upgradesHandler.wasUpdated = true;
        this.catalystHandler.wasUpdated = true;
        return true;
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    protected void processRecipe() {
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (!this.hasRecipe()) {
            this.isActive = false;
            return;
        }
        if (this.energyStorage.getEnergyStored() < this.energyPerTick() * this.skippedTicks) {
            this.isActive = false;
            return;
        }
        this.recipeInfo.process(this.speedMultiplier() * (double)this.skippedTicks);
        if (this.recipeInfo.radiation != 1.0) {
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), this.recipeInfo.radiation / 1000000.0 * this.speedMultiplier() * (double)this.skippedTicks, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        }
        this.isActive = true;
        this.m_6596_();
        if (!this.recipeInfo.isCompleted() && this.hasRecipe()) {
            this.energyStorage.consumeEnergy(this.energyPerTick() * this.skippedTicks);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.wasUpdated = true;
    }

    public int getEnergyUpgrades() {
        if (!this.prefab().supportEnergyUpgrade) {
            return 1;
        }
        return this.upgradesHandler.getStackInSlot(0).m_41613_() + 1;
    }

    public int energyMultiplier() {
        this.energyMultiplier = (int)Math.max(this.speedMultiplier(), Math.pow(this.speedMultiplier() - 1.0, 2.0) + this.speedMultiplier() - Math.pow(this.getEnergyUpgrades(), 2.0));
        return this.energyMultiplier;
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.contentHandler.invalidate();
        this.energy.invalidate();
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
        }
        if (tag.m_128441_("Content")) {
            this.contentHandler.deserializeNBT((Tag)tag.m_128469_("Content"));
        }
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
            if (infoTag.m_128441_("recipeInfo")) {
                this.recipeInfo.deserializeNBT((Tag)infoTag.m_128469_("recipeInfo"));
            }
            if (infoTag.m_128441_("upgrades")) {
                this.upgradesHandler.deserializeNBT((CompoundTag)infoTag.m_128423_("upgrades"));
            }
            if (infoTag.m_128441_("catalyst")) {
                this.catalystHandler.deserializeNBT((CompoundTag)infoTag.m_128423_("catalyst"));
            }
        }
        this.updateRecipeAfterLoad();
        super.m_142466_(tag);
    }

    private void updateRecipeAfterLoad() {
        if (this.recipe == null && this.recipeInfo != null && this.recipeInfo.recipe() != null) {
            this.recipe = this.recipeInfo.recipe();
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.contentHandler.saveSideMap();
        if (!tag.m_128441_("Content")) {
            tag.m_128365_("Content", this.contentHandler.serializeNBT());
        }
        if (!tag.m_128441_("Energy")) {
            tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        }
        CompoundTag infoTag = new CompoundTag();
        this.saveTagData(infoTag);
        infoTag.m_128365_("upgrades", (Tag)this.upgradesHandler.serializeNBT());
        infoTag.m_128365_("catalyst", (Tag)this.catalystHandler.serializeNBT());
        infoTag.m_128365_("recipeInfo", this.recipeInfo.serializeNBT());
        tag.m_128365_("Info", (Tag)infoTag);
    }

    public double getProgress() {
        return this.recipeInfo.getProgress();
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
            if (infoTag.m_128441_("recipeInfo")) {
                this.recipeInfo.deserializeNBT((Tag)infoTag.m_128469_("recipeInfo"));
            }
            if (infoTag.m_128441_("energy")) {
                this.energyStorage.setEnergy(infoTag.m_128451_("energy"));
            }
            if (infoTag.m_128441_("upgrades")) {
                this.upgradesHandler.deserializeNBT((CompoundTag)infoTag.m_128423_("upgrades"));
            }
            if (infoTag.m_128441_("catalyst")) {
                this.catalystHandler.deserializeNBT((CompoundTag)infoTag.m_128423_("catalyst"));
            }
        }
        if (tag.m_128441_("Content")) {
            this.contentHandler.deserializeNBT((Tag)tag.m_128469_("Content"));
        }
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        this.saveTagData(infoTag);
        if (this.saveSideMapFlag) {
            this.contentHandler.saveSideMap();
            this.saveSideMapFlag = false;
        }
        if (this.upgradesHandler.wasUpdated) {
            infoTag.m_128365_("upgrades", (Tag)this.upgradesHandler.serializeNBT());
            this.upgradesHandler.wasUpdated = false;
        }
        if (this.catalystHandler.wasUpdated) {
            infoTag.m_128365_("catalyst", (Tag)this.catalystHandler.serializeNBT());
            this.catalystHandler.wasUpdated = false;
        }
        infoTag.m_128365_("recipeInfo", this.recipeInfo.serializeNBT());
        tag.m_128365_("Info", (Tag)infoTag);
        tag.m_128365_("Content", this.contentHandler.serializeNBT());
        infoTag.m_128405_("energy", this.energyStorage.getEnergyStored());
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        int oldEnergy = this.energyStorage.getEnergyStored();
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
        if (oldEnergy != this.energyStorage.getEnergyStored()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int toggleSideConfig(int slotId, int direction) {
        this.m_6596_();
        this.saveSideMapFlag = true;
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return this.contentHandler.toggleSideConfig(slotId, direction);
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public SlotModePair.SlotMode getSlotMode(int direction, int slotId) {
        return this.contentHandler.getSlotMode(direction, slotId);
    }

    public FluidTank getFluidTank(int i) {
        return (FluidTank)this.contentHandler.fluidCapability.tanks.get(i);
    }

    public void toggleRedstoneMode() {
        ++this.redstoneMode;
        if (this.redstoneMode > 1) {
            this.redstoneMode = 0;
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public CompoundTag getTagForStack() {
        CompoundTag data = new CompoundTag();
        this.contentHandler.saveSideMap();
        data.m_128365_("Content", this.contentHandler.serializeNBT());
        data.m_128365_("Energy", this.energyStorage.serializeNBT());
        CompoundTag infoTag = new CompoundTag();
        this.saveTagData(infoTag);
        infoTag.m_128365_("upgrades", (Tag)this.upgradesHandler.serializeNBT());
        infoTag.m_128365_("catalyst", (Tag)this.catalystHandler.serializeNBT());
        infoTag.m_128365_("recipeInfo", this.recipeInfo.serializeNBT());
        infoTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        data.m_128365_("Info", (Tag)infoTag);
        return data;
    }

    public List<Item> getAllowedCatalysts() {
        return List.of();
    }

    public int getRecipeProgress() {
        if (this.hasRecipe()) {
            return (int)(this.recipeInfo.getProgress() * 100.0);
        }
        return 0;
    }

    public int getSlotsCount() {
        return this.prefab().getSlotsConfig().slotsCount();
    }

    public void voidSlotContent(int id) {
        if (id < 0 || id >= this.getSlotsCount()) {
            return;
        }
        this.contentHandler.voidSlot(id);
    }

    public Object[] getSlotContent(int id) {
        if (id < 0 || id >= this.getSlotsCount()) {
            return new Object[0];
        }
        return this.contentHandler.getSlotContent(id);
    }

    public void voidFluidSlot(int slotId) {
        if (this.contentHandler != null) {
            this.contentHandler.voidFluidSlot(slotId);
        }
    }

    public boolean isInputAllowed(ItemStack stack) {
        for (ItemStack allowed : this.getAllowedInputItems()) {
            if (!ItemStack.m_41656_((ItemStack)allowed, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }
}

