/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.turbine;

import igentuman.nc.block.entity.turbine.TurbineBE;
import igentuman.nc.block.entity.turbine.TurbineBladeBE;
import igentuman.nc.block.turbine.TurbineRotorBlock;
import igentuman.nc.handler.config.TurbineConfig;
import igentuman.nc.handler.event.client.InputEvents;
import igentuman.nc.multiblock.turbine.BladeDef;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.util.TextUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurbineBladeBlock
extends DirectionalBlock
implements EntityBlock {
    public static final BooleanProperty HIDDEN = BlockStateProperties.f_61448_;
    public double efficiency = 0.0;
    public double expansion = 0.0;
    public String type = "";
    public BladeDef def;

    public TurbineBladeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(SoundType.f_56743_).m_60955_());
    }

    private void initParams() {
        Item item = Item.m_41439_((Block)this);
        if (item.toString().isEmpty()) {
            return;
        }
        this.type = item.toString().replaceAll("turbine_", "");
        this.def = TurbineRegistration.blades().get(this.type);
        this.efficiency = this.def.getEfficiency();
        this.expansion = this.def.getExpansion();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockState neighbor = level.m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()));
        Direction dir = context.m_7820_();
        if (neighbor.m_60734_() instanceof TurbineRotorBlock) {
            dir = context.m_43719_().m_122424_();
        } else if (neighbor.m_60734_() instanceof TurbineBladeBlock) {
            dir = (Direction)neighbor.m_61143_((Property)f_52588_);
        } else {
            BlockState state;
            for (Direction direction : Direction.values()) {
                state = level.m_8055_(context.m_8083_().m_121945_(direction));
                if (!(state.m_60734_() instanceof TurbineRotorBlock)) continue;
                dir = direction;
                break;
            }
            for (Direction direction : Direction.values()) {
                state = level.m_8055_(context.m_8083_().m_121945_(direction));
                if (!(state.m_60734_() instanceof TurbineBladeBlock)) continue;
                dir = (Direction)state.m_61143_((Property)f_52588_);
                break;
            }
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)dir)).m_61124_((Property)HIDDEN, (Comparable)Boolean.valueOf(false));
    }

    public static boolean processBlockPlace(LevelAccessor level, BlockPos pos, BlockState block, BlockState blockState, BlockState attachment) {
        BlockState state;
        if (attachment.m_60734_() instanceof TurbineRotorBlock) {
            return true;
        }
        if (attachment.m_60734_() instanceof TurbineBladeBlock) {
            block.m_61124_((Property)f_52588_, (Comparable)((Direction)attachment.m_61143_((Property)f_52588_)));
            return true;
        }
        for (Direction direction : Direction.values()) {
            state = level.m_8055_(pos.m_121945_(direction));
            if (!(state.m_60734_() instanceof TurbineRotorBlock)) continue;
            block.m_61124_((Property)f_52588_, (Comparable)direction);
            return true;
        }
        for (Direction direction : Direction.values()) {
            state = level.m_8055_(pos.m_121945_(direction));
            if (!(state.m_60734_() instanceof TurbineBladeBlock)) continue;
            block.m_61124_((Property)f_52588_, (Comparable)((Direction)state.m_61143_((Property)f_52588_)));
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean m_6104_(@NotNull BlockState state, @NotNull BlockState adjacentBlockState, @NotNull Direction side) {
        return adjacentBlockState.m_60734_().equals((Object)this);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        if (this.def == null) {
            this.initParams();
        }
        TurbineBladeBE be = (TurbineBladeBE)((BlockEntityType)TurbineRegistration.TURBINE_BE.get("turbine_blade").get()).m_155264_(pPos, pState);
        be.setBladeDef(this.def);
        return be;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_}).m_61104_(new Property[]{HIDDEN});
    }

    private String blockEntityCode() {
        return this.m_5456_().toString();
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof TurbineBladeBE) {
                    TurbineBladeBE tile = (TurbineBladeBE)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof TurbineBladeBE) {
                TurbineBladeBE tile = (TurbineBladeBE)t;
                tile.tickServer();
            }
        };
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        ((TurbineBE)Objects.requireNonNull(level.m_7702_(pos))).onNeighborChange(state, pos, neighbor);
    }

    public void m_5871_(@NotNull ItemStack pStack, @javax.annotation.Nullable BlockGetter pLevel, List<Component> list, TooltipFlag pFlag) {
        this.initParams();
        if (InputEvents.DESCRIPTIONS_SHOW) {
            list.add((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"tooltip.nc.description.efficiency", (Object[])new Object[]{TextUtils.numberFormat(this.def.getEfficiency())}), ChatFormatting.AQUA));
            list.add((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"tooltip.nc.description.expansion", (Object[])new Object[]{TextUtils.numberFormat(this.def.getExpansion())}), ChatFormatting.GOLD));
        } else {
            list.add((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"tooltip.nc.blade.desc", (Object[])new Object[]{TurbineConfig.TURBINE_CONFIG.BLADE_FLOW.get()}), ChatFormatting.BLUE));
        }
        list.add((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"tooltip.toggle_description_keys"), ChatFormatting.GRAY));
    }
}

