/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.element.button;

import igentuman.nc.NuclearCraft;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.processor.side.SideConfigSlotSelectionScreen;
import igentuman.nc.container.NCProcessorContainer;
import igentuman.nc.network.toServer.PacketGuiButtonPress;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class Button<T extends AbstractContainerScreen<?>>
extends NCGuiElement {
    protected AbstractContainerMenu container;
    protected AbstractContainerScreen<?> screen;
    protected int bId;
    protected ImageButton btn;
    protected Component tooltipKey = Component.m_237119_();

    public Button(int xPos, int yPos, T screen, int id) {
        super(xPos, yPos, 18, 18, (Component)Component.m_237119_());
        this.x = xPos;
        this.y = yPos;
        this.container = screen.m_6262_();
        this.screen = screen;
        this.bId = id;
    }

    @Override
    public List<Component> getTooltips() {
        return List.of(this.tooltipKey);
    }

    @Override
    public void draw(GuiGraphics transform, int mX, int mY, float pTicks) {
        super.draw(transform, mX, mY, pTicks);
        this.btn.m_88315_(transform, mX, mY, pTicks);
    }

    @Override
    public boolean onPress() {
        this.btn.m_5691_();
        return true;
    }

    public static class ReactorPortRedstoneModeButton
    extends Button {
        private final BlockPos pos;
        public static final int BTN_ID = 71;
        public byte mode = (byte)2;
        public byte strength = 0;

        public ReactorPortRedstoneModeButton(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, 71);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 238, 256, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(pos, 71)));
        }

        @Override
        public List<Component> getTooltips() {
            return List.of(Component.m_237115_((String)("gui.nc.reactor_comparator_config.tooltip_" + this.mode)), Component.m_237110_((String)"gui.nc.reactor_comparator_strength.tooltip", (Object[])new Object[]{this.strength}));
        }

        public void setMode(byte redstoneMode) {
            this.mode = redstoneMode;
            try {
                Field f = this.btn.getClass().getDeclaredField("yTexStart");
                f.setAccessible(true);
                f.set(this.btn, 256 - (redstoneMode + 1) * 36);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public static class ReactorMode
    extends Button {
        private final BlockPos pos;
        public static final int BTN_ID = 72;
        public boolean mode = false;
        public byte strength = 0;
        public int timer = 2000;

        public ReactorMode(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, 72);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 220, 184, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(pos, 72)));
        }

        @Override
        public List<Component> getTooltips() {
            String code = "energy";
            if (this.mode) {
                code = "steam";
            }
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)("gui.nc.reactor_mode.tooltip_" + code))));
            if (this.timer < 2000) {
                list.add(Component.m_237110_((String)"gui.nc.reactor_mode.timer", (Object[])new Object[]{this.timer / 20}));
            }
            return list;
        }

        public void setMode(boolean reactorMode) {
            this.mode = reactorMode;
            int y = reactorMode ? 1 : 0;
            try {
                Field f = this.btn.getClass().getDeclaredField("yTexStart");
                f.setAccessible(true);
                f.set(this.btn, 184 - (y + 1) * 36);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }

        public void setTimer(int modeTimer) {
            this.timer = modeTimer;
        }
    }

    public static class CloseConfig
    extends Button {
        public <T extends NCProcessorContainer> CloseConfig(int xPos, int yPos, AbstractContainerScreen<T> screen) {
            super(xPos, yPos, screen, 71);
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 202, 220, 18, TEXTURE, pButton -> this.screen.m_7379_());
        }
    }

    public static class ShowRecipes
    extends Button {
        private final BlockPos pos;
        public static int BTN_ID = 70;
        public int mode = 0;

        public ShowRecipes(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, 70);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 184, 4, 18, TEXTURE, pButton -> {});
        }

        @Override
        public List<Component> getTooltips() {
            return List.of();
        }

        public void setMode(int redstoneMode) {
            this.mode = redstoneMode;
            try {
                Field f = this.btn.getClass().getDeclaredField("yTexStart");
                f.setAccessible(true);
                f.set(this.btn, 220 - redstoneMode * 36);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public static class RedstoneConfig
    extends Button {
        private final BlockPos pos;
        public static final int BTN_ID = 70;
        public int mode = 0;

        public RedstoneConfig(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, 70);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 184, 220, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(pos, 70)));
        }

        @Override
        public List<Component> getTooltips() {
            return List.of(Component.m_237115_((String)("gui.nc.redstone_config.tooltip_" + this.mode)));
        }

        public void setMode(int redstoneMode) {
            this.mode = redstoneMode;
            try {
                Field f = this.btn.getClass().getDeclaredField("yTexStart");
                f.setAccessible(true);
                f.set(this.btn, 220 - redstoneMode * 36);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public static class SideConfig
    extends Button {
        public SideConfig(int xPos, int yPos, AbstractContainerScreen<?> screen) {
            super(xPos, yPos, screen, 69);
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 220, 220, 18, TEXTURE, pButton -> Minecraft.m_91087_().m_91346_(new SideConfigSlotSelectionScreen(screen)));
            this.tooltipKey = Component.m_237115_((String)"gui.nc.side_config.tooltip");
        }
    }
}

