/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.cc;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import igentuman.nc.block.entity.fission.FissionControllerBE;
import javax.annotation.Nonnull;

public class NCSolidFissionReactorPeripheral
implements IPeripheral {
    private final FissionControllerBE<?> reactor;

    public NCSolidFissionReactorPeripheral(FissionControllerBE<?> processorBE) {
        this.reactor = processorBE;
    }

    @Nonnull
    public String getType() {
        return "nc_fission_reactor";
    }

    public boolean equals(IPeripheral other) {
        return this == other || other instanceof NCSolidFissionReactorPeripheral && ((NCSolidFissionReactorPeripheral)other).reactor == this.reactor;
    }

    @LuaFunction
    public final String getName() {
        return this.reactor.getName();
    }

    @LuaFunction
    public final boolean hasRecipe() {
        return this.reactor.hasRecipe();
    }

    @LuaFunction
    public final boolean isSteamMode() {
        return this.reactor.isSteamMode;
    }

    @LuaFunction
    public final double getSteamRate() {
        return this.reactor.getSteamRate();
    }

    @LuaFunction
    public final int getDepletionProgress() {
        return (int)(this.reactor.getDepletionProgress() * 100.0);
    }

    @LuaFunction
    public final double getMaxHeatCapacity() {
        return this.reactor.getMaxHeat();
    }

    @LuaFunction
    public final void enableReactor() {
        this.reactor.disableForceShutdown();
    }

    @LuaFunction
    public final void disableReactor() {
        this.reactor.forceShutdown();
    }

    @LuaFunction
    public final int getEnergyPerTick() {
        return this.reactor.energyPerTick;
    }

    @LuaFunction
    public final void setModerationLevel(int level) {
        this.reactor.adjustModerationLevel(level);
    }

    @LuaFunction
    public final int getEnergyStored() {
        return this.reactor.energyStorage.getEnergyStored();
    }

    @LuaFunction
    public final double getHeatMultiplier() {
        return this.reactor.heatMultiplier;
    }

    @LuaFunction
    public final int getModeratorsCount() {
        return this.reactor.moderatorsCount;
    }

    @LuaFunction
    public final int getHeatSinksCount() {
        return this.reactor.heatSinksCount;
    }

    @LuaFunction
    public final int getFuelCellsCount() {
        return this.reactor.fuelCellsCount;
    }

    @LuaFunction
    public final int getCooling() {
        return (int)this.reactor.coolingPerTick();
    }

    @LuaFunction
    public final int getHeat() {
        return (int)this.reactor.heatPerTick();
    }

    @LuaFunction
    public final int getHeatStored() {
        return (int)this.reactor.heat;
    }

    @LuaFunction
    public final void voidFuel() {
        this.reactor.voidFuel();
    }

    @LuaFunction
    public final Object[] getFuelInSlot() {
        return this.reactor.getFuel();
    }
}

