/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei.util;

import com.google.common.base.Preconditions;
import mezz.jei.api.gui.ITickTimer;

public class TickTimer
implements ITickTimer {
    private int msPerCycle;
    private final int maxValue;
    private final boolean countDown;
    private final long startTime;

    public TickTimer(int ticksPerCycle, int maxValue, boolean countDown) {
        Preconditions.checkArgument((ticksPerCycle > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 tick per cycle.");
        Preconditions.checkArgument((maxValue > 0 ? 1 : 0) != 0, (Object)"max value must be greater than 0");
        this.msPerCycle = ticksPerCycle * 50;
        this.maxValue = maxValue;
        this.countDown = countDown;
        this.startTime = System.currentTimeMillis();
    }

    public void setTicksPerCycle(int ticks) {
        this.msPerCycle = ticks * 50;
    }

    public int getValue() {
        long currentTime = System.currentTimeMillis();
        return TickTimer.getValue(this.startTime, currentTime, this.maxValue, this.msPerCycle, this.countDown);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public static int getValue(long startTime, long currentTime, int maxValue, int msPerCycle, boolean countDown) {
        long msPassed = (currentTime - startTime) % (long)msPerCycle;
        int value = (int)Math.floorDiv(msPassed * (long)(maxValue + 1), msPerCycle);
        if (countDown) {
            return maxValue - value;
        }
        return value;
    }
}

