/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content;

import igentuman.nc.setup.registration.NCItems;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum ArmorMaterials implements ArmorMaterial
{
    HAZMAT("nuclearcraft:hazmat", 5, new int[]{1, 2, 3, 1}, 15, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NCItems.NC_ITEMS.get("bioplastic").get()})),
    TOUGH("nuclearcraft:tough", 33, new int[]{3, 6, 8, 3}, 15, SoundEvents.f_11673_, 3.5f, 0.2f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NCItems.NC_INGOTS.get("tough_alloy").get()})),
    HEV("nuclearcraft:hev", 37, new int[]{3, 5, 7, 3}, 25, SoundEvents.f_11679_, 4.0f, 0.3f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)NCItems.NC_SHIELDING.get("dps").get()}));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    private ArmorMaterials(String pName, int pDurabilityMultiplier, int[] pSlotProtections, int pEnchantmentValue, SoundEvent pSound, float pToughness, float pKnockbackResistance, Supplier<Ingredient> pRepairIngredient) {
        this.name = pName;
        this.durabilityMultiplier = pDurabilityMultiplier;
        this.slotProtections = pSlotProtections;
        this.enchantmentValue = pEnchantmentValue;
        this.sound = pSound;
        this.toughness = pToughness;
        this.knockbackResistance = pKnockbackResistance;
        this.repairIngredient = new LazyLoadedValue(pRepairIngredient);
    }

    public int getDurabilityForSlot(EquipmentSlot pSlot) {
        return HEALTH_PER_SLOT[pSlot.m_20749_()] * this.durabilityMultiplier;
    }

    public int getDefenseForSlot(EquipmentSlot pSlot) {
        return this.slotProtections[pSlot.m_20749_()];
    }

    public int m_266425_(ArmorItem.Type type) {
        return 3;
    }

    public int m_7366_(ArmorItem.Type type) {
        return 3;
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

