/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.processors;

import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.container.NCProcessorContainer;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.content.processors.config.ProcessorSlots;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.ProcessorsConfig;
import igentuman.nc.recipes.AbstractRecipe;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ProcessorPrefab<M extends NCProcessorContainer, U extends Screen> {
    public int progressBar = 0;
    public Supplier<RecipeSerializer<? extends AbstractRecipe>> recipeSerializerSupplier;
    public boolean supportsCatalyst;
    private Class container;
    private MenuScreens.ScreenConstructor<M, U> screenConstructor;
    private boolean initialized;
    private boolean has_recipes = true;
    private Boolean registered = true;
    public String name;
    public boolean supportSpeedUpgrade = true;
    protected int power = 20;
    protected int time = 200;
    public List<Integer> hiddenSlots = new ArrayList<Integer>();
    public boolean supportEnergyUpgrade = true;
    protected Class recipeManager;
    private BlockEntityType.BlockEntitySupplier<? extends NCProcessorBE> blockEntity;
    protected ProcessorSlots slotsConfig;

    public BlockEntityType.BlockEntitySupplier<? extends NCProcessorBE> getBlockEntity() {
        return this.blockEntity;
    }

    public ProcessorPrefab<M, U> setBlockEntity(BlockEntityType.BlockEntitySupplier<? extends NCProcessorBE> blockEntity) {
        this.blockEntity = blockEntity;
        return this;
    }

    public MenuScreens.ScreenConstructor<M, U> getScreenConstructor() {
        return this.screenConstructor;
    }

    public void setScreenConstructor(MenuScreens.ScreenConstructor<M, U> screenConstructor) {
        this.screenConstructor = screenConstructor;
    }

    public boolean isSlotHidden(int slot) {
        return this.hiddenSlots.contains(slot);
    }

    public void setContainer(Class container) {
        this.container = container;
    }

    public ProcessorPrefab(String name) {
        this.name = name;
        this.slotsConfig = new ProcessorSlots();
    }

    public ProcessorPrefab(String name, int inFluids, int inItems, int outFluids, int outItems) {
        this(name);
        this.slotsConfig.setInputFluids(inFluids).setInputItems(inItems).setOutputFluids(outFluids).setOutputItems(outItems);
    }

    public int getPower() {
        return this.power;
    }

    public ProcessorPrefab power(int power) {
        this.power = power;
        return this;
    }

    public int getTime() {
        return this.time;
    }

    public ProcessorPrefab<M, U> time(int time) {
        this.time = time;
        return this;
    }

    public ProcessorSlots getSlotsConfig() {
        return this.slotsConfig;
    }

    public int getTotalItemSlots() {
        return this.getSlotsConfig().getInputItems() + this.getSlotsConfig().getOutputItems() + (this.supportSpeedUpgrade ? 1 : 0) + (this.supportEnergyUpgrade ? 1 : 0);
    }

    public ProcessorPrefab<M, U> config() {
        if (!this.initialized) {
            if (!CommonConfig.isLoaded()) {
                return this;
            }
            int id = Processors.all().keySet().stream().toList().indexOf(this.name);
            this.registered = (Boolean)((List)ProcessorsConfig.PROCESSOR_CONFIG.REGISTER_PROCESSOR.get()).get(id);
            this.power = (Integer)((List)ProcessorsConfig.PROCESSOR_CONFIG.PROCESSOR_POWER.get()).get(id);
            this.time = (Integer)((List)ProcessorsConfig.PROCESSOR_CONFIG.PROCESSOR_TIME.get()).get(id);
            this.initialized = true;
        }
        return this;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public Constructor<M> getContainerConstructor() {
        try {
            return this.container.getConstructor(Integer.TYPE, BlockPos.class, Inventory.class, Player.class, String.class);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public int getUpgradesSlots() {
        return (this.supportSpeedUpgrade ? 1 : 0) + (this.supportEnergyUpgrade ? 1 : 0);
    }

    public boolean hasRecipes() {
        return this.has_recipes;
    }

    public Supplier<RecipeSerializer<? extends AbstractRecipe>> getRecipeSerializer() {
        return this.recipeSerializerSupplier;
    }
}

