/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.recipes.recipes;

import igentuman.nc.NuclearCraft;
import igentuman.nc.datagen.recipes.builder.NcRecipeBuilder;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.NcIngredient;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.setup.registration.Fuel;
import igentuman.nc.setup.registration.NCFluids;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.util.DataGenUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractRecipeProvider {
    public static String ID;
    public static Consumer<FinishedRecipe> consumer;
    private static List<NcIngredient> input;
    private static List<NcIngredient> output;
    private static double[] params;

    protected static NcIngredient ingredient(TagKey<Item> item, int ... count) {
        return NcIngredient.of(item, count);
    }

    protected static NcIngredient ingredient(Item item, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return NcIngredient.stack(AbstractRecipeProvider.stack(item, count));
    }

    protected static NcIngredient blockStack(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return NcIngredient.stack(AbstractRecipeProvider.stack(AbstractRecipeProvider.blockItem(name), count));
    }

    protected static ItemStack stack(Item item, int count) {
        return new ItemStack((ItemLike)item, count);
    }

    protected static ItemStack stack(Block block, int count) {
        return new ItemStack((ItemLike)block, count);
    }

    protected static ItemStack stack(String item, int count) {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item)), count);
    }

    public static ItemStack[] stackArray(ItemStack ... stacks) {
        return stacks;
    }

    protected static void doubleToItem(String id, NcIngredient input1, NcIngredient input2, NcIngredient output, double ... params) {
        double timeModifier = params.length > 0 ? params[0] : 1.0;
        double powerModifier = params.length > 1 ? params[1] : 1.0;
        double radiation = params.length > 2 ? params[2] : 1.0;
        NcRecipeBuilder.get(id).items(List.of(input1, input2), List.of(output)).modifiers(timeModifier, radiation, powerModifier).build(consumer);
    }

    protected static FluidStack fluidStack(Fluid fluid, int amount) {
        try {
            return (FluidStack)IngredientCreatorAccess.fluid().from(fluid, amount).getRepresentations().get(0);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Fluid " + fluid.getFluidType().toString() + " does not exist");
        }
    }

    protected static FluidStack fluidStack(String name, int amount) {
        try {
            return (FluidStack)IngredientCreatorAccess.fluid().from(name, amount).getRepresentations().get(0);
        }
        catch (NullPointerException e) {
            System.out.println("Fluid " + name + " does not exist");
            return FluidStack.EMPTY;
        }
    }

    protected static FluidStackIngredient fluidIngredient(String name, int amount) {
        return (FluidStackIngredient)IngredientCreatorAccess.fluid().from(AbstractRecipeProvider.forgeFluid(name), amount);
    }

    protected static FluidStackIngredient fluidStackIngredient(String name, int amount) {
        return (FluidStackIngredient)IngredientCreatorAccess.fluid().from(AbstractRecipeProvider.fluidStack(name, amount));
    }

    public static void itemToItem(NcIngredient input, NcIngredient output, double ... params) {
        double timeModifier = params.length > 0 ? params[0] : 1.0;
        double powerModifier = params.length > 1 ? params[1] : 1.0;
        double radiation = params.length > 2 ? params[2] : 1.0;
        NcRecipeBuilder.get(ID).items(List.of(input), List.of(output)).modifiers(timeModifier, radiation, powerModifier).build(consumer);
    }

    public static void itemsToItems(List<NcIngredient> input, List<NcIngredient> output, double ... params) {
        double timeModifier = params.length > 0 ? params[0] : 1.0;
        double powerModifier = params.length > 1 ? params[1] : 1.0;
        double radiation = params.length > 2 ? params[2] : 1.0;
        NcRecipeBuilder.get(ID).items(input, output).modifiers(timeModifier, radiation, powerModifier).build(consumer);
    }

    public static void itemsToItemsString(List<NcIngredient> input, List<String> output, double ... params) {
        double timeModifier = params.length > 0 ? params[0] : 1.0;
        double powerModifier = params.length > 1 ? params[1] : 1.0;
        double radiation = params.length > 2 ? params[2] : 1.0;
        NcRecipeBuilder.get(ID).itemsString(input, output).modifiers(timeModifier, radiation, powerModifier).build(consumer);
    }

    public static void oreVein(List<NcIngredient> input, NcIngredient output, String nameKey, double ... params) {
        double timeModifier = params.length > 0 ? params[0] : 1.0;
        double powerModifier = params.length > 1 ? params[1] : 1.0;
        double radiation = params.length > 2 ? params[2] : 1.0;
        double rarity = params.length > 3 ? params[3] : 1.0;
        NcRecipeBuilder.get(ID).items(input, List.of(output)).modifiers(timeModifier, radiation, powerModifier, rarity).build(consumer, NuclearCraft.rl(ID + "/" + nameKey));
    }

    public static void fluidsAndFluids(List<FluidStackIngredient> input, List<FluidStackIngredient> output, double ... params) {
        double timeModifier = params.length > 0 ? params[0] : 1.0;
        double powerModifier = params.length > 1 ? params[1] : 1.0;
        double radiation = params.length > 2 ? params[2] : 1.0;
        NcRecipeBuilder.get(ID).fluids(input, output).modifiers(timeModifier, radiation, powerModifier).build(consumer);
    }

    public static void coolantRecipe(List<FluidStackIngredient> input, List<FluidStackIngredient> output, double coolingRate) {
        NcRecipeBuilder.get(ID).fluids(input, output).modifiers(0.0, 0.0, 0.0, 0.0).coolingRate(coolingRate).build(consumer);
    }

    public static void boilingRecipe(List<FluidStackIngredient> input, List<FluidStackIngredient> output, double heatRequired) {
        NcRecipeBuilder.get(ID).fluids(input, output).modifiers(0.0, 0.0, 0.0, 0.0).heatRequired(heatRequired).useInputForId(true).build(consumer);
    }

    public static void itemsAndFluids(List<NcIngredient> inputItems, List<NcIngredient> outputItems, List<FluidStackIngredient> inputFluids, List<FluidStackIngredient> outputFluids, double ... params) {
        double timeModifier = params.length > 0 ? params[0] : 1.0;
        double powerModifier = params.length > 1 ? params[1] : 1.0;
        double radiation = params.length > 2 ? params[2] : 1.0;
        NcRecipeBuilder.get(ID).items(inputItems, outputItems).fluids(inputFluids, outputFluids).modifiers(timeModifier, radiation, powerModifier).build(consumer);
    }

    public static TagKey<Fluid> forgeFluid(String name) {
        String key = "forge";
        if (name.contains(":")) {
            key = name.split(":")[0];
            name = name.split(":")[1];
        }
        return TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation(key, name));
    }

    public static Item blockItem(String name) {
        for (String string : List.of(name, "block_" + name, name + "_block")) {
            if (NCItems.ALL_NC_ITEMS.get(name) == null) continue;
            return (Item)NCItems.ALL_NC_ITEMS.get(string).get();
        }
        System.out.println("null block: " + name);
        return Items.f_42127_;
    }

    public static Item nuggetItem(String name) {
        if (NCItems.NC_NUGGETS.get(name) == null) {
            System.out.println("null nugget: " + name);
        }
        return (Item)NCItems.NC_NUGGETS.get(name).get();
    }

    public static Item dustItem(String name) {
        if (NCItems.NC_DUSTS.get(name) == null) {
            System.out.println("null dust: " + name);
        }
        return (Item)NCItems.NC_DUSTS.get(name).get();
    }

    public static TagKey<Item> dustTag(String name) {
        if (NCItems.DUSTS_TAG.get(name) == null) {
            System.out.println("null dust tag: " + name);
        }
        return NCItems.DUSTS_TAG.get(name);
    }

    public static NcIngredient dustStack(String name, int count) {
        return NcIngredient.stack(AbstractRecipeProvider.stack(AbstractRecipeProvider.dustItem(name), count));
    }

    public static NcIngredient nuggetStack(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return NcIngredient.stack(AbstractRecipeProvider.stack(AbstractRecipeProvider.nuggetItem(name), count));
    }

    public static NcIngredient ingotStack(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return NcIngredient.stack(AbstractRecipeProvider.stack(AbstractRecipeProvider.ingotItem(name), count));
    }

    public static NcIngredient gemStack(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return NcIngredient.stack(AbstractRecipeProvider.stack(AbstractRecipeProvider.gemItem(name), count));
    }

    public static NcIngredient plateStack(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return NcIngredient.stack(AbstractRecipeProvider.stack(AbstractRecipeProvider.plateItem(name), count));
    }

    public static NcIngredient isotopeStack(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return NcIngredient.stack(AbstractRecipeProvider.stack(AbstractRecipeProvider.isotopeItem(name), count));
    }

    public static NcIngredient dustIngredient(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return AbstractRecipeProvider.ingredient(DataGenUtil.forgeDust(name), count);
    }

    public static FluidStackIngredient moltenFuelIngredient(List<String> name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return IngredientCreatorAccess.fluid().from((Fluid)NCFluids.ALL_FLUID_ENTRIES.get(AbstractRecipeProvider.fuelItem(name).toString()).getStill(), count);
    }

    public static NcIngredient fuelIngredient(List<String> name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return AbstractRecipeProvider.ingredient(AbstractRecipeProvider.fuelItem(name), count);
    }

    public static Item fuelItem(List<String> name) {
        if (Fuel.NC_FUEL.get(name) != null) {
            return (Item)Fuel.NC_FUEL.get(name).get();
        }
        if (Fuel.NC_DEPLETED_FUEL.get(name) != null) {
            return (Item)Fuel.NC_DEPLETED_FUEL.get(name).get();
        }
        System.out.println("null fuel: " + String.join((CharSequence)"-", name));
        return Items.f_41852_;
    }

    public static NcIngredient isotopeIngredient(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return AbstractRecipeProvider.ingredient(AbstractRecipeProvider.isotopeItem(name), count);
    }

    public static NcIngredient oreIngredient(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return AbstractRecipeProvider.ingredient(DataGenUtil.forgeOre(name), count);
    }

    public static NcIngredient chunkIngredient(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return AbstractRecipeProvider.ingredient(DataGenUtil.forgeChunk(name), count);
    }

    public static NcIngredient ingotIngredient(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return AbstractRecipeProvider.ingredient(DataGenUtil.forgeIngot(name), count);
    }

    public static NcIngredient plateIngredient(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return AbstractRecipeProvider.ingredient(DataGenUtil.forgePlate(name), count);
    }

    public static NcIngredient gemIngredient(String name, int ... pCount) {
        int count = 1;
        if (pCount.length > 0) {
            count = pCount[0];
        }
        return AbstractRecipeProvider.ingredient(DataGenUtil.forgeGem(name), count);
    }

    public static Item isotopeItem(String name) {
        if (Fuel.NC_ISOTOPES.get(name) == null) {
            System.out.println("null isotope: " + name);
        }
        return (Item)Fuel.NC_ISOTOPES.get(name).get();
    }

    public static Item plateItem(String name) {
        if (NCItems.NC_PLATES.get(name) == null) {
            System.out.println("null plate: " + name);
        }
        return (Item)NCItems.NC_PLATES.get(name).get();
    }

    public static TagKey<Item> plateTag(String name) {
        if (NCItems.PLATES_TAG.get(name) == null) {
            System.out.println("null plate tag: " + name);
        }
        return NCItems.PLATES_TAG.get(name);
    }

    public static Item ingotItem(String name) {
        if (NCItems.NC_INGOTS.get(name) == null) {
            System.out.println("null ingot: " + name);
        }
        return (Item)NCItems.NC_INGOTS.get(name).get();
    }

    public static TagKey<Item> ingotTag(String name) {
        if (NCItems.INGOTS_TAG.get(name) == null) {
            System.out.println("null ingot tag: " + name);
        }
        return NCItems.INGOTS_TAG.get(name);
    }

    public static TagKey<Item> gemTag(String name) {
        if (NCItems.GEMS_TAG.get(name) == null) {
            System.out.println("null gem tag: " + name);
        }
        return NCItems.GEMS_TAG.get(name);
    }

    public static Item gemItem(String name) {
        if (NCItems.NC_GEMS.get(name) == null) {
            System.out.println("null gem: " + name);
        }
        return (Item)NCItems.NC_GEMS.get(name).get();
    }

    public static Item getIsotope(String name, String id, String type) {
        if (!((String)type).isEmpty()) {
            type = "_" + (String)type;
        }
        if (!Fuel.NC_ISOTOPES.containsKey(name + "/" + id + (String)type)) {
            for (String isotope : Fuel.NC_ISOTOPES.keySet()) {
                if (!isotope.contains(id)) continue;
                return (Item)Fuel.NC_ISOTOPES.get(isotope).get();
            }
        }
        return (Item)Fuel.NC_ISOTOPES.get(name + "/" + id + (String)type).get();
    }
}

