/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.recipes.recipes;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.fission.FissionControllerBE;
import igentuman.nc.datagen.recipes.builder.NcRecipeBuilder;
import igentuman.nc.recipes.ingredient.NcIngredient;
import igentuman.nc.setup.registration.Fuel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class FissionRecipes {
    public static Consumer<FinishedRecipe> consumer;

    public static void generate(Consumer<FinishedRecipe> consumer) {
        FissionRecipes.consumer = consumer;
        FissionRecipes.solidFissionRecipes();
    }

    private static void itemToItemRecipe(String id, NcIngredient input, Item output, double ... params) {
        FissionRecipes.itemToItemRecipe(id, input, NcIngredient.of(new ItemLike[]{output}), params);
    }

    private static void itemToItemRecipe(String id, NcIngredient input, NcIngredient output, double ... params) {
        double timeModifier = params.length > 0 ? params[0] : 1.0;
        double powerModifier = params.length > 1 ? params[1] : 1.0;
        double radiation = params.length > 2 ? params[2] : 1.0;
        NcRecipeBuilder.get(id).items(List.of(input), List.of(output)).modifiers(timeModifier, radiation, powerModifier).build(consumer, NuclearCraft.rl(id + "/" + output.getName().replace("depleted_fuel_", "")));
    }

    private static void solidFissionRecipes() {
        for (List<String> name : Fuel.NC_FUEL.keySet()) {
            if (name.contains("tr")) continue;
            ArrayList<String> depleted = new ArrayList<String>(name);
            depleted.set(0, "depleted");
            FissionRecipes.itemToItemRecipe(FissionControllerBE.NAME, NcIngredient.of((ItemLike)Fuel.NC_FUEL.get(name).get()), (Item)Fuel.NC_DEPLETED_FUEL.get(depleted).get(), new double[0]);
        }
    }
}

