/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.config;

import igentuman.nc.content.materials.Blocks;
import igentuman.nc.content.materials.Chunks;
import igentuman.nc.content.materials.Dusts;
import igentuman.nc.content.materials.Gems;
import igentuman.nc.content.materials.Ingots;
import igentuman.nc.content.materials.Ores;
import igentuman.nc.content.materials.Plates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.ForgeConfigSpec;

public class MaterialsConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final OresConfig ORE_CONFIG = new OresConfig(BUILDER);
    public static final MaterialProductsConfig MATERIAL_PRODUCTS = new MaterialProductsConfig(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static <T> List<T> toList(Collection<T> vals) {
        return new ArrayList<T>(vals);
    }

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class OresConfig {
        public HashMap<String, List<ForgeConfigSpec.ConfigValue<?>>> ORES;

        public OresConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for ore generation").push("ores").pop();
            this.ORES = new HashMap();
            for (String name : Ores.all().keySet()) {
                this.ORES.put(name, this.buildOreConfig(builder, name));
            }
        }

        private List<ForgeConfigSpec.ConfigValue<?>> buildOreConfig(ForgeConfigSpec.Builder builder, String name) {
            ArrayList options = new ArrayList();
            builder.push(name);
            ForgeConfigSpec.BooleanValue register = builder.define("register", true);
            ForgeConfigSpec.ConfigValue dimensions = builder.define("dimensions", Ores.all().get((Object)name).dimensions, o -> o instanceof ArrayList);
            ForgeConfigSpec.ConfigValue veinSize = builder.define("vein_size", (Object)Ores.all().get((Object)name).veinSize);
            ForgeConfigSpec.ConfigValue veinsPerChunk = builder.define("veins_in_chunk", (Object)Ores.all().get((Object)name).veinAmount);
            ForgeConfigSpec.ConfigValue min_height = builder.define("min_height", (Object)Ores.all().get((Object)name).height[0]);
            ForgeConfigSpec.ConfigValue max_height = builder.define("max_height", (Object)Ores.all().get((Object)name).height[1]);
            options.add((ForgeConfigSpec.ConfigValue<?>)register);
            options.add(dimensions);
            options.add(veinSize);
            options.add(veinsPerChunk);
            options.add(min_height);
            options.add(max_height);
            builder.pop();
            return options;
        }
    }

    public static class MaterialProductsConfig {
        public List<ForgeConfigSpec.ConfigValue<Boolean>> INGOTS;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> NUGGET;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> BLOCK;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> RAW_CHUNKS;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> PLATES;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> DUSTS;
        public List<ForgeConfigSpec.ConfigValue<Boolean>> GEMS;
        public ForgeConfigSpec.ConfigValue<List<String>> SLURRIES;
        public ForgeConfigSpec.ConfigValue<List<String>> MODS_PRIORITY;

        public MaterialProductsConfig(ForgeConfigSpec.Builder builder) {
            builder.push("slurries");
            this.SLURRIES = builder.comment("List of available slurries (dissolved ores in acid)").comment("Color for slurry will be calculate from average texture color").comment("Texture location has to be: nuclearcraft:textures/block/ore/(slurry_name)_ore.png").comment("If no texture found it will generate random color").define("register_slurries", List.of("uranium", "iron", "gold", "aluminum", "thorium", "boron", "silver", "lead", "tin", "copper", "zinc", "cobalt", "platinum", "lithium", "magnesium"), o -> o instanceof ArrayList);
            builder.pop();
            this.RAW_CHUNKS = this.registrationList(builder, "raw_chunks", Chunks.get().all().keySet());
            this.INGOTS = this.registrationList(builder, "ingots", Ingots.get().all().keySet());
            this.PLATES = this.registrationList(builder, "plates", Plates.get().all().keySet());
            this.DUSTS = this.registrationList(builder, "dusts", Dusts.get().all().keySet());
            this.BLOCK = this.registrationList(builder, "blocks", Blocks.get().all().keySet());
            this.GEMS = this.registrationList(builder, "gems", Gems.get().all().keySet());
            builder.comment("Forge Tag priority").push("forge_tag_priority");
            this.MODS_PRIORITY = builder.comment("Priority of mods to resolve forge tags to itemstack and fluidstack.").define("mods_priority", List.of("nuclearcraft", "mekanism", "immersiveengineering", "tconstruct"), o -> o instanceof ArrayList);
            builder.pop();
        }

        private List<ForgeConfigSpec.ConfigValue<Boolean>> registrationList(ForgeConfigSpec.Builder builder, String subCategory, Set<String> items) {
            ArrayList<ForgeConfigSpec.ConfigValue<Boolean>> rawOres = new ArrayList<ForgeConfigSpec.ConfigValue<Boolean>>();
            builder.push(subCategory);
            for (String item : items) {
                rawOres.add((ForgeConfigSpec.ConfigValue<Boolean>)BUILDER.define(item, true));
            }
            builder.pop();
            return rawOres;
        }
    }
}

