/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.event.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import igentuman.nc.block.ISizeToggable;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.item.MultitoolItem;
import igentuman.nc.item.QNP;
import igentuman.nc.util.NCBlockPos;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="nuclearcraft", value={Dist.CLIENT})
public class BlockOverlayHandler {
    public static List<BlockPos> outlineBlocks = new ArrayList<BlockPos>();
    public static List<BlockPos> fusionReactors = new ArrayList<BlockPos>();

    public static void register(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(BlockOverlayHandler::blockOverlayEvent);
        MinecraftForge.EVENT_BUS.addListener(BlockOverlayHandler::onRenderPre);
    }

    public static Pair<BlockPos, BlockPos> getArea(BlockPos pos, Direction facing, int radius, boolean depth) {
        BlockPos bottomLeft = pos.m_5484_(facing.m_122434_() == Direction.Axis.Y ? Direction.SOUTH : Direction.DOWN, radius).m_5484_(facing.m_122434_() == Direction.Axis.Y ? Direction.WEST : facing.m_122428_(), radius);
        BlockPos topRight = pos.m_5484_(facing.m_122434_() == Direction.Axis.Y ? Direction.NORTH : Direction.UP, radius).m_5484_(facing.m_122434_() == Direction.Axis.Y ? Direction.EAST : facing.m_122427_(), radius);
        if (facing.m_122434_() != Direction.Axis.Y && radius > 0) {
            bottomLeft = bottomLeft.m_5484_(Direction.UP, radius - 1);
            topRight = topRight.m_5484_(Direction.UP, radius - 1);
        }
        if (depth) {
            topRight = topRight.m_5484_(facing.m_122424_(), radius + 1);
        }
        return Pair.of((Object)bottomLeft, (Object)topRight);
    }

    @SubscribeEvent
    public static void onRenderWorldEvent(RenderLevelStageEvent e) {
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (e.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            for (BlockPos pos : fusionReactors) {
            }
        }
        if (e.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            gameRenderer.m_252879_(e.getProjectionMatrix());
            if (player.m_9236_().f_46443_) {
                for (BlockPos pos : outlineBlocks) {
                    AABB aabb = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                    BlockOverlayHandler.drawBoundingBoxAtBlockPos(e.getPoseStack(), aabb, 1.0f, 0.0f, 0.0f, 1.0f, pos, player.m_20183_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void blockOverlayEvent(RenderHighlightEvent.Block event) {
        BlockHitResult hit = event.getTarget();
        ItemStack stackItem = Minecraft.m_91087_().f_91074_.m_21205_();
        BlockOverlayHandler.handleQNP(event, (HitResult)hit, stackItem);
        BlockOverlayHandler.handleMultitool(event, (HitResult)hit, stackItem);
    }

    private static void handleMultitool(RenderHighlightEvent.Block event, HitResult hit, ItemStack stackItem) {
        Item item;
        if (hit.m_6662_() == HitResult.Type.BLOCK && (item = stackItem.m_41720_()) instanceof MultitoolItem) {
            ISizeToggable.SideMode mode;
            MultitoolItem multitool = (MultitoolItem)item;
            BlockHitResult blockRayTraceResult = (BlockHitResult)hit;
            event.setCanceled(true);
            BlockPos blockPos = blockRayTraceResult.m_82425_();
            Level world = Minecraft.m_91087_().f_91074_.m_9236_();
            BlockEntity be = world.m_7702_(blockPos);
            if (!(be instanceof NuclearCraftBE)) {
                return;
            }
            NuclearCraftBE ncBe = (NuclearCraftBE)be;
            if (ncBe.sideConfig.isEmpty()) {
                return;
            }
            Direction hitSide = blockRayTraceResult.m_82434_();
            if (Minecraft.m_91087_().f_91074_.m_6144_()) {
                hitSide = hitSide.m_122424_();
            }
            if ((mode = ncBe.sideConfig.get(hitSide.ordinal())) == null) {
                return;
            }
            float[] color = new float[]{0.0f, 1.0f, 0.0f};
            switch (mode) {
                case DEFAULT: {
                    color = new float[]{0.0f, 1.0f, 0.0f};
                    break;
                }
                case IN: {
                    color = new float[]{0.0f, 0.0f, 1.0f};
                    break;
                }
                case OUT: {
                    color = new float[]{1.0f, 0.0f, 0.0f};
                    break;
                }
                case DISABLED: {
                    color = new float[]{0.5f, 0.5f, 0.5f};
                }
            }
            PoseStack stack = new PoseStack();
            stack.m_85836_();
            Camera info = event.getCamera();
            stack.m_252781_(Axis.f_252529_.m_252977_(info.m_90589_()));
            stack.m_252781_(Axis.f_252436_.m_252977_(info.m_90590_() + 180.0f));
            double d0 = info.m_90583_().m_7096_();
            double d1 = info.m_90583_().m_7098_();
            double d2 = info.m_90583_().m_7094_();
            VertexConsumer builder = Minecraft.m_91087_().m_91269_().m_110109_().m_6299_(RenderType.m_110504_());
            VoxelShape shape = world.m_8055_(blockPos).m_60808_((BlockGetter)world, blockPos);
            AABB bounds = shape.m_83215_();
            switch (hitSide) {
                case DOWN: {
                    bounds = bounds.m_165893_(0.01);
                    break;
                }
                case UP: {
                    bounds = bounds.m_165887_(0.99);
                    break;
                }
                case NORTH: {
                    bounds = bounds.m_165895_(0.01);
                    break;
                }
                case SOUTH: {
                    bounds = bounds.m_165889_(0.99);
                    break;
                }
                case WEST: {
                    bounds = bounds.m_165891_(0.01);
                    break;
                }
                case EAST: {
                    bounds = bounds.m_165880_(0.99);
                }
            }
            LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)builder, (AABB)bounds.m_82386_((double)blockPos.m_123341_() - d0, (double)blockPos.m_123342_() - d1, (double)blockPos.m_123343_() - d2), (float)color[0], (float)color[1], (float)color[2], (float)0.35f);
            stack.m_85849_();
        }
    }

    private static void handleQNP(RenderHighlightEvent.Block event, HitResult hit, ItemStack stackItem) {
        Item item;
        if (hit.m_6662_() == HitResult.Type.BLOCK && (item = stackItem.m_41720_()) instanceof QNP) {
            QNP qnp = (QNP)item;
            BlockHitResult blockRayTraceResult = (BlockHitResult)hit;
            event.setCanceled(true);
            QNP.Mode mode = QNP.getMode(stackItem);
            Level world = Minecraft.m_91087_().f_91074_.m_9236_();
            Pair<BlockPos, BlockPos> area = BlockOverlayHandler.getArea(blockRayTraceResult.m_82425_(), blockRayTraceResult.m_82434_(), mode.radius, mode.depth);
            PoseStack stack = new PoseStack();
            stack.m_85836_();
            Camera info = event.getCamera();
            stack.m_252781_(Axis.f_252529_.m_252977_(info.m_90589_()));
            stack.m_252781_(Axis.f_252436_.m_252977_(info.m_90590_() + 180.0f));
            double d0 = info.m_90583_().m_7096_();
            double d1 = info.m_90583_().m_7098_();
            double d2 = info.m_90583_().m_7094_();
            VertexConsumer builder = Minecraft.m_91087_().m_91269_().m_110109_().m_6299_(RenderType.m_110504_());
            BlockPos.m_121940_((BlockPos)((BlockPos)area.getLeft()), (BlockPos)((BlockPos)area.getRight())).forEach(blockPos -> {
                VoxelShape shape = world.m_8055_(blockPos).m_60808_((BlockGetter)world, blockPos);
                if (!(shape == null || shape.m_83281_() || world.m_46859_(blockPos) || !(world.m_8055_(blockPos).m_60800_((BlockGetter)world, blockPos) >= 0.0f) || world.m_8055_(blockPos).m_60734_() instanceof IFluidBlock || world.m_8055_(blockPos).m_60734_() instanceof LiquidBlock)) {
                    LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)builder, (AABB)shape.m_83215_().m_82386_((double)blockPos.m_123341_() - d0, (double)blockPos.m_123342_() - d1, (double)blockPos.m_123343_() - d2), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.35f);
                }
            });
            stack.m_85849_();
        }
    }

    @SubscribeEvent
    public static void onRenderPre(RenderPlayerEvent.Pre event) {
        if (event.getEntity().m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_()) && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            return;
        }
        if (event.getEntity().m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof QNP) {
            event.getEntity().m_6672_(InteractionHand.MAIN_HAND);
        } else if (event.getEntity().m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof QNP) {
            event.getEntity().m_6672_(InteractionHand.OFF_HAND);
        }
    }

    public static void drawBoundingBoxAtBlockPos(PoseStack matrixStackIn, AABB aabbIn, float red, float green, float blue, float alpha, BlockPos pos, BlockPos aimed) {
        Vec3 cam = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double camX = cam.f_82479_;
        double camY = cam.f_82480_;
        double camZ = cam.f_82481_;
        matrixStackIn.m_85836_();
        GL11.glDisable((int)2929);
        BlockOverlayHandler.drawShapeOutline(matrixStackIn, Shapes.m_83064_((AABB)aabbIn), (double)pos.m_123341_() - camX, (double)pos.m_123342_() - camY, (double)pos.m_123343_() - camZ, red, green, blue, alpha, pos, aimed);
        GL11.glEnable((int)2929);
        matrixStackIn.m_85849_();
    }

    private static void drawShapeOutline(PoseStack matrixStack, VoxelShape voxelShape, double originX, double originY, double originZ, float red, float green, float blue, float alpha, BlockPos pos, BlockPos aimed) {
        PoseStack.Pose pose = matrixStack.m_85850_();
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer bufferIn = renderTypeBuffer.m_6299_(RenderType.m_110504_());
        voxelShape.m_83224_((x0, y0, z0, x1, y1, z1) -> {
            if (!pos.equals((Object)aimed)) {
                bufferIn.m_252986_(pose.m_252922_(), (float)(x0 + originX), (float)(y0 + originY), (float)(z0 + originZ)).m_85950_(red, green, blue, alpha).m_252939_(pose.m_252943_(), (float)(x1 - x0), (float)(y1 - y0), (float)(z1 - z0)).m_5752_();
                bufferIn.m_252986_(pose.m_252922_(), (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).m_85950_(red, green, blue, alpha).m_252939_(pose.m_252943_(), (float)(x1 - x0), (float)(y1 - y0), (float)(z1 - z0)).m_5752_();
            }
        });
        renderTypeBuffer.m_109912_(RenderType.m_110504_());
    }

    public void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer renderBuffer, Vector3f blpos, Vector3f brpos, Vector3f trpos, Vector3f tlpos, Vec2 blUVpos, Vec2 brUVpos, Vec2 trUVpos, Vec2 tlUVpos, Vector3f normalVector, Color color, int lightmapValue) {
        BlockOverlayHandler.addQuadVertex(matrixPos, matrixNormal, renderBuffer, blpos, blUVpos, normalVector, color, lightmapValue);
        BlockOverlayHandler.addQuadVertex(matrixPos, matrixNormal, renderBuffer, brpos, brUVpos, normalVector, color, lightmapValue);
        BlockOverlayHandler.addQuadVertex(matrixPos, matrixNormal, renderBuffer, trpos, trUVpos, normalVector, color, lightmapValue);
        BlockOverlayHandler.addQuadVertex(matrixPos, matrixNormal, renderBuffer, tlpos, tlUVpos, normalVector, color, lightmapValue);
    }

    static void addQuadVertex(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer renderBuffer, Vector3f pos, Vec2 texUV, Vector3f normalVector, Color color, int lightmapValue) {
        renderBuffer.m_252986_(matrixPos, pos.x(), pos.y(), pos.z()).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(texUV.f_82470_, texUV.f_82471_).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmapValue).m_252939_(matrixNormal, normalVector.x(), normalVector.y(), normalVector.z()).m_5752_();
    }

    public static void addFusionReactor(BlockPos pos) {
        if (!fusionReactors.contains(pos)) {
            fusionReactors.add(pos);
        }
    }

    public static void removeFusionReactor(BlockPos pos) {
        if (fusionReactors.contains(pos)) {
            fusionReactors.remove(pos);
        }
    }

    public static void addToOutline(NCBlockPos ncBlockPos) {
        if (!outlineBlocks.contains((Object)ncBlockPos)) {
            outlineBlocks.add(ncBlockPos);
        }
    }

    public static void removeFromOutline(NCBlockPos ncBlockPos) {
        if (outlineBlocks.contains((Object)ncBlockPos)) {
            outlineBlocks.remove((Object)ncBlockPos);
        }
    }
}

