/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.event.client;

import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.multiblock.fission.FissionReactor;
import igentuman.nc.radiation.ItemRadiation;
import igentuman.nc.radiation.ItemShielding;
import igentuman.nc.radiation.RadiationCleaningItems;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="nuclearcraft", value={Dist.CLIENT})
public class TooltipHandler {
    private static ItemTooltipEvent processedEvent;

    public static void register(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(TooltipHandler::handle);
    }

    @SubscribeEvent
    public static void handle(ItemTooltipEvent event) {
        if (event.equals(processedEvent)) {
            return;
        }
        processedEvent = event;
        Item item = event.getItemStack().m_41720_();
        TooltipHandler.miscTooltips(event, event.getItemStack());
        TooltipHandler.addRadiationLevelTooltip(event, item);
        TooltipHandler.addShieldingTooltip(event, event.getItemStack());
        TooltipHandler.addRadiationCleaningEffect(event, event.getItemStack());
        TooltipHandler.addModeratorTooltip(event, event.getItemStack());
    }

    private static void addModeratorTooltip(ItemTooltipEvent event, ItemStack itemStack) {
        for (Block block : FissionReactor.moderators) {
            if (!itemStack.m_150930_(block.m_5456_())) continue;
            event.getToolTip().add(Component.m_237110_((String)"tooltip.nc.moderator.desc", (Object[])new Object[]{FissionConfig.FISSION_CONFIG.MODERATOR_FE_MULTIPLIER.get(), FissionConfig.FISSION_CONFIG.MODERATOR_HEAT_MULTIPLIER.get()}).m_130940_(ChatFormatting.GOLD));
        }
    }

    private static void miscTooltips(ItemTooltipEvent event, ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return;
        }
        assert (itemStack.m_41783_() != null);
        if (itemStack.m_41783_().m_128441_("is_nc_analyzed")) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.nc.analyzed").m_130940_(ChatFormatting.GOLD));
            if (itemStack.m_41720_().equals(Items.f_42573_)) {
                event.getToolTip().add(Component.m_237115_((String)"tooltip.nc.use_in_leacher").m_130940_(ChatFormatting.GOLD));
            }
        }
    }

    private static void addRadiationCleaningEffect(ItemTooltipEvent event, ItemStack itemStack) {
        long radiation = RadiationCleaningItems.byItem(itemStack.m_41720_());
        if (radiation == 0L) {
            return;
        }
        ChatFormatting color = ChatFormatting.GREEN;
        event.getToolTip().add(Component.m_237110_((String)"tooltip.nc.radiation_removal", (Object[])new Object[]{TooltipHandler.format((double)radiation / 1.0E9) + "Rad"}).m_130940_(color));
    }

    private static void addShieldingTooltip(ItemTooltipEvent event, ItemStack item) {
        int shielding = ItemShielding.byItem(item.m_41720_());
        if (!(item.m_41782_() && item.m_41783_().m_128441_("rad_shielding") || shielding != 0)) {
            return;
        }
        ChatFormatting color = ChatFormatting.GOLD;
        if (item.m_41782_() && item.m_41783_().m_128441_("rad_shielding")) {
            shielding += item.m_41783_().m_128451_("rad_shielding");
        }
        event.getToolTip().add(Component.m_237110_((String)"tooltip.nc.rad_shielding", (Object[])new Object[]{shielding}).m_130940_(color));
    }

    private static void addRadiationLevelTooltip(ItemTooltipEvent event, Item item) {
        double radiation = ItemRadiation.byItem(item);
        ChatFormatting color = ChatFormatting.GRAY;
        if (radiation > 0.0) {
            if (radiation > 1.0E-4) {
                color = ChatFormatting.YELLOW;
            }
            if (radiation > 0.001) {
                color = ChatFormatting.GOLD;
            }
            if (radiation > 0.1) {
                color = ChatFormatting.RED;
            }
            event.getToolTip().add(Component.m_237110_((String)"tooltip.nc.radiation", (Object[])new Object[]{TooltipHandler.format(radiation) + "Rad/s"}).m_130940_(color));
        }
    }

    private static String format(Double radiation) {
        if (radiation >= 1.0) {
            return String.format(Locale.US, "%.0f", radiation) + " ";
        }
        if (radiation >= 9.99E-4) {
            return String.format(Locale.US, "%.0f", radiation * 1000.0) + " m";
        }
        if (radiation >= 9.99E-7) {
            return String.format(Locale.US, "%.0f", radiation * 1000000.0) + " u";
        }
        return String.format(Locale.US, "%.0f", radiation * 1.0E9) + " p";
    }
}

