/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.sided.capability;

import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import java.util.HashMap;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractCapabilityHandler {
    public int inputSlots;
    public int outputSlots;
    public BlockEntity tile;
    public boolean sideMapUpdated = true;
    public HashMap<Integer, SlotModePair[]> sideMap;
    public SidedContentHandler sidedContentHandler;

    protected void initDefault() {
        this.sideMap = new HashMap();
        for (SidedContentHandler.RelativeDirection side : SidedContentHandler.RelativeDirection.values()) {
            int i;
            SlotModePair[] defaultSide = new SlotModePair[this.inputSlots + this.outputSlots];
            for (i = 0; i < this.inputSlots; ++i) {
                defaultSide[i] = new SlotModePair(SlotModePair.SlotMode.INPUT, i);
            }
            for (i = this.inputSlots; i < this.inputSlots + this.outputSlots; ++i) {
                defaultSide[i] = new SlotModePair(SlotModePair.SlotMode.OUTPUT, i);
            }
            this.sideMap.put(side.ordinal(), defaultSide);
        }
    }

    public SidedContentHandler.SlotType getType(int slot) {
        return slot < this.inputSlots ? SidedContentHandler.SlotType.INPUT : SidedContentHandler.SlotType.OUTPUT;
    }

    public SlotModePair.SlotMode getMode(int slot, int side) {
        return this.sideMap.get(side)[slot].getMode();
    }

    public int toggleMode(int slot, int side) {
        SlotModePair[] sideSlots = this.sideMap.get(side);
        SlotModePair slotModePair = sideSlots[slot];
        SlotModePair.SlotMode mode = slotModePair.getMode();
        this.sideMapUpdated = true;
        if (this.getType(slot) == SidedContentHandler.SlotType.INPUT) {
            switch (mode) {
                case DISABLED: {
                    sideSlots[slot] = new SlotModePair(SlotModePair.SlotMode.INPUT, slot);
                    break;
                }
                case INPUT: {
                    sideSlots[slot] = new SlotModePair(SlotModePair.SlotMode.PULL, slot);
                    break;
                }
                case PULL: {
                    sideSlots[slot] = new SlotModePair(SlotModePair.SlotMode.DISABLED, slot);
                }
            }
        } else {
            switch (mode) {
                case DISABLED: {
                    sideSlots[slot] = new SlotModePair(SlotModePair.SlotMode.OUTPUT, slot);
                    break;
                }
                case OUTPUT: {
                    sideSlots[slot] = new SlotModePair(SlotModePair.SlotMode.PUSH, slot);
                    break;
                }
                case PUSH: {
                    sideSlots[slot] = new SlotModePair(SlotModePair.SlotMode.PUSH_EXCESS, slot);
                    break;
                }
                case PUSH_EXCESS: {
                    sideSlots[slot] = new SlotModePair(SlotModePair.SlotMode.DISABLED, slot);
                }
            }
        }
        this.sidedContentHandler.hasPush = this.hasPush();
        this.sidedContentHandler.hasPull = this.hasPull();
        return sideSlots[slot].getMode().ordinal();
    }

    public boolean hasPull() {
        for (SlotModePair[] slotModePairs : this.sideMap.values()) {
            for (SlotModePair slotModePair : slotModePairs) {
                if (slotModePair.getMode() != SlotModePair.SlotMode.PULL) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPush() {
        for (SlotModePair[] slotModePairs : this.sideMap.values()) {
            for (SlotModePair slotModePair : slotModePairs) {
                if (slotModePair.getMode() != SlotModePair.SlotMode.PUSH && slotModePair.getMode() != SlotModePair.SlotMode.PUSH_EXCESS) continue;
                return true;
            }
        }
        return false;
    }

    protected Direction getFacing() {
        Direction facing = Direction.NORTH;
        if (this.tile == null) {
            return facing;
        }
        if (this.tile.m_58900_().m_61138_((Property)BlockStateProperties.f_61374_)) {
            facing = (Direction)this.tile.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return facing;
    }

    public boolean haveAccessFromSide(Direction side, int slot) {
        SidedContentHandler.RelativeDirection relativeDirection = SidedContentHandler.RelativeDirection.toRelative(side, this.getFacing());
        return this.sideMap.get(relativeDirection.ordinal())[slot].getMode() != SlotModePair.SlotMode.DISABLED;
    }

    public void setGlobalMode(int i, SlotModePair.SlotMode slotMode) {
        for (SidedContentHandler.RelativeDirection dir : SidedContentHandler.RelativeDirection.values()) {
            this.sideMap.get(dir.ordinal())[i].setMode(slotMode);
        }
    }

    protected void onLoad() {
        this.sidedContentHandler.hasPush = this.hasPush();
        this.sidedContentHandler.hasPull = this.hasPull();
    }
}

