/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.fission;

import igentuman.nc.block.entity.fission.FissionCasingBE;
import igentuman.nc.block.entity.fission.FissionControllerBE;
import igentuman.nc.block.entity.fission.FissionFuelCellBE;
import igentuman.nc.block.entity.fission.FissionHeatSinkBE;
import igentuman.nc.block.entity.fission.FissionIrradiationChamberBE;
import igentuman.nc.block.entity.fission.FissionModeratorBE;
import igentuman.nc.block.entity.fission.FissionPortBE;
import igentuman.nc.block.fission.FissionBlock;
import igentuman.nc.block.fission.FissionCasingSlopeBlock;
import igentuman.nc.block.fission.FissionControllerBlock;
import igentuman.nc.block.fission.FissionPort;
import igentuman.nc.block.fission.HeatSinkBlock;
import igentuman.nc.block.fission.IrradiationChamberBlock;
import igentuman.nc.container.FissionControllerContainer;
import igentuman.nc.container.FissionPortContainer;
import igentuman.nc.multiblock.fission.FissionBlocks;
import igentuman.nc.setup.Registration;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.util.NcUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FissionReactor {
    public static final Item.Properties FISSION_ITEM_PROPS = new Item.Properties();
    private static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"nuclearcraft");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"nuclearcraft");
    public static HashMap<String, RegistryObject<Block>> FISSION_BLOCKS = new HashMap();
    public static HashMap<String, RegistryObject<BlockEntityType<? extends BlockEntity>>> FISSION_BE = new HashMap();
    public static HashMap<String, RegistryObject<Item>> FISSION_BLOCK_ITEMS = new HashMap();
    public static final RegistryObject<MenuType<FissionControllerContainer>> FISSION_CONTROLLER_CONTAINER = CONTAINERS.register("fission_reactor_controller", () -> IForgeMenuType.create((windowId, inv, data) -> new FissionControllerContainer(windowId, data.m_130135_(), inv)));
    public static final RegistryObject<MenuType<FissionPortContainer>> FISSION_PORT_CONTAINER = CONTAINERS.register("fission_reactor_port", () -> IForgeMenuType.create((windowId, inv, data) -> new FissionPortContainer(windowId, data.m_130135_(), inv)));
    public static List<Block> moderators = new ArrayList<Block>();
    private static List<RegistryObject<Block>> hsBlocks = new ArrayList<RegistryObject<Block>>();

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCK_ENTITIES.register(bus);
        CONTAINERS.register(bus);
        FissionReactor.blocks();
    }

    public static List<Block> moderators() {
        if (moderators.isEmpty()) {
            Block beryllium;
            Block graphite = NcUtils.getNCBlock("graphite");
            if (!graphite.equals(Blocks.f_50016_)) {
                moderators.add(graphite);
            }
            if (!(beryllium = NcUtils.getNCBlock("beryllium")).equals(Blocks.f_50016_)) {
                moderators.add(beryllium);
            }
        }
        return moderators;
    }

    public static void blocks() {
        for (String name : FissionBlocks.reactor) {
            String key = "fission_reactor_" + name;
            if (name.contains("controller")) {
                FISSION_BLOCKS.put(key, (RegistryObject<Block>)Registration.BLOCKS.register(key, () -> new FissionControllerBlock(FissionBlocks.REACTOR_BLOCKS_PROPERTIES)));
                FISSION_BE.put(key, (RegistryObject<BlockEntityType<? extends BlockEntity>>)BLOCK_ENTITIES.register(key, () -> BlockEntityType.Builder.m_155273_(FissionControllerBE::new, (Block[])new Block[]{(Block)FISSION_BLOCKS.get(key).get()}).m_58966_(null)));
            } else if (name.contains("port")) {
                FISSION_BLOCKS.put(key, (RegistryObject<Block>)Registration.BLOCKS.register(key, () -> new FissionPort(FissionBlocks.REACTOR_BLOCKS_PROPERTIES)));
                FISSION_BE.put(key, (RegistryObject<BlockEntityType<? extends BlockEntity>>)BLOCK_ENTITIES.register(key, () -> BlockEntityType.Builder.m_155273_(FissionPortBE::new, (Block[])new Block[]{(Block)FISSION_BLOCKS.get(key).get()}).m_58966_(null)));
            } else if (name.contains("irradiation")) {
                FISSION_BLOCKS.put(key, (RegistryObject<Block>)Registration.BLOCKS.register(key, () -> new IrradiationChamberBlock(FissionBlocks.REACTOR_BLOCKS_PROPERTIES)));
                FISSION_BE.put(key, (RegistryObject<BlockEntityType<? extends BlockEntity>>)BLOCK_ENTITIES.register(key, () -> BlockEntityType.Builder.m_155273_(FissionIrradiationChamberBE::new, (Block[])new Block[]{(Block)FISSION_BLOCKS.get(key).get()}).m_58966_(null)));
            } else {
                BlockBehaviour.Properties props = key.matches(".*glass|.*cell.*") ? BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_60978_(1.0f).m_60999_().m_60955_() : FissionBlocks.REACTOR_BLOCKS_PROPERTIES;
                if (name.contains("slope")) {
                    FISSION_BLOCKS.put(key, (RegistryObject<Block>)Registration.BLOCKS.register(key, () -> new FissionCasingSlopeBlock(props)));
                } else {
                    FISSION_BLOCKS.put(key, (RegistryObject<Block>)Registration.BLOCKS.register(key, () -> new FissionBlock(props)));
                }
            }
            FISSION_BLOCK_ITEMS.put(key, FissionReactor.fromMultiblock(FISSION_BLOCKS.get(key)));
            NCItems.ALL_NC_ITEMS.put(key, FISSION_BLOCK_ITEMS.get(key));
        }
        for (String name : FissionBlocks.heatsinks.keySet()) {
            FISSION_BLOCKS.put(name + "_heat_sink", (RegistryObject<Block>)Registration.BLOCKS.register(name + "_heat_sink", () -> new HeatSinkBlock(FissionBlocks.REACTOR_BLOCKS_PROPERTIES, FissionBlocks.heatsinks.get(name))));
            FISSION_BLOCK_ITEMS.put(name + "_heat_sink", FissionReactor.fromMultiblock(FISSION_BLOCKS.get(name + "_heat_sink")));
            NCItems.ALL_NC_ITEMS.put(name + "_heat_sink", FISSION_BLOCK_ITEMS.get(name + "_heat_sink"));
            if (name.matches("empty|active")) continue;
            hsBlocks.add(FISSION_BLOCKS.get(name + "_heat_sink"));
        }
        FISSION_BE.put("fission_heat_sink", (RegistryObject<BlockEntityType<? extends BlockEntity>>)BLOCK_ENTITIES.register("fission_heat_sink", () -> BlockEntityType.Builder.m_155273_(FissionHeatSinkBE::new, (Block[])FissionReactor.getHSBlocks()).m_58966_(null)));
        FISSION_BE.put("fission_moderator", (RegistryObject<BlockEntityType<? extends BlockEntity>>)BLOCK_ENTITIES.register("fission_moderator", () -> BlockEntityType.Builder.m_155273_(FissionModeratorBE::new, (Block[])FissionReactor.moderators().toArray(new Block[0])).m_58966_(null)));
        FISSION_BE.put("fission_casing", (RegistryObject<BlockEntityType<? extends BlockEntity>>)BLOCK_ENTITIES.register("fission_casing", () -> BlockEntityType.Builder.m_155273_(FissionCasingBE::new, (Block[])new Block[]{(Block)FISSION_BLOCKS.get("fission_reactor_casing").get(), (Block)FISSION_BLOCKS.get("fission_reactor_glass").get()}).m_58966_(null)));
        FISSION_BE.put("fission_reactor_fuel_cell", (RegistryObject<BlockEntityType<? extends BlockEntity>>)BLOCK_ENTITIES.register("fission_reactor_fuel_cell", () -> BlockEntityType.Builder.m_155273_(FissionFuelCellBE::new, (Block[])new Block[]{(Block)FISSION_BLOCKS.get("fission_reactor_solid_fuel_cell").get()}).m_58966_(null)));
    }

    public static Block[] getHSBlocks() {
        Block[] blocks = new Block[hsBlocks.size()];
        int i = 0;
        for (RegistryObject<Block> b : hsBlocks) {
            blocks[i] = (Block)b.get();
            ++i;
        }
        return blocks;
    }

    public static <B extends Block> RegistryObject<Item> fromMultiblock(RegistryObject<B> block) {
        return Registration.ITEMS.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), FISSION_ITEM_PROPS));
    }
}

