/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.fission;

import igentuman.nc.block.entity.fission.FissionControllerBE;
import igentuman.nc.block.entity.fission.FissionFuelCellBE;
import igentuman.nc.block.entity.fission.FissionHeatSinkBE;
import igentuman.nc.block.entity.fission.FissionIrradiationChamberBE;
import igentuman.nc.block.entity.fission.FissionModeratorBE;
import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.multiblock.AbstractNCMultiblock;
import igentuman.nc.multiblock.fission.FissionBlocks;
import igentuman.nc.multiblock.fission.FissionReactorController;
import igentuman.nc.util.NCBlockPos;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FissionReactorMultiblock
extends AbstractNCMultiblock {
    private int irradiationConnections = 0;
    public HashMap<BlockPos, FissionHeatSinkBE> activeHeatSinks = new HashMap();
    private List<BlockPos> moderators = new ArrayList<BlockPos>();
    private List<BlockPos> irradiators = new ArrayList<BlockPos>();
    public List<BlockPos> heatSinks = new ArrayList<BlockPos>();
    public List<BlockPos> fuelCells = new ArrayList<BlockPos>();
    private double heatSinkCooling = 0.0;

    @Override
    public int maxHeight() {
        return (Integer)FissionConfig.FISSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int maxWidth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int maxDepth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int minHeight() {
        return (Integer)FissionConfig.FISSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int minWidth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int minDepth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MIN_SIZE.get();
    }

    public FissionReactorMultiblock(FissionControllerBE<?> fissionControllerBE) {
        super(TagUtil.getBlocksByTagKey(FissionBlocks.CASING_BLOCKS.f_203868_().toString()), TagUtil.getBlocksByTagKey(FissionBlocks.INNER_REACTOR_BLOCKS.f_203868_().toString()));
        this.controller = new FissionReactorController(fissionControllerBE);
    }

    public Map<BlockPos, FissionHeatSinkBE> activeHeatSinks() {
        if (this.activeHeatSinks.isEmpty()) {
            for (BlockPos hpos : this.heatSinks) {
                FissionHeatSinkBE hs;
                BlockEntity be = this.getBlockEntity(hpos);
                if (!(be instanceof FissionHeatSinkBE) || !(hs = (FissionHeatSinkBE)be).isValid(true)) continue;
                this.activeHeatSinks.put(hpos, hs);
            }
        }
        ((FissionControllerBE)this.controller().controllerBE()).heatSinksCount = this.activeHeatSinks.size();
        return this.activeHeatSinks;
    }

    public static boolean isModerator(BlockPos pos, Level level) {
        return level.m_7702_(pos) instanceof FissionModeratorBE;
    }

    public boolean isModerator(BlockPos pos) {
        return this.getBlockEntity(pos) instanceof FissionModeratorBE;
    }

    public boolean isIrradiator(BlockPos pos) {
        return this.getBlockEntity(pos) instanceof FissionIrradiationChamberBE;
    }

    protected boolean isHeatSink(BlockPos pos) {
        return this.getBlockEntity(pos) instanceof FissionHeatSinkBE;
    }

    protected boolean isFuelCell(BlockPos pos) {
        return this.getBlockEntity(pos) instanceof FissionFuelCellBE;
    }

    private boolean isAttachedToFuelCell(BlockPos toCheck) {
        for (Direction d : Direction.values()) {
            if (toCheck instanceof NCBlockPos) {
                ((NCBlockPos)toCheck).revert();
            }
            if (!this.isFuelCell(toCheck.m_121945_(d))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validateInner() {
        super.validateInner();
        this.heatSinkCooling = this.getHeatSinkCooling(true);
        FissionControllerBE controller = (FissionControllerBE)this.controller().controllerBE();
        controller.fuelCellsCount = this.fuelCells.size();
        controller.moderatorsCount = this.moderators.size();
        controller.irradiationConnections = this.irradiationConnections;
    }

    @Override
    protected boolean processInnerBlock(BlockPos toCheck) {
        BlockEntity be = this.getBlockEntity(toCheck);
        if (this.isFuelCell(toCheck)) {
            this.fuelCells.add(toCheck);
            int moderatorAttachments = ((FissionFuelCellBE)be).getAttachedModeratorsCount(true);
            ((FissionControllerBE)this.controller().controllerBE()).fuelCellMultiplier += this.countAdjuscentFuelCells((NCBlockPos)toCheck, 3);
            ((FissionControllerBE)this.controller().controllerBE()).moderatorCellMultiplier += (this.countAdjuscentFuelCells((NCBlockPos)toCheck, 1) + 1) * moderatorAttachments;
            ((FissionControllerBE)this.controller().controllerBE()).moderatorAttacmentsCount += moderatorAttachments;
        }
        if (this.isModerator(toCheck) && this.isAttachedToFuelCell(toCheck)) {
            this.moderators.add(toCheck);
        }
        if (this.isHeatSink(toCheck)) {
            this.heatSinks.add(toCheck);
        }
        if (this.isIrradiator(toCheck)) {
            this.irradiators.add(toCheck);
            this.countIrradiationConnections(toCheck);
        }
        return true;
    }

    private void countIrradiationConnections(BlockPos toCheck) {
        FissionIrradiationChamberBE be = (FissionIrradiationChamberBE)this.getBlockEntity(toCheck);
        assert (be != null);
        be.countIrradiationConnections();
        this.irradiationConnections += be.irradiationConnections;
    }

    private int countAdjuscentFuelCells(NCBlockPos toCheck, int step) {
        int count = 0;
        for (Direction d : Direction.values()) {
            if (this.isFuelCell(toCheck.revert().relative(d))) {
                count += step;
                continue;
            }
            if (!this.isModerator(toCheck.revert().relative(d)) || !this.isFuelCell(toCheck.revert().relative(d, 2))) continue;
            count += step;
        }
        return count;
    }

    @Override
    public void invalidateStats() {
        this.controller().clearStats();
        this.moderators.clear();
        this.irradiators.clear();
        this.fuelCells.clear();
        this.heatSinks.clear();
        this.activeHeatSinks.clear();
        this.irradiationConnections = 0;
    }

    @Override
    protected Direction getFacing() {
        return ((FissionControllerBE)this.controller().controllerBE()).getFacing();
    }

    public double getHeatSinkCooling(boolean forceCheck) {
        if (this.refreshInnerCacheFlag || forceCheck) {
            this.heatSinkCooling = 0.0;
            for (FissionHeatSinkBE hs : this.activeHeatSinks().values()) {
                this.heatSinkCooling += hs.getHeat();
            }
        }
        return this.heatSinkCooling;
    }
}

