/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.fusion;

import igentuman.nc.block.entity.ElectromagnetBE;
import igentuman.nc.block.entity.RFAmplifierBE;
import igentuman.nc.block.entity.fusion.FusionCasingBE;
import igentuman.nc.block.entity.fusion.FusionConnectorBE;
import igentuman.nc.block.entity.fusion.FusionCoreBE;
import igentuman.nc.handler.config.FusionConfig;
import igentuman.nc.multiblock.AbstractNCMultiblock;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.fusion.FusionReactor;
import igentuman.nc.multiblock.fusion.FusionReactorController;
import igentuman.nc.util.NCBlockPos;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FusionReactorMultiblock
extends AbstractNCMultiblock {
    public int magnetsEfficiency = 0;
    public int rfEfficiency = 0;
    protected FusionCoreBE<?> controllerBE;
    protected int length = 0;
    public double magneticFieldStrength = 0.0;
    public int magnetsPower = 0;
    public int maxMagnetsTemp = 0;
    public int rfAmplification = 0;
    public int rfAmplifiersPower = 0;
    public int maxRFAmplifiersTemp = 0;
    protected boolean connectorsValid = false;
    protected boolean ringValid = false;
    protected boolean needToCollectFunctionalBlocks = true;
    public boolean needToRecalculateCharacteristics = true;
    protected HashMap<BlockPos, ElectromagnetBE> electromagnets = new HashMap();
    protected HashMap<BlockPos, RFAmplifierBE> amplifiers = new HashMap();

    public boolean isReadyToProcess() {
        return this.isFormed && this.outerValid && this.innerValid && !this.needToRecalculateCharacteristics && !this.needToCollectFunctionalBlocks;
    }

    public FusionReactorMultiblock(FusionCoreBE<?> core) {
        super(List.of((Block)FusionReactor.FUSION_BLOCKS.get("fusion_reactor_casing").get(), (Block)FusionReactor.FUSION_BLOCKS.get("fusion_reactor_casing_glass").get()), List.of(Blocks.f_50016_));
        this.controllerBE = core;
        this.controller = new FusionReactorController(this.controllerBE);
    }

    @Override
    public int height() {
        return 3;
    }

    @Override
    public int width() {
        return this.length;
    }

    @Override
    public int depth() {
        return this.length;
    }

    @Override
    public int maxHeight() {
        return 3;
    }

    @Override
    public int minHeight() {
        return 3;
    }

    @Override
    public int maxWidth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int minWidth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int maxDepth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int minDepth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public final List<Block> validOuterBlocks() {
        return this.validOuterBlocks;
    }

    @Override
    public List<Block> validInnerBlocks() {
        return this.validInnerBlocks;
    }

    @Override
    public void validateOuter() {
        this.validateConnectors();
        this.validateRing();
        boolean bl = this.outerValid = this.ringValid && this.connectorsValid;
        if (this.outerValid) {
            this.validationResult = ValidationResult.VALID;
        }
    }

    @Override
    public void validate() {
        super.validate();
        this.needToCollectFunctionalBlocks = this.isFormed;
    }

    @Override
    public void onBlockDestroyed(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (this.controllerBE.plasmaTemperature > 100000L) {
            // empty if block
        }
        this.controller.clearStats();
    }

    public void collectFunctionalParts() {
        this.electromagnets.clear();
        this.amplifiers.clear();
        NCBlockPos pos = new NCBlockPos((Vec3i)this.controllerBE.m_58899_());
        Iterator<Direction> iterator = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).iterator();
        while (iterator.hasNext()) {
            RFAmplifierBE amplifier;
            ElectromagnetBE magnet;
            BlockEntity blockEntity;
            int i;
            Direction side;
            Direction dir = side = iterator.next();
            int steps = this.length * 2 + 3;
            int shift = this.length + 1;
            NCBlockPos startPosInnerWall = null;
            NCBlockPos startPosOuterWall = null;
            Level level = this.controllerBE.m_58904_();
            switch (side) {
                case NORTH: {
                    dir = Direction.EAST;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, shift).relative(Direction.WEST, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, 2 + shift).relative(Direction.WEST, 1 + shift));
                    break;
                }
                case SOUTH: {
                    dir = Direction.WEST;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, shift).relative(Direction.EAST, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, 2 + shift).relative(Direction.EAST, 1 + shift));
                    break;
                }
                case WEST: {
                    dir = Direction.SOUTH;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, shift).relative(Direction.NORTH, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, 2 + shift).relative(Direction.NORTH, 1 + shift));
                    break;
                }
                case EAST: {
                    dir = Direction.NORTH;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, shift).relative(Direction.SOUTH, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, 2 + shift).relative(Direction.SOUTH, 1 + shift));
                }
            }
            for (i = 0; i < steps; ++i) {
                blockEntity = level.m_7702_((BlockPos)startPosInnerWall.revert().relative(dir, i));
                if (blockEntity instanceof ElectromagnetBE) {
                    magnet = (ElectromagnetBE)blockEntity;
                    this.electromagnets.put(new NCBlockPos((Vec3i)startPosInnerWall), magnet);
                } else {
                    blockEntity = level.m_7702_((BlockPos)startPosInnerWall.revert().relative(dir, i));
                    if (blockEntity instanceof RFAmplifierBE) {
                        amplifier = (RFAmplifierBE)blockEntity;
                        this.amplifiers.put(new NCBlockPos((Vec3i)startPosInnerWall), amplifier);
                    }
                }
                blockEntity = level.m_7702_((BlockPos)startPosInnerWall.revert().relative(Direction.UP, 2).relative(dir, i));
                if (blockEntity instanceof ElectromagnetBE) {
                    magnet = (ElectromagnetBE)blockEntity;
                    this.electromagnets.put(new NCBlockPos((Vec3i)startPosInnerWall), magnet);
                    continue;
                }
                blockEntity = level.m_7702_((BlockPos)startPosInnerWall.revert().relative(Direction.UP, 2).relative(dir, i));
                if (!(blockEntity instanceof RFAmplifierBE)) continue;
                amplifier = (RFAmplifierBE)blockEntity;
                this.amplifiers.put(new NCBlockPos((Vec3i)startPosInnerWall), amplifier);
            }
            for (i = 0; i < steps + 2; ++i) {
                blockEntity = level.m_7702_((BlockPos)startPosOuterWall.revert().relative(dir, i));
                if (blockEntity instanceof ElectromagnetBE) {
                    magnet = (ElectromagnetBE)blockEntity;
                    this.electromagnets.put(new NCBlockPos((Vec3i)startPosOuterWall), magnet);
                } else {
                    blockEntity = level.m_7702_((BlockPos)startPosOuterWall.revert().relative(dir, i));
                    if (blockEntity instanceof RFAmplifierBE) {
                        amplifier = (RFAmplifierBE)blockEntity;
                        this.amplifiers.put(new NCBlockPos((Vec3i)startPosOuterWall), amplifier);
                    }
                }
                blockEntity = level.m_7702_((BlockPos)startPosOuterWall.revert().relative(Direction.UP, 2).relative(dir, i));
                if (blockEntity instanceof ElectromagnetBE) {
                    magnet = (ElectromagnetBE)blockEntity;
                    this.electromagnets.put(new NCBlockPos((Vec3i)startPosOuterWall), magnet);
                    continue;
                }
                blockEntity = level.m_7702_((BlockPos)startPosOuterWall.revert().relative(Direction.UP, 2).relative(dir, i));
                if (!(blockEntity instanceof RFAmplifierBE)) continue;
                amplifier = (RFAmplifierBE)blockEntity;
                this.amplifiers.put(new NCBlockPos((Vec3i)startPosOuterWall), amplifier);
            }
        }
    }

    private void validateRing() {
        NCBlockPos pos = new NCBlockPos((Vec3i)this.controllerBE.m_58899_().m_121945_(Direction.UP));
        this.ringValid = true;
        Iterator<Direction> iterator = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).iterator();
        while (iterator.hasNext()) {
            BlockEntity blockEntity;
            int i;
            Direction side;
            Direction dir = side = iterator.next();
            int steps = this.length * 2 + 3;
            int shift = this.length + 1;
            NCBlockPos startPosInnerWall = null;
            NCBlockPos startPosOuterWall = null;
            NCBlockPos startPosBottomWall = null;
            NCBlockPos startPosTopWall = null;
            Level level = this.controllerBE.m_58904_();
            switch (side) {
                case NORTH: {
                    dir = Direction.EAST;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, shift).relative(Direction.WEST, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, 2 + shift).relative(Direction.WEST, 1 + shift));
                    startPosBottomWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, 1 + shift).relative(Direction.WEST, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, 1 + shift).relative(Direction.WEST, 1 + shift).relative(Direction.UP));
                    break;
                }
                case SOUTH: {
                    dir = Direction.WEST;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, shift).relative(Direction.EAST, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, 2 + shift).relative(Direction.EAST, 1 + shift));
                    startPosBottomWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, 1 + shift).relative(Direction.EAST, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, 1 + shift).relative(Direction.EAST, 1 + shift).relative(Direction.UP));
                    break;
                }
                case WEST: {
                    dir = Direction.SOUTH;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, shift).relative(Direction.NORTH, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, 2 + shift).relative(Direction.NORTH, 1 + shift));
                    startPosBottomWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, 1 + shift).relative(Direction.NORTH, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, 1 + shift).relative(Direction.NORTH, 1 + shift).relative(Direction.UP));
                    break;
                }
                case EAST: {
                    dir = Direction.NORTH;
                    startPosInnerWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, shift).relative(Direction.SOUTH, shift));
                    startPosOuterWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, 2 + shift).relative(Direction.SOUTH, 1 + shift));
                    startPosBottomWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, 1 + shift).relative(Direction.SOUTH, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, 1 + shift).relative(Direction.SOUTH, 1 + shift).relative(Direction.UP));
                }
            }
            for (i = 0; i < steps; ++i) {
                blockEntity = level.m_7702_((BlockPos)startPosInnerWall.revert().relative(dir, i));
                if (!(blockEntity instanceof FusionCasingBE)) {
                    this.ringValid = false;
                    this.validationResult = ValidationResult.WRONG_OUTER;
                    this.controller().addErroredBlock(startPosInnerWall);
                    return;
                }
                FusionCasingBE casing = (FusionCasingBE)blockEntity;
                casing.setController(this.controllerBE);
                this.allBlocks.add(new NCBlockPos((Vec3i)startPosInnerWall));
                this.attachMultiblock(casing);
            }
            for (i = 0; i < steps + 2; ++i) {
                blockEntity = level.m_7702_((BlockPos)startPosOuterWall.revert().relative(dir, i));
                if (!(blockEntity instanceof FusionCasingBE)) {
                    this.ringValid = false;
                    this.validationResult = ValidationResult.WRONG_OUTER;
                    this.controller().addErroredBlock(startPosOuterWall);
                    return;
                }
                FusionCasingBE casing1 = (FusionCasingBE)blockEntity;
                casing1.setController(this.controllerBE);
                this.allBlocks.add(new NCBlockPos((Vec3i)startPosOuterWall));
                this.attachMultiblock(casing1);
                BlockEntity blockEntity2 = level.m_7702_((BlockPos)startPosBottomWall.revert().relative(dir, i));
                if (!(blockEntity2 instanceof FusionCasingBE)) {
                    this.ringValid = false;
                    this.validationResult = ValidationResult.WRONG_OUTER;
                    this.controller().addErroredBlock(startPosBottomWall);
                    return;
                }
                FusionCasingBE casing2 = (FusionCasingBE)blockEntity2;
                casing2.setController(this.controllerBE);
                this.allBlocks.add(new NCBlockPos((Vec3i)startPosBottomWall));
                this.attachMultiblock(casing2);
                BlockEntity blockEntity3 = level.m_7702_((BlockPos)startPosTopWall.revert().relative(dir, i));
                if (!(blockEntity3 instanceof FusionCasingBE)) {
                    this.ringValid = false;
                    this.validationResult = ValidationResult.WRONG_OUTER;
                    this.controller().addErroredBlock(startPosTopWall);
                    return;
                }
                FusionCasingBE casing3 = (FusionCasingBE)blockEntity3;
                casing3.setController(this.controllerBE);
                this.allBlocks.add(new NCBlockPos((Vec3i)startPosTopWall));
                this.attachMultiblock(casing3);
            }
        }
    }

    private void validateConnectors() {
        NCBlockPos pos = new NCBlockPos((Vec3i)this.controllerBE.m_58899_().m_7494_());
        this.length = 1;
        this.connectorsValid = true;
        for (int i = 2; i <= this.maxWidth() / 2 + 1; ++i) {
            int connectors = 0;
            for (Direction side : List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST)) {
                BlockEntity blockEntity = this.getBlockEntity(pos.revert().relative(side, i));
                if (!(blockEntity instanceof FusionConnectorBE)) continue;
                FusionConnectorBE connector = (FusionConnectorBE)blockEntity;
                connector.setController(this.controllerBE);
                this.attachMultiblock(connector);
                this.allBlocks.add(new NCBlockPos((Vec3i)pos));
                ++connectors;
            }
            if (connectors == 4) {
                ++this.length;
                continue;
            }
            if (connectors != 0) {
                this.connectorsValid = false;
            } else {
                this.connectorsValid = true;
                this.validationResult = ValidationResult.INCOMPLETE;
                this.controller().addErroredBlock(pos);
            }
            return;
        }
    }

    @Override
    public void validateInner() {
        if (!this.outerValid) {
            return;
        }
        NCBlockPos pos = new NCBlockPos((Vec3i)this.controllerBE.m_58899_().m_121945_(Direction.UP));
        this.innerValid = true;
        Iterator<Direction> iterator = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).iterator();
        while (iterator.hasNext()) {
            Direction side;
            Direction dir = side = iterator.next();
            int steps = this.length * 2 + 3;
            int shift = this.length + 2;
            NCBlockPos innerRingStartPos = null;
            Level level = this.controllerBE.m_58904_();
            switch (side) {
                case NORTH: {
                    dir = Direction.EAST;
                    innerRingStartPos = new NCBlockPos((Vec3i)pos.revert().relative(Direction.NORTH, shift).relative(Direction.WEST, shift));
                    break;
                }
                case SOUTH: {
                    dir = Direction.WEST;
                    innerRingStartPos = new NCBlockPos((Vec3i)pos.revert().relative(Direction.SOUTH, shift).relative(Direction.EAST, shift));
                    break;
                }
                case WEST: {
                    dir = Direction.SOUTH;
                    innerRingStartPos = new NCBlockPos((Vec3i)pos.revert().relative(Direction.WEST, shift).relative(Direction.NORTH, shift));
                    break;
                }
                case EAST: {
                    dir = Direction.NORTH;
                    innerRingStartPos = new NCBlockPos((Vec3i)pos.revert().relative(Direction.EAST, shift).relative(Direction.SOUTH, shift));
                }
            }
            for (int i = 0; i < steps; ++i) {
                if (this.processInnerBlock(innerRingStartPos.revert().relative(dir, i))) continue;
                this.innerValid = false;
                this.validationResult = ValidationResult.WRONG_INNER;
                this.controller().addErroredBlock(innerRingStartPos);
                return;
            }
        }
        this.validationResult = ValidationResult.VALID;
    }

    @Override
    protected boolean processInnerBlock(BlockPos toCheck) {
        return this.validInnerBlocks.contains(this.level().m_8055_(toCheck).m_60734_());
    }

    private Level level() {
        return this.controllerBE.m_58904_();
    }

    @Override
    public void invalidateStats() {
        this.length = 0;
        this.controller().clearStats();
        this.isFormed = false;
        this.hasToRefresh = true;
    }

    @Override
    protected Direction getFacing() {
        return null;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isFormed) {
            if (this.needToCollectFunctionalBlocks) {
                this.collectFunctionalParts();
                this.needToCollectFunctionalBlocks = false;
                this.needToRecalculateCharacteristics = true;
            } else if (this.needToRecalculateCharacteristics) {
                this.recalculateCharacteristics();
                this.needToRecalculateCharacteristics = false;
            }
        }
    }

    public void recalculateCharacteristics() {
        this.magneticFieldStrength = 0.0;
        this.magnetsPower = 0;
        this.maxMagnetsTemp = 1000000;
        this.rfAmplification = 0;
        this.rfAmplifiersPower = 0;
        this.maxRFAmplifiersTemp = 1000000;
        double mEfficiency = 0.0;
        double rEfficiency = 0.0;
        for (ElectromagnetBE magnet : this.electromagnets.values()) {
            this.magneticFieldStrength += magnet.getStrength();
            mEfficiency += (double)((int)magnet.getEfficiency());
            this.magnetsPower += magnet.getPower();
            if (magnet.getMaxTemperature() >= this.maxMagnetsTemp) continue;
            this.maxMagnetsTemp = magnet.getMaxTemperature();
        }
        this.magnetsEfficiency = (int)(mEfficiency / (double)this.electromagnets.size());
        for (RFAmplifierBE amplifier : this.amplifiers.values()) {
            this.rfAmplification += amplifier.getAmplification();
            this.rfAmplifiersPower += amplifier.getPower();
            rEfficiency += (double)((int)amplifier.getEfficiency());
            if (amplifier.getMaxTemperature() >= this.maxRFAmplifiersTemp) continue;
            this.maxRFAmplifiersTemp = amplifier.getMaxTemperature();
        }
        this.rfEfficiency = (int)(rEfficiency / (double)this.amplifiers.size());
    }

    @Override
    public void onNeighborChange(BlockState state, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, pos, neighbor);
        if (!this.hasToRefresh && this.componentChanged(neighbor)) {
            this.needToCollectFunctionalBlocks = true;
        }
    }

    private boolean componentChanged(BlockPos neighbor) {
        block6: {
            block5: {
                BlockEntity be;
                block4: {
                    if (this.electromagnets.containsKey(neighbor) || this.amplifiers.containsKey(neighbor)) {
                        return true;
                    }
                    be = this.level().m_7702_(neighbor);
                    if (!(be instanceof ElectromagnetBE)) break block4;
                    ElectromagnetBE magnet = (ElectromagnetBE)be;
                    break block5;
                }
                if (!(be instanceof RFAmplifierBE)) break block6;
                RFAmplifierBE rFAmplifierBE = (RFAmplifierBE)be;
            }
            return true;
        }
        return false;
    }
}

