/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.network.toClient;

import igentuman.nc.network.INcPacket;
import igentuman.nc.radiation.client.ClientRadiationData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketWorldRadiationData
implements INcPacket {
    private final Map<Long, Long> radiation;

    public PacketWorldRadiationData(long id, Long aLong) {
        this.radiation = new HashMap<Long, Long>();
        this.radiation.put(id, aLong);
    }

    public PacketWorldRadiationData(Map<Long, Long> radiation) {
        this.radiation = radiation;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> ClientRadiationData.setWorldRadiation(this.radiation));
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.radiation.size());
        for (Map.Entry<Long, Long> entry : this.radiation.entrySet()) {
            buffer.writeLong(entry.getKey().longValue());
            buffer.writeLong(entry.getValue().longValue());
        }
    }

    public static PacketWorldRadiationData decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<Long, Long> radiation = new HashMap<Long, Long>();
        for (int i = 0; i < size; ++i) {
            radiation.put(buffer.readLong(), buffer.readLong());
        }
        return new PacketWorldRadiationData(radiation);
    }
}

