/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.radiation;

import igentuman.nc.content.energy.RTGs;
import igentuman.nc.content.fuel.FuelManager;
import igentuman.nc.content.materials.Materials;
import igentuman.nc.handler.config.RadiationConfig;
import igentuman.nc.setup.registration.Fuel;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.util.NcUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemRadiation {
    protected static HashMap<Item, Double> radiationMap = new HashMap();
    protected static boolean initialized = false;

    public static HashMap<Item, Double> get() {
        return radiationMap;
    }

    public static void init() {
        double radiation;
        Item isotope2;
        Item isotope1;
        int isotope2Cnt;
        int isotope1Cnt;
        if (!radiationMap.isEmpty()) {
            return;
        }
        radiationMap.put((Item)NCItems.NC_DUSTS.get("protactinium_233").get(), 1.0);
        radiationMap.put((Item)NCItems.NC_DUSTS.get("strontium_90").get(), 0.034);
        radiationMap.put((Item)NCItems.NC_DUSTS.get("ruthenium_106").get(), 0.98);
        radiationMap.put((Item)NCItems.NC_DUSTS.get("polonium").get(), 0.293);
        radiationMap.put((Item)NCItems.NC_DUSTS.get("promethium_147").get(), 0.38);
        radiationMap.put((Item)NCItems.NC_DUSTS.get("europium_155").get(), 0.21);
        radiationMap.put((Item)NCItems.NC_INGOTS.get("uranium").get(), 7.0E-5);
        radiationMap.put((Item)NCItems.NC_INGOTS.get("thorium").get(), 5.0E-5);
        for (String name : RTGs.registered().keySet()) {
            radiationMap.put(((Block)NCEnergyBlocks.ENERGY_BLOCKS.get(name).get()).m_5456_(), (double)RTGs.registered().get(name).config().getRadiation() / 1.0E9);
        }
        for (String line : (List)RadiationConfig.RADIATION_CONFIG.ITEM_RADIATION.get()) {
            Item item;
            String[] split = line.split("\\|");
            if (split.length != 2 || (item = ItemRadiation.getItemByName(split[0].trim())).equals(Items.f_41852_)) continue;
            try {
                radiationMap.put(item, Double.parseDouble(split[1].trim()) / 1.0E9);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        for (String name : Materials.isotopes()) {
            for (String type : List.of("", "_ox", "_ni", "_za", "_tr")) {
                ItemRadiation.add(name + type, (double)Materials.isotopes.get(name));
            }
        }
        ItemRadiation.add(NcUtils.getNCBlock("americium241").m_5456_(), 0.01);
        ItemRadiation.add(NcUtils.getNCBlock("uranium238").m_5456_(), 5.0E-6);
        ItemRadiation.add(NcUtils.getNCBlock("californium250").m_5456_(), 3.0);
        ItemRadiation.add(NcUtils.getNCBlock("plutonium238").m_5456_(), 0.034);
        for (String name : FuelManager.all().keySet()) {
            for (String subType : FuelManager.all().get(name).keySet()) {
                for (String type : List.of("", "ox", "ni", "za", "tr")) {
                    isotope1Cnt = 1;
                    isotope2Cnt = 8;
                    if (subType.substring(0, 1).equalsIgnoreCase("h")) {
                        isotope1Cnt = 3;
                        isotope2Cnt = 6;
                    }
                    isotope1 = ItemRadiation.getIsotope(name, String.valueOf(FuelManager.all().get((Object)name).get((Object)subType).getDefault().isotopes[0]), type);
                    isotope2 = ItemRadiation.getIsotope(name, String.valueOf(FuelManager.all().get((Object)name).get((Object)subType).getDefault().isotopes[1]), type);
                    radiation = ItemRadiation.byItem(isotope1) * (double)isotope1Cnt + ItemRadiation.byItem(isotope2) * (double)isotope2Cnt;
                    ItemRadiation.add((Item)Fuel.NC_FUEL.get(List.of("fuel", name, subType, type)).get(), radiation / 2.0);
                }
            }
        }
        for (String name : FuelManager.all().keySet()) {
            for (String subType : FuelManager.all().get(name).keySet()) {
                for (String type : List.of("", "ox", "ni", "za", "tr")) {
                    isotope1Cnt = 1;
                    isotope2Cnt = 8;
                    if (subType.substring(0, 1).equalsIgnoreCase("h")) {
                        isotope1Cnt = 3;
                        isotope2Cnt = 6;
                    }
                    isotope1 = ItemRadiation.getIsotope(name, String.valueOf(FuelManager.all().get((Object)name).get((Object)subType).getDefault().isotopes[0]), type);
                    isotope2 = ItemRadiation.getIsotope(name, String.valueOf(FuelManager.all().get((Object)name).get((Object)subType).getDefault().isotopes[1]), type);
                    radiation = ItemRadiation.byItem(isotope1) * (double)isotope1Cnt + ItemRadiation.byItem(isotope2) * (double)isotope2Cnt;
                    ItemRadiation.add((Item)Fuel.NC_DEPLETED_FUEL.get(List.of("depleted", name, subType, type)).get(), radiation / 1.5);
                }
            }
        }
    }

    public static Item getIsotope(String name, String id, String type) {
        if (!((String)type).isEmpty()) {
            type = "_" + (String)type;
        }
        if (!Fuel.NC_ISOTOPES.containsKey(name + "/" + id + (String)type)) {
            for (String isotope : Fuel.NC_ISOTOPES.keySet()) {
                if (!isotope.contains(id)) continue;
                return (Item)Fuel.NC_ISOTOPES.get(isotope).get();
            }
        }
        return (Item)Fuel.NC_ISOTOPES.get(name + "/" + id + (String)type).get();
    }

    public static void add(String item, double radiation) {
        Item toAdd = ItemRadiation.getItemByName(item);
        if (toAdd.equals(Items.f_41852_)) {
            return;
        }
        radiationMap.put(toAdd, radiation);
    }

    public static void add(Item item, double radiation) {
        radiationMap.put(item, radiation);
    }

    public static Item getItemByName(String name) {
        if (!((String)name).contains(":")) {
            name = "nuclearcraft:" + (String)name;
        }
        ResourceLocation itemKey = new ResourceLocation(((String)name).replace("/", "_"));
        return (Item)ForgeRegistries.ITEMS.getValue(itemKey);
    }

    public static double byItem(Item item) {
        if (!initialized) {
            ItemRadiation.init();
            initialized = true;
        }
        if (radiationMap.containsKey(item)) {
            return radiationMap.get(item);
        }
        return 0.0;
    }
}

